/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import galaxyspace.GalaxySpace;
import galaxyspace.api.IBodies;
import galaxyspace.core.GSBlocks;
import galaxyspace.core.GSFluids;
import galaxyspace.core.GSItems;
import galaxyspace.core.client.GSKeyHandlerClient;
import galaxyspace.core.client.fx.GSEffectHandler;
import galaxyspace.core.client.models.BakedModelBrightFour;
import galaxyspace.core.client.models.BakedModelFullbright;
import galaxyspace.core.client.render.entity.RenderCargoRockets;
import galaxyspace.core.client.render.entity.RenderEvolvedColdBlaze;
import galaxyspace.core.client.render.entity.RenderIceSpike;
import galaxyspace.core.client.render.entity.RenderRockets;
import galaxyspace.core.client.render.entity.layers.LayerOxygenTank;
import galaxyspace.core.client.render.entity.layers.LayerThermalPadding;
import galaxyspace.core.client.render.item.ItemModelRocketT4;
import galaxyspace.core.client.render.item.ItemModelRocketT5;
import galaxyspace.core.client.render.item.ItemModelRocketT6;
import galaxyspace.core.client.render.tile.TileEntityTreasureChestRenderer;
import galaxyspace.core.events.GSClientTickHandler;
import galaxyspace.core.handler.GSMapHandler;
import galaxyspace.core.handler.GSSkyProviderHandler;
import galaxyspace.core.prefab.blocks.DungeonBlocks;
import galaxyspace.core.prefab.entities.EntityCustomCargoRocket;
import galaxyspace.core.prefab.entities.EntityEvolvedColdBlaze;
import galaxyspace.core.prefab.entities.EntityIceSpike;
import galaxyspace.core.prefab.entities.EntityTier4Rocket;
import galaxyspace.core.prefab.entities.EntityTier5Rocket;
import galaxyspace.core.prefab.entities.EntityTier6Rocket;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.moons.callisto.blocks.CallistoBlocks;
import galaxyspace.systems.SolarSystem.moons.enceladus.blocks.EnceladusBlocks;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystall;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.systems.SolarSystem.moons.europa.blocks.EuropaBlocks;
import galaxyspace.systems.SolarSystem.moons.ganymede.blocks.GanymedeBlocks;
import galaxyspace.systems.SolarSystem.moons.io.blocks.IoBlocks;
import galaxyspace.systems.SolarSystem.moons.io.entities.EntityBossGhast;
import galaxyspace.systems.SolarSystem.moons.io.renderer.entities.RenderBossGhast;
import galaxyspace.systems.SolarSystem.moons.io.tile.TileEntityTreasureChestIo;
import galaxyspace.systems.SolarSystem.moons.miranda.blocks.MirandaBlocks;
import galaxyspace.systems.SolarSystem.moons.titan.blocks.TitanBlocks;
import galaxyspace.systems.SolarSystem.moons.triton.blocks.TritonBlocks;
import galaxyspace.systems.SolarSystem.planets.ceres.blocks.CeresBlocks;
import galaxyspace.systems.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.renderer.entities.RenderBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityTreasureChestCeres;
import galaxyspace.systems.SolarSystem.planets.haumea.blocks.HaumeaBlocks;
import galaxyspace.systems.SolarSystem.planets.mars.blocks.MarsOresBlocks;
import galaxyspace.systems.SolarSystem.planets.mars.entities.EntityMarsRover;
import galaxyspace.systems.SolarSystem.planets.mars.render.entities.RenderMarsRover;
import galaxyspace.systems.SolarSystem.planets.mars.render.item.ItemModelMarsRover;
import galaxyspace.systems.SolarSystem.planets.mercury.blocks.MercuryBlocks;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockDecoMetals;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockFutureGlasses;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockMachineFrames;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockOres;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockSurfaceIce;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemCompressedPlates;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemHeavyDutyPlates;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemIngots;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemRocketModules;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemRocketParts;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemSchematics;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemTierKeysChest;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemUpgrades;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemThermalPaddingBase;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererJetpack;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityHydroponicFarmRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityModernSolarPanelRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntitySolarWindPanelRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityWindGeneratorRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModernSolarPanel;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindSolarPanel;
import galaxyspace.systems.SolarSystem.planets.pluto.blocks.PlutoBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import micdoodle8.mods.galacticraft.api.client.IItemMeshDefinitionCustom;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ModelTransformWrapper;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelCargoRocket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientProxy
extends CommonProxy {
    public static Map<String, String> GScapeMap = new HashMap<String, String>();
    public static Map<String, ResourceLocation> GScapesMap = Maps.newHashMap();
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    private static ModelResourceLocation LEMethaneLocation = new ModelResourceLocation("galaxyspace:liquid_ethanemethane", "fluid");
    private static ModelResourceLocation HeliumLocation = new ModelResourceLocation("galaxyspace:liquid_helium", "fluid");
    private static ModelResourceLocation HeliumHydrogenLocation = new ModelResourceLocation("galaxyspace:liquid_heliumhydrogen", "fluid");
    private static ModelResourceLocation EthaneLocation = new ModelResourceLocation("galaxyspace:liquid_ethane", "fluid");

    @Override
    public void preload(FMLPreInitializationEvent event) {
        this.register_event(new GSSkyProviderHandler());
        this.register_event(new GSClientTickHandler());
        this.register_event(new GSMapHandler());
        this.register_event((Object)new GSKeyHandlerClient());
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleHelmet);
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleChest);
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleLegs);
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleBoots);
        ClientProxy.registerEntityRenderers();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void load() {
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")).func_177094_a((LayerRenderer)new LayerOxygenTank());
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")).func_177094_a((LayerRenderer)new LayerOxygenTank());
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")).func_177094_a((LayerRenderer)new LayerThermalPadding(Minecraft.func_71410_x().func_175598_ae().field_178637_m));
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")).func_177094_a((LayerRenderer)new LayerThermalPadding(Minecraft.func_71410_x().func_175598_ae().field_178637_m));
    }

    @Override
    public void postload() {
        ItemSchematics.registerTextures();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityModernSolarPanel.class, (TileEntitySpecialRenderer)new TileEntityModernSolarPanelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindGenerator.class, (TileEntitySpecialRenderer)new TileEntityWindGeneratorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHydroponicFarm.class, (TileEntitySpecialRenderer)new TileEntityHydroponicFarmRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestCeres.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer(new ResourceLocation("galaxyspace", "textures/model/treasure_ceres.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestIo.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer(new ResourceLocation("galaxyspace", "textures/model/treasure_io.png")));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockCrystallTE.class, (TileEntitySpecialRenderer)new TileEntityBlockCrystall());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindSolarPanel.class, (TileEntitySpecialRenderer)new TileEntitySolarWindPanelRenderer());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBakeEvent(ModelBakeEvent event) {
        Quat4f rot = TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(30.0f, 225.0f, 0.0f));
        this.replaceModelDefault(event, "hydroponic_farm", "hydroponic_farm.obj", (List<String>)ImmutableList.of((Object)"ferma_2"), ItemRendererHydroponicFarm.class, (IModelState)new TRSRTransformation(new Vector3f(0.7f, 0.1f, 0.0f), rot, new Vector3f(0.2604f, 0.2604f, 0.2604f), new Quat4f()), "inventory", "normal");
        this.replaceModelDefault(event, "rockets/rocket_t4", "tier4rocketGS.obj", (List<String>)ImmutableList.of((Object)"Base", (Object)"NoseCone", (Object)"Rocket", (Object)"Booster1", (Object)"Booster2", (Object)"Booster3", (Object)"Booster4"), ItemModelRocketT4.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "rockets/rocket_t5", "tier5rocket.obj", (List<String>)ImmutableList.of((Object)"Base"), ItemModelRocketT5.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "rockets/rocket_t6", "tier6rocket.obj", (List<String>)ImmutableList.of((Object)"Base"), ItemModelRocketT6.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "rockets/rocket_cargo", "cargo_rocket.obj", (List<String>)ImmutableList.of((Object)"Rocket"), ItemModelCargoRocket.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "mars_rover", "mars_rover.obj", (List<String>)ImmutableList.of((Object)"base", (Object)"ltR", (Object)"ltL", (Object)"ltR.001", (Object)"ltL.001", (Object)"frontbase", (Object)"backbase", (Object)"frontWheelL", (Object)"frontWheelR", (Object)"backWheelL", (Object)"backWheelR"), ItemModelMarsRover.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "armor/jetpack", "jetpack.obj", (List<String>)ImmutableList.of((Object)"wing1", (Object)"wing2", (Object)"corp"), ItemRendererJetpack.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        if (!FMLClientHandler.instance().hasOptifine()) {
            for (ModelResourceLocation resource : event.getModelRegistry().func_148742_b()) {
                if (!resource.func_110624_b().equals("galaxyspace")) continue;
                if (resource.func_110623_a().equals("dungeon_blocks")) {
                    if (resource.func_177518_c().contains("ceres_bricks")) {
                        event.getModelRegistry().func_82595_a((Object)resource, (Object)new BakedModelFullbright((IBakedModel)event.getModelRegistry().func_82594_a((Object)resource), "galaxyspace:blocks/solarsystem/ceres/ceres_bricks_layer", 250, 0.45));
                        continue;
                    }
                    if (resource.func_177518_c().contains("io_bricks")) {
                        event.getModelRegistry().func_82595_a((Object)resource, (Object)new BakedModelFullbright((IBakedModel)event.getModelRegistry().func_82594_a((Object)resource), "galaxyspace:blocks/solarsystem/io/io_bricks_layer", 250, 1.0));
                        continue;
                    }
                }
                if (!resource.func_110623_a().equals("barnarda_c_test_glow_log")) continue;
                String top = "galaxyspace:blocks/barnardssystem/barnarda_c/log_oak_top";
                event.getModelRegistry().func_82595_a((Object)resource, (Object)new BakedModelBrightFour((IBakedModel)event.getModelRegistry().func_82594_a((Object)resource), "galaxyspace:blocks/barnardssystem/barnarda_c/log_oak_layer", top, 250, 1.0));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre event) {
        GalaxySpace.proxy.registerTexture(event, "model/modern_solarpanel");
        GalaxySpace.proxy.registerTexture(event, "model/armor/spacesuit");
        GalaxySpace.proxy.registerTexture(event, "model/armor/jetpack");
        GalaxySpace.proxy.registerTexture(event, "model/hydroponic_farm");
        GalaxySpace.proxy.registerTexture(event, "model/rocket_tier_4");
        GalaxySpace.proxy.registerTexture(event, "model/rocket_tier_4_launch");
        GalaxySpace.proxy.registerTexture(event, "model/rocket_tier_5");
        GalaxySpace.proxy.registerTexture(event, "model/rocket_tier_6");
        GalaxySpace.proxy.registerTexture(event, "model/cargo_rocket");
        GalaxySpace.proxy.registerTexture(event, "model/mars_rover");
        if (!FMLClientHandler.instance().hasOptifine()) {
            GalaxySpace.proxy.registerTexture(event, "blocks/solarsystem/ceres/ceres_bricks_layer");
            GalaxySpace.proxy.registerTexture(event, "blocks/solarsystem/io/io_bricks_layer");
            GalaxySpace.proxy.registerTexture(event, "blocks/barnardssystem/barnarda_c/log_oak_layer");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onStitch(TextureStitchEvent.Post event) {
        GSUtils.initFluidTextures(event.getMap());
    }

    @Override
    public void registerTexture(TextureStitchEvent.Pre event, String texture) {
        event.getMap().func_174942_a(new ResourceLocation("galaxyspace:" + texture));
    }

    private void replaceModelDefault(ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        ClientUtil.replaceModel((String)"galaxyspace", (ModelBakeEvent)event, (String)resLoc, (String)objLoc, visibleGroups, clazz, (IModelState)parentState, (String[])variants);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerRender() {
        void var5_64;
        void var5_62;
        void var5_60;
        void var5_58;
        void var5_56;
        void var5_54;
        void var5_52;
        void var5_50;
        void var5_48;
        String[] name = new String[4];
        for (MercuryBlocks.EnumBlockMercury enumBlockMercury : MercuryBlocks.EnumBlockMercury.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MERCURY_BLOCKS, (int)enumBlockMercury.getMeta(), (String)enumBlockMercury.func_176610_l());
        }
        for (Enum enum_ : BlockFutureGlasses.EnumBlockFutureGlass.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.FUTURE_GLASS_COLORED, (int)((BlockFutureGlasses.EnumBlockFutureGlass)enum_).getMeta(), (String)((BlockFutureGlasses.EnumBlockFutureGlass)enum_).func_176610_l());
        }
        for (Enum enum_ : BlockOres.EnumBlockOres.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.OVERWORLD_ORES, (int)((BlockOres.EnumBlockOres)enum_).getMeta(), (String)((BlockOres.EnumBlockOres)enum_).func_176610_l());
        }
        for (Enum enum_ : BlockDecoMetals.EnumBlockDecoMetals.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.DECO_METALS, (int)((BlockDecoMetals.EnumBlockDecoMetals)enum_).getMeta(), (String)((BlockDecoMetals.EnumBlockDecoMetals)enum_).func_176610_l());
        }
        for (Enum enum_ : MarsOresBlocks.EnumMarsOresBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MARS_ORES, (int)((MarsOresBlocks.EnumMarsOresBlocks)enum_).getMeta(), (String)((MarsOresBlocks.EnumMarsOresBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : CeresBlocks.EnumCeresBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.CERES_BLOCKS, (int)((CeresBlocks.EnumCeresBlocks)enum_).getMeta(), (String)((CeresBlocks.EnumCeresBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : PlutoBlocks.EnumPlutoBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.PLUTO_BLOCKS, (int)((PlutoBlocks.EnumPlutoBlocks)enum_).getMeta(), (String)((PlutoBlocks.EnumPlutoBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : HaumeaBlocks.EnumHaumeaBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.HAUMEA_BLOCKS, (int)((HaumeaBlocks.EnumHaumeaBlocks)enum_).getMeta(), (String)((HaumeaBlocks.EnumHaumeaBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : IoBlocks.EnumIoBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.IO_BLOCKS, (int)((IoBlocks.EnumIoBlocks)enum_).getMeta(), (String)((IoBlocks.EnumIoBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : EuropaBlocks.EnumEuropaBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.EUROPA_BLOCKS, (int)((EuropaBlocks.EnumEuropaBlocks)enum_).getMeta(), (String)((EuropaBlocks.EnumEuropaBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : GanymedeBlocks.EnumGanymedeBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.GANYMEDE_BLOCKS, (int)((GanymedeBlocks.EnumGanymedeBlocks)enum_).getMeta(), (String)((GanymedeBlocks.EnumGanymedeBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : CallistoBlocks.EnumCallistoBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.CALLISTO_BLOCKS, (int)((CallistoBlocks.EnumCallistoBlocks)enum_).getMeta(), (String)((CallistoBlocks.EnumCallistoBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : EnceladusBlocks.EnumEnceladusBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ENCELADUS_BLOCKS, (int)((EnceladusBlocks.EnumEnceladusBlocks)enum_).getMeta(), (String)((EnceladusBlocks.EnumEnceladusBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : TitanBlocks.EnumTitanBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.TITAN_BLOCKS, (int)((TitanBlocks.EnumTitanBlocks)enum_).getMeta(), (String)((TitanBlocks.EnumTitanBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : MirandaBlocks.EnumMirandaBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MIRANDA_BLOCKS, (int)((MirandaBlocks.EnumMirandaBlocks)enum_).getMeta(), (String)((MirandaBlocks.EnumMirandaBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : TritonBlocks.EnumTritonBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.TRITON_BLOCKS, (int)((TritonBlocks.EnumTritonBlocks)enum_).getMeta(), (String)((TritonBlocks.EnumTritonBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : BlockMachineFrames.EnumBlockMachineFrames.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MACHINE_FRAMES, (int)((BlockMachineFrames.EnumBlockMachineFrames)enum_).getMeta(), (String)((BlockMachineFrames.EnumBlockMachineFrames)enum_).func_176610_l());
        }
        for (Enum enum_ : DungeonBlocks.EnumDungeonBlocks.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.DUNGEON_BLOCKS, (int)((DungeonBlocks.EnumDungeonBlocks)enum_).getMeta(), (String)((DungeonBlocks.EnumDungeonBlocks)enum_).func_176610_l());
        }
        for (Enum enum_ : BlockSurfaceIce.EnumBlockIce.values()) {
            ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.SURFACE_ICE, (int)((BlockSurfaceIce.EnumBlockIce)enum_).getMeta(), (String)((BlockSurfaceIce.EnumBlockIce)enum_).func_176610_l());
        }
        name = new String[HaumeaBlocks.EnumHaumeaBlocks.values().length];
        for (Enum enum_ : HaumeaBlocks.EnumHaumeaBlocks.values()) {
            if (((HaumeaBlocks.EnumHaumeaBlocks)enum_).func_176610_l() == null) continue;
            name[((HaumeaBlocks.EnumHaumeaBlocks)enum_).getMeta()] = ((HaumeaBlocks.EnumHaumeaBlocks)enum_).func_176610_l();
        }
        if (GCCoreUtil.isDeobfuscated()) {
            GSUtils.addBlockMetadataJsonFiles(GSBlocks.HAUMEA_BLOCKS, name, HaumeaBlocks.BASIC_TYPE.func_177701_a(), "");
        }
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ASSEMBLER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.FUEL_GENERATOR);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MODERN_SOLAR_PANEL);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.FUTURE_GLASS_BASIC);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.EUROPA_GEYSER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.EUROPA_UWGEYSER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.WIND_GENERATOR);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ROCKET_ASSEMBLER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.UNIVERSAL_RECYCLER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.LIQUID_EXTRACTOR);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.LIQUID_SEPARATOR);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.HYDROPONIC_BASE);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.HYDROPONIC_FARM);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.GRAVITATION_MODULE);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.BOSS_SPAWNER_CERES);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.BOSS_SPAWNER_IO);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.TREASURE_CHEST_TIER_4, (int)0, (String)"treasure_t4");
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.TREASURE_CHEST_TIER_5, (int)0, (String)"treasure_t5");
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.RADIATION_STABILISER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ENCELADUS_CRYSTAL);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.PANEL_CONTROLLER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.SINGLE_SOLARPANEL);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MODERN_SINGLE_SOLARPANEL);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.PLANET_SHIELD);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MODERN_STORAGE_MODULE);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ADVANCED_LANDING_PAD_SINGLE);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ADVANCED_LANDING_PAD);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.FAKE_BLOCK);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.MODIFICATION_TABLE);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.GAS_BURNER);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.OXYGEN_STORAGE_MODULE);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.SOLARWIND_PANEL);
        ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)GSBlocks.ADVANCED_CIRCUIT_FABRICATOR);
        if (GCCoreUtil.isDeobfuscated()) {
            // empty if block
        }
        int i = 0;
        Object object = ItemBasicGS.names;
        int n = ((String[])object).length;
        boolean bl = false;
        while (var5_48 < n) {
            String basic = object[var5_48];
            if (basic.equals("null")) {
                ++i;
            } else {
                ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.BASIC, (int)i++, (String)("basic/" + basic));
            }
            ++var5_48;
        }
        i = 0;
        object = ItemIngots.names;
        n = ((String[])object).length;
        boolean bl2 = false;
        while (var5_50 < n) {
            String ingots = object[var5_50];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.INGOTS, (int)i++, (String)("ingots/" + ingots));
            ++var5_50;
        }
        i = 0;
        object = ItemHeavyDutyPlates.names;
        n = ((String[])object).length;
        boolean bl3 = false;
        while (var5_52 < n) {
            String hdp = object[var5_52];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.HDP, (int)i++, (String)("hdp/" + hdp));
            ++var5_52;
        }
        i = 0;
        object = ItemCompressedPlates.names;
        n = ((String[])object).length;
        boolean bl4 = false;
        while (var5_54 < n) {
            String plates = object[var5_54];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COMPRESSED_PLATES, (int)i++, (String)("compressed_plates/" + plates));
            ++var5_54;
        }
        i = 0;
        object = ItemRocketModules.names;
        n = ((String[])object).length;
        boolean bl5 = false;
        while (var5_56 < n) {
            String modules = object[var5_56];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.ROCKET_MODULES, (int)i++, (String)("rocket_modules/" + modules));
            ++var5_56;
        }
        i = 0;
        object = ItemRocketParts.names;
        n = ((String[])object).length;
        boolean bl6 = false;
        while (var5_58 < n) {
            String parts = object[var5_58];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.ROCKET_PARTS, (int)i++, (String)("rocket_parts/" + parts));
            ++var5_58;
        }
        i = 0;
        object = ItemTierKeysChest.keys;
        n = ((String[])object).length;
        boolean bl7 = false;
        while (var5_60 < n) {
            String keys = object[var5_60];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.DUNGEON_KEYS, (int)i++, (String)("keys/" + keys));
            ++var5_60;
        }
        i = 0;
        object = ItemUpgrades.names;
        n = ((String[])object).length;
        boolean bl8 = false;
        while (var5_62 < n) {
            String upgrades = object[var5_62];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.UPGRADES, (int)i++, (String)("upgrades/" + upgrades));
            ++var5_62;
        }
        i = 0;
        object = ItemThermalPaddingBase.names;
        n = ((String[])object).length;
        boolean bl9 = false;
        while (var5_64 < n) {
            String thermal_padding = object[var5_64];
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.THERMAL_PADDING_3, (int)i, (String)("thermal_padding/" + thermal_padding + "_t" + ((ItemThermalPaddingBase)GSItems.THERMAL_PADDING_3).getThermalStrength()));
            ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.THERMAL_PADDING_4, (int)i, (String)("thermal_padding/" + thermal_padding + "_t" + ((ItemThermalPaddingBase)GSItems.THERMAL_PADDING_4).getThermalStrength()));
            ++i;
            ++var5_64;
        }
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.OXYGENTANK_TIER_4);
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.OXYGENTANK_TIER_5);
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.OXYGENTANK_TIER_6);
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.OXYGENTANK_TIER_EPP);
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.ADVANCED_BATTERY, (int)0, (String)("batteries/" + GSItems.ADVANCED_BATTERY.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.MODERN_BATTERY, (int)0, (String)("batteries/" + GSItems.MODERN_BATTERY.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.EXTRA_BATTERY, (int)0, (String)("batteries/" + GSItems.EXTRA_BATTERY.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.ULTIMATE_BATTERY, (int)0, (String)("batteries/" + GSItems.ULTIMATE_BATTERY.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SPACE_SUIT_HELMET, (int)0, (String)("armor/" + GSItems.SPACE_SUIT_HELMET.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SPACE_SUIT_BODY, (int)0, (String)("armor/" + GSItems.SPACE_SUIT_BODY.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SPACE_SUIT_LEGGINS, (int)0, (String)("armor/" + GSItems.SPACE_SUIT_LEGGINS.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SPACE_SUIT_BOOTS, (int)0, (String)("armor/" + GSItems.SPACE_SUIT_BOOTS.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.JETPACK, (int)0, (String)("armor/" + GSItems.JETPACK.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.MATTER_MANIPULATOR, (int)0, (String)("tools/" + GSItems.MATTER_MANIPULATOR.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.GEOLOGICAL_SCANNER, (int)0, (String)("tools/" + GSItems.GEOLOGICAL_SCANNER.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_HELMET, (int)0, (String)("armor/" + GSItems.COBALT_HELMET.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_CHEST, (int)0, (String)("armor/" + GSItems.COBALT_CHEST.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_LEGS, (int)0, (String)("armor/" + GSItems.COBALT_LEGS.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_BOOTS, (int)0, (String)("armor/" + GSItems.COBALT_BOOTS.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_SWORD, (int)0, (String)("tools/" + GSItems.COBALT_SWORD.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_AXE, (int)0, (String)("tools/" + GSItems.COBALT_AXE.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_PICKAXE, (int)0, (String)("tools/" + GSItems.COBALT_PICKAXE.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_SPADE, (int)0, (String)("tools/" + GSItems.COBALT_SPADE.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.COBALT_HOE, (int)0, (String)("tools/" + GSItems.COBALT_HOE.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.PLASMA_SWORD, (int)0, (String)("tools/" + GSItems.PLASMA_SWORD.func_77658_a().substring(5)));
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)0, (String)"schematics/schematic_cone");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)1, (String)"schematics/schematic_body");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)2, (String)"schematics/schematic_engine");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)3, (String)"schematics/schematic_booster");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)4, (String)"schematics/schematic_stabiliser");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)5, (String)"schematics/schematic_oxygen_tank");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.SCHEMATICS, (int)6, (String)"schematics/schematic_port_nuclear_reactor");
        ClientUtil.registerItemJson((String)"galaxyspace:", (Item)GSItems.MARS_ROVER, (int)0, (String)"mars_rover");
        if (GCCoreUtil.isDeobfuscated()) {
            GSUtils.addItemMetadataJsonFiles(GSItems.BASIC, ItemBasicGS.names, "basic/");
        }
        for (IBodies list : GalaxySpace.bodies) {
            if (!list.canRegister()) continue;
            list.registerRender();
        }
    }

    @Override
    public void registerVariants() {
        int i;
        int i2;
        String[] blocks = new String[BlockFutureGlasses.EnumBlockFutureGlass.values().length];
        for (i2 = 0; i2 < blocks.length; ++i2) {
            blocks[i2] = BlockFutureGlasses.EnumBlockFutureGlass.byMetadata(i2).func_176610_l();
        }
        ClientProxy.addVariant("futureglass", "", blocks);
        ClientProxy.addVariant("mercuryblocks", "", "mercury_surface", "mercury_subsurface", "mercury_stone", "mercury_nickel_ore", "mercury_iron_ore", "mercury_magnesium_ore");
        ClientProxy.addVariant("gsores", "", "cobaltum_ore", "nickel_ore", "uranium_ore");
        ClientProxy.addVariant("decoblocks", "", "deco_cobaltum", "deco_magnesium", "deco_nickel", "deco_copper", "cobalt_block", "nickel_block", "magnesium_block");
        ClientProxy.addVariant("marsores", "", "mars_diamond", "mars_gold", "mars_coal", "mars_redstone", "mars_silicon", "mars_aluminum");
        ClientProxy.addVariant("ceresblocks", "", "ceres_grunt", "ceres_subgrunt", "ceres_dolomite_ore", "ceres_meteoriciron_ore", "ceres_dungeon_top", "ceres_dungeon_floor");
        ClientProxy.addVariant("plutoblocks", "", "pluto_grunt_1", "pluto_grunt_2", "pluto_grunt_3", "pluto_grunt_4", "pluto_subgrunt", "pluto_stone");
        ClientProxy.addVariant("ioblocks", "", "io_grunt", "io_stone", "io_ash", "io_copper_ore", "io_sulfur_ore", "io_volcanic_ore", "io_lava_geyser", "io_sulfur_geyser", "io_top", "io_floor", "io_dungeon_bricks");
        ClientProxy.addVariant("europablocks", "", "europa_grunt", "europa_stone", "europa_brown_ice", "europa_emerald_ore", "europa_silicon_ore", "europa_aluminum_ore");
        ClientProxy.addVariant("ganymedeblocks", "", "ganymede_grunt", "ganymede_stone", "ganymede_magnesium_ore", "ganymede_titanium_ore");
        ClientProxy.addVariant("callistoblocks", "", "callisto_grunt", "callisto_stone");
        ClientProxy.addVariant("enceladusblocks", "", "enceladus_snow", "enceladus_grunt", "enceladus_coal_ore");
        blocks = new String[TitanBlocks.EnumTitanBlocks.values().length];
        for (i2 = 0; i2 < blocks.length; ++i2) {
            blocks[i2] = TitanBlocks.EnumTitanBlocks.byMetadata(i2).func_176610_l();
        }
        ClientProxy.addVariant("titanblocks", "", blocks);
        blocks = new String[MirandaBlocks.EnumMirandaBlocks.values().length];
        for (i2 = 0; i2 < blocks.length; ++i2) {
            blocks[i2] = MirandaBlocks.EnumMirandaBlocks.byMetadata(i2).func_176610_l();
        }
        ClientProxy.addVariant("mirandablocks", "", blocks);
        blocks = new String[TritonBlocks.EnumTritonBlocks.values().length];
        for (i2 = 0; i2 < blocks.length; ++i2) {
            blocks[i2] = TritonBlocks.EnumTritonBlocks.byMetadata(i2).func_176610_l();
        }
        ClientProxy.addVariant("tritonblocks", "", blocks);
        blocks = new String[HaumeaBlocks.EnumHaumeaBlocks.values().length];
        for (i2 = 0; i2 < blocks.length; ++i2) {
            blocks[i2] = HaumeaBlocks.EnumHaumeaBlocks.byMetadata(i2).func_176610_l();
        }
        ClientProxy.addVariant("haumeablocks", "", blocks);
        blocks = new String[BlockSurfaceIce.EnumBlockIce.values().length];
        for (i2 = 0; i2 < blocks.length; ++i2) {
            blocks[i2] = BlockSurfaceIce.EnumBlockIce.byMetadata(i2).func_176610_l();
        }
        ClientProxy.addVariant("surface_ice", "", blocks);
        ClientProxy.addVariant("machineframes", "", "basic_frame", "advance_frame", "modern_frame");
        ClientProxy.addVariant("dungeon_blocks", "", "ceres_bricks", "io_bricks");
        Item sludge = Item.func_150898_a((Block)GSFluids.BLOCK_LEMETHANE);
        ModelBakery.registerItemVariants((Item)sludge, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("galaxyspace:liquid_ethanemethane")});
        ModelLoader.setCustomMeshDefinition((Item)sludge, (ItemMeshDefinition)IItemMeshDefinitionCustom.create(stack -> LEMethaneLocation));
        ModelLoader.setCustomStateMapper((Block)GSFluids.BLOCK_LEMETHANE, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return LEMethaneLocation;
            }
        });
        sludge = Item.func_150898_a((Block)GSFluids.BLOCK_HELIUM3);
        ModelBakery.registerItemVariants((Item)sludge, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("galaxyspace:liquid_helium")});
        ModelLoader.setCustomMeshDefinition((Item)sludge, (ItemMeshDefinition)IItemMeshDefinitionCustom.create(stack -> HeliumLocation));
        ModelLoader.setCustomStateMapper((Block)GSFluids.BLOCK_HELIUM3, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return HeliumLocation;
            }
        });
        sludge = Item.func_150898_a((Block)GSFluids.BLOCK_HELIUM_HYDROGEN);
        ModelBakery.registerItemVariants((Item)sludge, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("galaxyspace:liquid_heliumhydrogen")});
        ModelLoader.setCustomMeshDefinition((Item)sludge, (ItemMeshDefinition)IItemMeshDefinitionCustom.create(stack -> HeliumHydrogenLocation));
        ModelLoader.setCustomStateMapper((Block)GSFluids.BLOCK_HELIUM_HYDROGEN, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return HeliumHydrogenLocation;
            }
        });
        sludge = Item.func_150898_a((Block)GSFluids.BLOCK_ETHANE);
        ModelBakery.registerItemVariants((Item)sludge, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("galaxyspace:liquid_ethane")});
        ModelLoader.setCustomMeshDefinition((Item)sludge, (ItemMeshDefinition)IItemMeshDefinitionCustom.create(stack -> EthaneLocation));
        ModelLoader.setCustomStateMapper((Block)GSFluids.BLOCK_ETHANE, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return EthaneLocation;
            }
        });
        ClientProxy.addVariant("cobalt_sword", "tools/", "cobalt_sword");
        ClientProxy.addVariant("cobalt_axe", "tools/", "cobalt_axe");
        ClientProxy.addVariant("cobalt_pickaxe", "tools/", "cobalt_pickaxe");
        ClientProxy.addVariant("cobalt_spade", "tools/", "cobalt_spade");
        ClientProxy.addVariant("cobalt_hoe", "tools/", "cobalt_hoe");
        ClientProxy.addVariant("advanced_battery", "batteries/", "advanced_battery");
        ClientProxy.addVariant("modern_battery", "batteries/", "modern_battery");
        ClientProxy.addVariant("extra_battery", "batteries/", "extra_battery");
        ClientProxy.addVariant("ultimate_battery", "batteries/", "ultimate_battery");
        ClientProxy.addVariant("space_suit_head", "armor/", "space_suit_head");
        ClientProxy.addVariant("space_suit_chest", "armor/", "space_suit_chest");
        ClientProxy.addVariant("space_suit_legs", "armor/", "space_suit_legs");
        ClientProxy.addVariant("space_suit_feet", "armor/", "space_suit_feet");
        ClientProxy.addVariant("jetpack", "armor/", "jetpack");
        ClientProxy.addVariant("geo_scanner", "tools/", "geo_scanner");
        ClientProxy.addVariant("cobalt_helmet", "armor/", "cobalt_helmet");
        ClientProxy.addVariant("cobalt_chest", "armor/", "cobalt_chest");
        ClientProxy.addVariant("cobalt_legs", "armor/", "cobalt_legs");
        ClientProxy.addVariant("cobalt_boots", "armor/", "cobalt_boots");
        ClientProxy.addVariant("gs_basic", "basic/", ItemBasicGS.names);
        ClientProxy.addVariant("ingots", "ingots/", ItemIngots.names);
        ClientProxy.addVariant("hdp", "hdp/", ItemHeavyDutyPlates.names);
        ClientProxy.addVariant("compressed_plates", "compressed_plates/", ItemCompressedPlates.names);
        ClientProxy.addVariant("rocket_modules", "rocket_modules/", ItemRocketModules.names);
        ClientProxy.addVariant("rocket_parts", "rocket_parts/", ItemRocketParts.names);
        ClientProxy.addVariant("schematics", "schematics/", "schematic_cone", "schematic_body", "schematic_engine", "schematic_booster", "schematic_stabiliser", "schematic_oxygen_tank", "schematic_port_nuclear_reactor");
        ClientProxy.addVariant("dungeon_keys", "keys/", ItemTierKeysChest.keys);
        ClientProxy.addVariant("upgrades", "upgrades/", ItemUpgrades.names);
        ClientProxy.addVariant("thermal_padding_t3", "thermal_padding/", "thermal_helm_t3", "thermal_chestplate_t3", "thermal_leggings_t3", "thermal_boots_t3");
        ClientProxy.addVariant("thermal_padding_t4", "thermal_padding/", "thermal_helm_t4", "thermal_chestplate_t4", "thermal_leggings_t4", "thermal_boots_t4");
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("galaxyspace:rockets/rocket_t4", "inventory");
        for (i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)GSItems.ROCKET_TIER_4, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        modelResourceLocation = new ModelResourceLocation("galaxyspace:rockets/rocket_t5", "inventory");
        for (i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)GSItems.ROCKET_TIER_5, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        modelResourceLocation = new ModelResourceLocation("galaxyspace:rockets/rocket_t6", "inventory");
        for (i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)GSItems.ROCKET_TIER_6, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        modelResourceLocation = new ModelResourceLocation("galaxyspace:rockets/rocket_cargo", "inventory");
        for (i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)GSItems.ROCKET_FLUID_CRAGO, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        modelResourceLocation = new ModelResourceLocation("galaxyspace:mars_rover", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)GSItems.MARS_ROVER, (int)0, (ModelResourceLocation)modelResourceLocation);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)GSBlocks.DUNGEON_BLOCKS), (int)0, (ModelResourceLocation)new ModelResourceLocation("galaxyspace:ceres_bricks", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)GSItems.JETPACK, (int)0, (ModelResourceLocation)new ModelResourceLocation("galaxyspace:armor/jetpack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)GSItems.MATTER_MANIPULATOR, (int)0, (ModelResourceLocation)new ModelResourceLocation("galaxyspace:tools/matter_manipulator", "inventory"));
        for (IBodies list : GalaxySpace.bodies) {
            if (!list.canRegister()) continue;
            list.registerVariant();
        }
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), id));
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object[] otherInfo) {
        GSEffectHandler.spawnParticle(particleID, position, motion, otherInfo);
    }

    public static void addVariant(String name, String folder, String ... variants) {
        Item itemBlockVariants = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("galaxyspace", name));
        ResourceLocation[] variants0 = new ResourceLocation[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variants0[i] = new ResourceLocation("galaxyspace:" + folder + variants[i]);
        }
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants0);
    }

    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityTier4Rocket.class, manager -> new RenderRockets(manager, "tier4rocketGS", "Base", "NoseCone", "Rocket", "Booster1", "Booster2", "Booster3", "Booster4"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier5Rocket.class, manager -> new RenderRockets(manager, "tier5rocket", "Base"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier6Rocket.class, manager -> new RenderRockets(manager, "tier6rocket", "Base"));
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomCargoRocket.class, manager -> new RenderCargoRockets(manager, "rockets/rocket_cargo"));
        RenderingRegistry.registerEntityRenderingHandler(EntityBossBlaze.class, manager -> new RenderBossBlaze(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityIceSpike.class, manager -> new RenderIceSpike(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedColdBlaze.class, manager -> new RenderEvolvedColdBlaze(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityBossGhast.class, manager -> new RenderBossGhast(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityMarsRover.class, manager -> new RenderMarsRover(manager));
    }

    @Override
    public void register_event(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
    }
}

