/*
 * Decompiled with CFR 0.152.
 */
package shadows.potion.asm;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import shadows.ApotheosisCore;
import shadows.ApotheosisTransformer;
import shadows.CustomClassWriter;

public class PotionTransformer
implements ApotheosisTransformer.IApotheosisTransformer {
    @Override
    public boolean accepts(String name, String transformedName) {
        return "net.minecraft.entity.EntityLivingBase".equals(transformedName) || "net.minecraft.item.ItemArrow".equals(transformedName) || "net.minecraft.potion.PotionEffect".equals(transformedName);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ApotheosisCore.enablePotion) {
            return basicClass;
        }
        if ("net.minecraft.item.ItemArrow".equals(transformedName)) {
            return PotionTransformer.transformArrow(basicClass);
        }
        if ("net.minecraft.entity.EntityLivingBase".equals(transformedName)) {
            return PotionTransformer.transformEntityLiving(basicClass);
        }
        return PotionTransformer.transformPotionEffect(basicClass);
    }

    static byte[] transformArrow(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming ItemArrow...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode isInfinite = ApotheosisCore.findMethod(classNode, m -> m.name.equals("isInfinite"));
        if (isInfinite != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 2));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 3));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/potion/asm/PotionHooks", "isInfinite", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;)Z", false));
            insn.add((AbstractInsnNode)new InsnNode(172));
            isInfinite.instructions.insert(insn);
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed ItemArrow");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming ItemArrow");
        return basicClass;
    }

    static byte[] transformPotionEffect(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming PotionEffect...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode doesShowParticles = ApotheosisCore.findMethod(classNode, ApotheosisCore::isShowParticles);
        if (doesShowParticles != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/potion/asm/PotionHooks", "doesShowParticles", "(Lnet/minecraft/potion/PotionEffect;)Z", false));
            insn.add((AbstractInsnNode)new InsnNode(172));
            doesShowParticles.instructions.insert(insn);
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed PotionEffect");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming PotionEffect");
        return basicClass;
    }

    static byte[] transformEntityLiving(byte[] basicClass) {
        ApotheosisCore.LOG.info("Transforming EntityLivingBase...");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode applyPotionDamageCalculations = null;
        for (MethodNode m : classNode.methods) {
            if (!ApotheosisCore.isCalcDamage(m)) continue;
            applyPotionDamageCalculations = m;
            break;
        }
        if (applyPotionDamageCalculations != null) {
            InsnList insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insn.add((AbstractInsnNode)new VarInsnNode(23, 2));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "shadows/potion/asm/PotionHooks", "applyPotionDamageCalculations", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/util/DamageSource;F)F", false));
            insn.add((AbstractInsnNode)new InsnNode(174));
            applyPotionDamageCalculations.instructions.insert(insn);
            CustomClassWriter writer = new CustomClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            ApotheosisCore.LOG.info("Successfully transformed EntityLivingBase");
            return writer.toByteArray();
        }
        ApotheosisCore.LOG.info("Failed transforming EntityLivingBase");
        return basicClass;
    }
}

