/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench.objects;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.ApotheosisObjects;

public class BlockHellBookshelf
extends Block {
    public static final PropertyInteger INFUSION = PropertyInteger.func_177719_a((String)"infusion", (int)0, (int)15);

    public BlockHellBookshelf(ResourceLocation name) {
        super(Material.field_151576_e, MapColor.field_151646_E);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("apotheosis.hellshelf");
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return 2.0f + (float)((Integer)state.func_177229_b((IProperty)INFUSION)).intValue() * 0.2f;
        }
        return 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> info, ITooltipFlag flag) {
        info.add(I18n.func_135052_a((String)"info.apotheosis.hellshelf", (Object[])new Object[]{String.valueOf(2.0f + (float)Math.min(15, EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.HELL_INFUSION, (ItemStack)stack)) * 0.2f).substring(0, 3)}));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INFUSION});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)INFUSION, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)INFUSION);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack stack = placer.func_184586_b(hand);
        return this.func_176223_P().func_177226_a((IProperty)INFUSION, (Comparable)Integer.valueOf(Math.min(15, EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.HELL_INFUSION, (ItemStack)stack))));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Block)this);
        if ((Integer)state.func_177229_b((IProperty)INFUSION) > 0) {
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)((Object)ApotheosisObjects.HELL_INFUSION), (Object)state.func_177229_b((IProperty)INFUSION)), (ItemStack)stack);
        }
        drops.add((Object)stack);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)this);
        if ((Integer)state.func_177229_b((IProperty)INFUSION) > 0) {
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)((Object)ApotheosisObjects.HELL_INFUSION), (Object)state.func_177229_b((IProperty)INFUSION)), (ItemStack)stack);
        }
        return stack;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }
}

