/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench.altar;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import shadows.Apotheosis;
import shadows.ApotheosisObjects;
import shadows.ench.EnchModule;
import shadows.ench.EnchantmentInfo;
import shadows.ench.altar.IntCollector;
import shadows.placebo.util.VanillaPacketDispatcher;
import shadows.util.EnchantmentUtils;
import shadows.util.ParticleMessage;

public class TilePrismaticAltar
extends TileEntity
implements ITickable {
    protected ItemStackHandler inv = new ItemStackHandler(5);
    protected float xpDrained = 0.0f;
    protected ItemStack target = ItemStack.field_190927_a;
    protected float targetXP = 0.0f;
    int unusableValue = Integer.MAX_VALUE;
    int soundTick = 0;
    double[][] offsets = new double[][]{{0.1875, 0.1875}, {0.1875, 0.8125}, {0.8125, 0.1875}, {0.8125, 0.8125}};

    public void func_73660_a() {
        int i;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.inv.getStackInSlot(4).func_190926_b()) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (!this.inv.getStackInSlot(i).func_190926_b()) continue;
            this.target = ItemStack.field_190927_a;
            this.targetXP = 0.0f;
            return;
        }
        if (!this.target.func_190926_b()) {
            this.drainXP();
            if (this.xpDrained >= this.targetXP) {
                this.inv.setStackInSlot(4, this.target);
                this.target = ItemStack.field_190927_a;
                this.targetXP = 0.0f;
                this.xpDrained = 0.0f;
                for (i = 0; i < 4; ++i) {
                    this.inv.setStackInSlot(i, ItemStack.field_190927_a);
                }
                this.markAndNotify();
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            this.findTarget(this.calcProvidedEnchValue());
        }
    }

    public int calcProvidedEnchValue() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value += EnchantmentHelper.func_82781_a((ItemStack)this.inv.getStackInSlot(i)).entrySet().stream().map(this::getValueForEnch).collect(IntCollector.INSTANCE).intValue();
        }
        return value;
    }

    public int getValueForEnch(Map.Entry<Enchantment, Integer> ench) {
        if (ench.getKey() == null) {
            return 0;
        }
        EnchantmentInfo info = EnchModule.getEnchInfo(ench.getKey());
        double avg = (double)(info.getMaxPower(ench.getValue()) + info.getMinPower(ench.getValue())) / 2.5;
        return (int)Math.floor(avg / 4.0);
    }

    public void drainXP() {
        List nearby = this.field_145850_b.func_175644_a(EntityPlayer.class, p -> p.func_174818_b(this.field_174879_c) <= 25.0);
        boolean removed = false;
        for (EntityPlayer p2 : nearby) {
            int maxDrain = (int)Math.ceil(this.targetXP / 200.0f);
            int removable = Math.min(1 + maxDrain, p2.field_71067_cb);
            EnchantmentUtils.addPlayerXP(p2, -removable);
            this.xpDrained += (float)removable;
            if (removable <= 0) continue;
            this.trySpawnParticles(p2, removable);
            removed = true;
        }
        if (this.soundTick++ % 50 == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ApotheosisObjects.ALTAR_SOUND, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
        if (!removed && this.soundTick % 10 == 0) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0);
            for (int i = 0; i < 4; ++i) {
                ParticleMessage msg = new ParticleMessage(EnumParticleTypes.SPELL, (double)this.field_174879_c.func_177958_n() + this.offsets[i][0], (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + this.offsets[i][1], 0.0, 0.1, 0.0, 1);
                Apotheosis.NETWORK.sendToAllTracking((IMessage)msg, point);
            }
        }
    }

    public void findTarget(int value) {
        if (value >= this.unusableValue) {
            return;
        }
        ItemStack book = new ItemStack(Items.field_151122_aG);
        this.target = new ItemStack(Items.field_151134_bR);
        this.targetXP = EnchantmentUtils.getExperienceForLevel(value / 2);
        List datas = EnchantmentHelper.func_77513_b((Random)this.field_145850_b.field_73012_v, (ItemStack)book, (int)value, (boolean)true);
        if (!datas.isEmpty()) {
            for (EnchantmentData d : datas) {
                ItemEnchantedBook.func_92115_a((ItemStack)this.target, (EnchantmentData)d);
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ApotheosisObjects.ALTAR_SOUND, SoundCategory.BLOCKS, 0.5f, 1.0f);
            this.soundTick = 0;
        } else {
            this.target = ItemStack.field_190927_a;
            this.targetXP = 0.0f;
            this.unusableValue = value;
        }
    }

    public void trySpawnParticles(EntityPlayer player, int xpDrain) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0);
        Vec3d to = new Vec3d(player.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5), player.field_70163_u - (double)this.field_174879_c.func_177956_o(), player.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5));
        ParticleMessage msg = new ParticleMessage(EnumParticleTypes.ENCHANTMENT_TABLE, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)(this.field_174879_c.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), to.field_72450_a, to.field_72448_b, to.field_72449_c, Math.min(5, xpDrain));
        Apotheosis.NETWORK.sendToAllTracking((IMessage)msg, point);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        tag.func_74776_a("xp", this.xpDrained);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
        this.xpDrained = tag.func_74760_g("xp");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public void markAndNotify() {
        this.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }
}

