/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import shadows.Apotheosis;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.gen.WorldFeature;
import shadows.deadly.gen.WorldGenerator;
import shadows.deadly.loot.LootManager;
import shadows.deadly.loot.LootRarity;
import shadows.ench.asm.EnchHooks;
import shadows.placebo.util.AttributeHelper;
import shadows.util.ArmorSet;
import shadows.util.NameHelper;

public class BossItem
extends WorldFeature.WorldFeatureItem {
    public static final List<Potion> POTIONS = new ArrayList<Potion>();
    public static final ArmorSet GOLD_GEAR = new ArmorSet(new ResourceLocation("apotheosis", "gold"), 0, Items.field_151010_B, Items.field_185159_cQ, Items.field_151151_aj, Items.field_151149_ai, Items.field_151171_ah, Items.field_151169_ag).addExtraMains(Items.field_151006_E, Items.field_151011_C, Items.field_151005_D);
    public static final ArmorSet IRON_GEAR = new ArmorSet(new ResourceLocation("apotheosis", "iron"), 1, Items.field_151040_l, Items.field_185159_cQ, Items.field_151167_ab, Items.field_151165_aa, Items.field_151030_Z, Items.field_151028_Y).addExtraMains(Items.field_151036_c, Items.field_151037_a, Items.field_151035_b);
    public static final ArmorSet DIAMOND_GEAR = new ArmorSet(new ResourceLocation("apotheosis", "diamond"), 2, Items.field_151048_u, Items.field_185159_cQ, Items.field_151175_af, Items.field_151173_ae, Items.field_151163_ad, Items.field_151161_ac).addExtraMains(Items.field_151056_x, Items.field_151047_v, Items.field_151046_w);
    public static final Predicate<EntityAITasks.EntityAITaskEntry> IS_VILLAGER_ATTACK;
    protected final EntityEntry entityEntry;
    protected AxisAlignedBB entityAABB;

    public BossItem(int weight, ResourceLocation entity) {
        super(weight);
        this.entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entity);
        Preconditions.checkNotNull((Object)this.entityEntry, (Object)("Invalid BossItem (not an entity) created with reloc: " + entity));
        if (!EntityLiving.class.isAssignableFrom(this.entityEntry.getEntityClass())) {
            throw new RuntimeException("Invalid BossItem (not an EntityLiving) created with class: " + this.entityEntry.getEntityClass());
        }
    }

    public AxisAlignedBB getAABB(World world) {
        if (this.entityAABB == null) {
            this.entityAABB = this.entityEntry.newInstance(world).func_70046_E();
        }
        if (this.entityAABB == null) {
            this.entityAABB = Block.field_185505_j;
        }
        return this.entityAABB;
    }

    @Override
    public void place(World world, BlockPos pos) {
        this.place(world, pos, world.field_73012_v);
    }

    public void place(World world, BlockPos pos, Random rand) {
        EntityLiving entity = (EntityLiving)this.entityEntry.newInstance(world);
        BossItem.initBoss(rand, entity);
        entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)entity);
        entity.field_70714_bg.field_75782_a.removeIf(IS_VILLAGER_ATTACK);
        entity.func_110163_bv();
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, -2, 2))) {
            world.func_180501_a(p, Blocks.field_180395_cM.func_176223_P(), 2);
        }
        WorldGenerator.debugLog(pos, "Boss " + entity.func_70005_c_());
    }

    public static void initBoss(Random random, EntityLiving entity) {
        int level;
        int res;
        int duration = entity instanceof EntityCreeper ? 6000 : Integer.MAX_VALUE;
        int regen = DeadlyConfig.bossRegenLevel.func_186511_a(random) - 1;
        if (regen >= 0) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, duration, regen));
        }
        if ((res = DeadlyConfig.bossResistLevel.func_186511_a(random) - 1) >= 0) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, duration, res));
        }
        if (random.nextFloat() < DeadlyConfig.bossFireRes) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, duration));
        }
        if (random.nextFloat() < DeadlyConfig.bossWaterBreathing) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, duration));
        }
        AttributeHelper.multiplyFinal((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111264_e, (String)"boss_damage_bonus", (double)(DeadlyConfig.bossHealthMultiplier.func_186507_b(random) - 1.0f));
        AttributeHelper.multiplyFinal((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111267_a, (String)"boss_health_mult", (double)(DeadlyConfig.bossHealthMultiplier.func_186507_b(random) - 1.0f));
        AttributeHelper.addToBase((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111266_c, (String)"boss_knockback_resist", (double)DeadlyConfig.bossKnockbackResist.func_186507_b(random));
        AttributeHelper.multiplyFinal((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111263_d, (String)"boss_speed_mult", (double)(DeadlyConfig.bossSpeedMultiplier.func_186507_b(random) - 1.0f));
        entity.func_70606_j(entity.func_110138_aP());
        String name = NameHelper.setEntityName(random, entity);
        entity.func_110163_bv();
        for (level = 0; random.nextDouble() <= (double)DeadlyConfig.bossLevelUpChance && level <= ArmorSet.getMaxLevel(); ++level) {
        }
        ArmorSet.getSetFor(level, random).apply((EntityLivingBase)entity);
        if (entity instanceof EntitySkeleton) {
            entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
        }
        int guaranteed = random.nextInt(6);
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.values()[guaranteed]);
        while (guaranteed == 1 || stack.func_190926_b()) {
            guaranteed = random.nextInt(6);
            stack = entity.func_184582_a(EntityEquipmentSlot.values()[guaranteed]);
        }
        for (EntityEquipmentSlot s : EntityEquipmentSlot.values()) {
            if (s.ordinal() == guaranteed) {
                entity.func_184642_a(s, 2.0f);
            } else {
                entity.func_184642_a(s, ThreadLocalRandom.current().nextFloat() / 2.0f);
            }
            if (s.ordinal() == guaranteed) {
                entity.func_184201_a(s, BossItem.modifyBossItem(stack, random, name));
                continue;
            }
            if (!(random.nextDouble() < (double)DeadlyConfig.bossEnchantChance)) continue;
            List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(30 + random.nextInt(Apotheosis.enableEnch ? 20 : 10)), (boolean)true);
            EnchantmentHelper.func_82782_a((Map)ench.stream().collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, (v1, v2) -> v1 > v2 ? v1 : v2, HashMap::new)), (ItemStack)stack);
        }
        if (POTIONS.isEmpty()) {
            BossItem.initPotions();
        }
        if (random.nextDouble() < (double)DeadlyConfig.bossPotionChance) {
            entity.func_70690_d(new PotionEffect(POTIONS.get(random.nextInt(POTIONS.size())), duration, random.nextInt(3) + 1));
        }
    }

    public static void initPotions() {
        for (Potion p2 : ForgeRegistries.POTIONS) {
            if (!p2.field_188415_h || p2.func_76403_b()) continue;
            POTIONS.add(p2);
        }
        POTIONS.removeIf(p -> DeadlyConfig.BLACKLISTED_POTIONS.contains(p.getRegistryName()));
    }

    public static ItemStack modifyBossItem(ItemStack stack, Random random, String bossName) {
        List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(Apotheosis.enableEnch ? 60 : 30), (boolean)true);
        EnchantmentHelper.func_82782_a(ench.stream().collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, (a, b) -> a > b ? a : b)), (ItemStack)stack);
        String itemName = NameHelper.setItemName(random, stack, bossName);
        stack.func_151001_c(itemName);
        LootRarity rarity = LootRarity.random(random, 400);
        stack = LootManager.genLootItem(stack, random, rarity);
        stack.func_151001_c(rarity.getColor() + bossName + "'s " + stack.func_82833_r());
        HashMap enchMap = new HashMap();
        for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            if (e.getKey() == null) continue;
            enchMap.put(e.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)e.getKey()), (Integer)e.getValue() + random.nextInt(2)));
        }
        EnchantmentHelper.func_82782_a(enchMap, (ItemStack)stack);
        return stack;
    }

    static {
        ArmorSet.register(GOLD_GEAR);
        ArmorSet.register(IRON_GEAR);
        ArmorSet.register(DIAMOND_GEAR);
        IS_VILLAGER_ATTACK = a -> a.field_75733_a instanceof EntityAINearestAttackableTarget && ((EntityAINearestAttackableTarget)a.field_75733_a).field_75307_b == EntityVillager.class;
    }

    public static enum EquipmentType {
        SWORD(s -> EntityEquipmentSlot.MAINHAND),
        BOW(s -> EntityEquipmentSlot.MAINHAND),
        TOOL(s -> EntityEquipmentSlot.MAINHAND),
        ARMOR(s -> ((ItemArmor)s.func_77973_b()).field_77881_a),
        SHIELD(s -> EntityEquipmentSlot.OFFHAND);

        final Function<ItemStack, EntityEquipmentSlot> type;

        private EquipmentType(Function<ItemStack, EntityEquipmentSlot> type) {
            this.type = type;
        }

        public EntityEquipmentSlot getSlot(ItemStack stack) {
            return this.type.apply(stack);
        }

        public static EquipmentType getTypeFor(ItemStack stack) {
            Item i = stack.func_77973_b();
            if (i instanceof ItemSword) {
                return SWORD;
            }
            if (i instanceof ItemBow) {
                return BOW;
            }
            if (i instanceof ItemArmor) {
                return ARMOR;
            }
            if (i instanceof ItemShield) {
                return SHIELD;
            }
            return TOOL;
        }
    }
}

