/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesextrautils2.blocks;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeDestroyer;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeExtState;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeNetVolume;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeSpecies;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import maxhyper.dynamictreesextrautils2.ModContent;
import maxhyper.dynamictreesextrautils2.nodes.BranchDestructionDataExtra;
import maxhyper.dynamictreesextrautils2.nodes.NodeNetSpecialBranchVolume;
import maxhyper.dynamictreesextrautils2.trees.EU2TreeFeJuniper;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockDynamicBranchFeJuniper
extends BlockBranchBasic {
    public BlockDynamicBranchFeJuniper() {
        super(new ResourceLocation("dynamictreesextrautils2", "ferrousjuniperbranch").toString());
        this.func_149675_a(true);
    }

    public BlockDynamicBranchFeJuniper(boolean burnt) {
        super(new ResourceLocation("dynamictreesextrautils2", "ferrousjuniperbranchburnt").toString());
        this.func_149675_a(false);
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius(blockState);
        return 0.5f * (float)(radius * radius) / 64.0f * 8.0f;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing direction) {
        return world.func_180495_p(pos).func_177230_c() != BlockDynamicBranchFeJuniper.func_149684_b((String)new ResourceLocation("dynamictreesextrautils2", "ferrousjuniperbranchburnt").toString());
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c() != BlockDynamicBranchFeJuniper.func_149684_b((String)new ResourceLocation("dynamictreesextrautils2", "ferrousjuniperbranchburnt").toString());
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 15;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.performUpdate(worldIn, pos, state, rand);
    }

    private void performUpdate(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177230_c() == ModContent.fejuniperBranchRaw) {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos offset;
                IBlockState fireState = worldIn.func_180495_p(pos.func_177972_a(facing));
                if (fireState.func_177230_c() != Blocks.field_150480_ab && fireState.func_185904_a() != Material.field_151581_o && fireState.func_177230_c() != ModContent.fejuniperBranchBurnt) continue;
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    offset = pos.func_177972_a(enumFacing);
                    IBlockState blockState = worldIn.func_180495_p(offset);
                    if (blockState.func_177230_c() == Blocks.field_150480_ab || blockState.func_177230_c().isAir(blockState, (IBlockAccess)worldIn, offset)) {
                        worldIn.func_180501_a(offset, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(0)), 3);
                        continue;
                    }
                    if (blockState.func_177230_c() != ModContent.fejuniperBranchRaw && blockState.func_177230_c() != ModContent.fejuniperBranchBurnt) continue;
                    for (EnumFacing enumFacing2 : EnumFacing.values()) {
                        BlockPos offset2;
                        IBlockState blockState2;
                        if (rand.nextBoolean() || (blockState2 = worldIn.func_180495_p(offset2 = pos.func_177972_a(enumFacing2))).func_177230_c() != Blocks.field_150480_ab && !blockState2.func_177230_c().isAir(blockState2, (IBlockAccess)worldIn, offset2) && !blockState2.func_177230_c().func_176200_f((IBlockAccess)worldIn, offset2)) continue;
                        worldIn.func_180501_a(offset2, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(0)), 3);
                    }
                }
                worldIn.func_175656_a(pos, ModContent.fejuniperBranchBurnt.func_176223_P().func_177226_a((IProperty)RADIUS, worldIn.func_180495_p(pos).func_177229_b((IProperty)RADIUS)));
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    IBlockState offsetBlockState;
                    if (rand.nextBoolean() || (offsetBlockState = worldIn.func_180495_p(offset = pos.func_177972_a(enumFacing))).func_177230_c() != ModContent.fejuniperBranchRaw) continue;
                    worldIn.func_175656_a(offset, ModContent.fejuniperBranchBurnt.func_176223_P().func_177226_a((IProperty)RADIUS, worldIn.func_180495_p(offset).func_177229_b((IProperty)RADIUS)));
                }
                return;
            }
        }
    }

    public void futureBreak(IBlockState state, World world, BlockPos cutPos, EntityLivingBase entity) {
        double reachDistance = entity instanceof EntityPlayerMP ? entity.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0;
        RayTraceResult rtResult = this.playerRayTrace(entity, reachDistance, 1.0f);
        EnumFacing toolDir = rtResult != null ? (entity.func_70093_af() ? rtResult.field_178784_b.func_176734_d() : rtResult.field_178784_b) : EnumFacing.DOWN;
        BranchDestructionDataExtra destroyData = this.destroyBranchFromNode(world, cutPos, toolDir, false);
        ItemStack heldItem = entity.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem) != 0;
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        float woodVolume = destroyData.woodVolume;
        float burntWoodVolume = destroyData.secondaryWoodVolume;
        List<ItemStack> woodItems = silkTouch ? this.getLogDrops(world, cutPos, destroyData.species, woodVolume * fortuneFactor, burntWoodVolume, true) : this.getLogDrops(world, cutPos, destroyData.species, woodVolume * fortuneFactor, burntWoodVolume, false);
        if (entity.func_184600_cs() == null) {
            entity.func_184598_c(EnumHand.MAIN_HAND);
        }
        float chance = 1.0f;
        if (entity instanceof EntityPlayer) {
            chance = ForgeEventFactory.fireBlockHarvesting(woodItems, (World)world, (BlockPos)cutPos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)entity));
        }
        float finalChance = chance;
        List woodDropList = woodItems.stream().filter(i -> world.field_73012_v.nextFloat() <= finalChance).collect(Collectors.toList());
        EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, woodDropList, (EntityFallingTree.DestroyType)EntityFallingTree.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume);
    }

    protected void sloppyBreak(World world, BlockPos cutPos, EntityFallingTree.DestroyType destroyType) {
        BranchDestructionDataExtra destroyData = this.destroyBranchFromNode(world, cutPos, EnumFacing.DOWN, false);
        float burntWoodVolume = 0.0f;
        List<ItemStack> woodDropList = this.getLogDrops(world, cutPos, destroyData.species, destroyData.woodVolume, destroyData.secondaryWoodVolume, false);
        EntityFallingTree.dropTree((World)world, (BranchDestructionData)destroyData, woodDropList, (EntityFallingTree.DestroyType)destroyType);
    }

    public List<ItemStack> getLogDrops(World world, BlockPos pos, Species species, float volume, float burntVolume, boolean silkTouch) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        float rawVolume = volume - burntVolume;
        if (silkTouch) {
            ret.add(new ItemStack(EU2TreeFeJuniper.logBlock, (int)rawVolume, 0));
        } else {
            ret.add(new ItemStack(EU2TreeFeJuniper.planksBlock, (int)rawVolume, 1));
        }
        ret.add(new ItemStack(EU2TreeFeJuniper.logBlock, (int)burntVolume, 1));
        ret.add(new ItemStack(Items.field_151055_y, (int)((volume - (float)((int)rawVolume + (int)burntVolume)) * 8.0f)));
        return species.getLogsDrops(world, pos, ret, volume *= ModConfigs.treeHarvestMultiplier);
    }

    public BranchDestructionDataExtra destroyBranchFromNode(World world, BlockPos cutPos, EnumFacing toolDir, boolean wholeTree) {
        IBlockState blockState = world.func_180495_p(cutPos);
        NodeSpecies nodeSpecies = new NodeSpecies();
        MapSignal signal = this.analyse(blockState, world, cutPos, null, new MapSignal(new INodeInspector[]{nodeSpecies}));
        Species species = nodeSpecies.getSpecies();
        NodeExtState extStateMapper = new NodeExtState(cutPos);
        this.analyse(blockState, world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new INodeInspector[]{extStateMapper}));
        NodeNetVolume volumeSum = new NodeNetVolume();
        NodeNetSpecialBranchVolume volumeBurntSum = new NodeNetSpecialBranchVolume();
        NodeDestroyer destroyer = new NodeDestroyer(species);
        destroyMode = BlockBranch.EnumDestroyMode.HARVEST;
        System.out.println("1: RAW: " + volumeSum.getVolume() + " / BURNT: " + volumeBurntSum.getVolume());
        this.analyse(blockState, world, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(new INodeInspector[]{volumeSum, volumeBurntSum, destroyer}));
        System.out.println("2: RAW: " + volumeSum.getVolume() + " / BURNT: " + volumeBurntSum.getVolume());
        destroyMode = BlockBranch.EnumDestroyMode.SLOPPY;
        List<BlockPos> endPoints = destroyer.getEnds();
        HashMap<BlockPos, IBlockState> destroyedLeaves = new HashMap<BlockPos, IBlockState>();
        ArrayList<BlockBranch.BlockItemStack> leavesDropsList = new ArrayList<BlockBranch.BlockItemStack>();
        this.destroyLeaves(world, cutPos, species, endPoints, destroyedLeaves, leavesDropsList);
        endPoints = endPoints.stream().map(p -> p.func_177973_b((Vec3i)cutPos)).collect(Collectors.toList());
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (extStateMapper.getExtStateMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.func_177984_a();
        }
        EnumFacing cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = EnumFacing.DOWN;
        }
        return new BranchDestructionDataExtra(species, extStateMapper.getExtStateMap(), destroyedLeaves, leavesDropsList, endPoints, volumeSum.getVolume(), volumeBurntSum.getVolume(), cutPos, cutDir, toolDir, trunkHeight);
    }
}

