/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.tile;

import com.buuz135.industrial.proxy.block.tile.TileBase;
import java.text.DecimalFormat;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityLabel
extends TileBase {
    private static DecimalFormat formatterWithUnits = new DecimalFormat("####0.#");
    private FormatType formatType = FormatType.STACKS;

    public static String getFormatedBigNumber(int number) {
        if (number >= 1000000000) {
            float numb = (float)number / 1.0E9f;
            return formatterWithUnits.format(numb) + "B";
        }
        if (number >= 1000000) {
            float numb = (float)number / 1000000.0f;
            if (number > 100000000) {
                numb = Math.round(numb);
            }
            return formatterWithUnits.format(numb) + "M";
        }
        if (number >= 1000) {
            float numb = (float)number / 1000.0f;
            if (number > 100000) {
                numb = Math.round(numb);
            }
            return formatterWithUnits.format(numb) + "K";
        }
        return String.valueOf(number);
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public void setFormatType(FormatType formatType) {
        this.formatType = formatType;
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.formatType = FormatType.valueOf(compound.func_74779_i("Format"));
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74778_a("Format", this.formatType.name());
        return compound;
    }

    public static enum FormatType {
        STACKS(integer -> integer == 0 ? "0" : (integer >= 64 ? TileEntityLabel.getFormatedBigNumber(integer / 64) + " x64" : "") + (integer >= 64 && integer % 64 != 0 ? " + " : "") + (integer % 64 != 0 ? Integer.valueOf(integer % 64) : "")),
        MILL(TileEntityLabel::getFormatedBigNumber),
        FLUID(integer -> TileEntityLabel.getFormatedBigNumber(integer / 1000) + " b");

        private final Function<Integer, String> format;

        private FormatType(Function<Integer, String> format) {
            this.format = format;
        }

        public Function<Integer, String> getFormat() {
            return this.format;
        }
    }
}

