/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TileMovingBase;
import com.rwtema.funkylocomotion.description.Describer;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import com.rwtema.funkylocomotion.rendering.ChunkRerenderer;
import com.rwtema.funkylocomotion.rendering.PassHandler;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMovingClient
extends TileMovingBase {
    public static final HashMap<BlockPos, WeakReference<TileEntity>> cachedTiles = new HashMap();
    public static final HashSet<Class<?>> renderBlackList = new HashSet();
    public static final HashSet<Class<?>> renderErrorList = new HashSet();
    public final boolean[] skipPass = new boolean[2];
    public Block block = Blocks.field_150350_a;
    public int meta = 0;
    public TileEntity tile = null;
    public boolean render;
    public boolean error = false;
    public boolean rawTile = false;
    public boolean init = false;

    public TileMovingClient() {
        super(Side.CLIENT);
    }

    @Override
    public void func_73660_a() {
        if (this.time < this.maxTime) {
            super.func_73660_a();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.rawTile && this.tile != null) {
            this.tile.func_145843_s();
        }
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.block = Block.func_149729_e((int)tag.func_74762_e("Block"));
        this.meta = tag.func_74762_e("Meta");
        this.time = tag.func_74762_e("Time");
        this.maxTime = tag.func_74762_e("MaxTime");
        this.lightLevel = tag.func_74762_e("Light");
        this.lightOpacity = tag.func_74765_d("Opacity");
        boolean bl = this.isAir = this.block == Blocks.field_150350_a;
        if (tag.func_150297_b("Collisions", 9)) {
            this.collisions = TileMovingClient.AxisTags(tag.func_150295_c("Collisions", 10));
        }
        this.dir = tag.func_74771_c("Dir");
        Object tile = null;
        if (this.dir >= 0 && this.dir < 8 && this.dir != 6) {
            EnumFacing d = this.getDir();
            WeakReference<TileEntity> weakReference = cachedTiles.remove(d != null ? this.field_174879_c.func_177967_a(d, -1) : this.field_174879_c);
        }
        if (tile != null && FakeWorldClient.isValid(this.func_145831_w()) && tile.func_145831_w() == this.func_145831_w()) {
            this.rawTile = true;
            tile.func_174878_a(this.field_174879_c.func_185334_h());
            tile.func_145834_a((World)FakeWorldClient.getFakeWorldWrapper(this.func_145831_w()));
            tile.func_145836_u();
            this.tile = tile;
            this.render = true;
        } else {
            boolean bl2 = this.render = !tag.func_74767_n("DNR");
            if (this.render) {
                this.tile = Describer.recreateTileEntity(tag, this.getState(), this.field_174879_c, (World)FakeWorldClient.getFakeWorldWrapper(this.func_145831_w()));
            }
        }
        if (this.checkClass(this.block) || this.checkClass(this.tile)) {
            this.tile = null;
        }
        if (this.render && !this.init) {
            ChunkRerenderer.markBlock(this.field_174879_c);
        }
        this.init = true;
        this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public boolean checkClass(Object o) {
        if (o == null) {
            return false;
        }
        if (renderBlackList.contains(o.getClass())) {
            this.render = false;
            return true;
        }
        if (renderErrorList.contains(o.getClass())) {
            this.render = false;
            this.error = true;
            return true;
        }
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB other = this.tile != null ? this.tile.getRenderBoundingBox() : this.getState().func_185890_d((IBlockAccess)FakeWorldClient.getFakeWorldWrapper(this.func_145831_w()), this.field_174879_c);
        other = other == null ? Block.field_185505_j : other.func_111270_a(Block.field_185505_j);
        other = other.func_72321_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        double h = this.offset(true);
        EnumFacing d = this.getDir();
        return h != 0.0 && d != null ? other.func_72317_d(h * (double)d.func_82601_c(), h * (double)d.func_96559_d(), h * (double)d.func_82599_e()) : other;
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.maxTime == 0) {
            return false;
        }
        if (!this.render || this.error) {
            return pass == 0;
        }
        IBlockState state = this.getState();
        if (this.block == Blocks.field_150350_a || this.tile == null && state.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
            return false;
        }
        if (this.tile != null && this.tile.shouldRenderInPass(pass)) {
            return true;
        }
        for (BlockRenderLayer layer : PassHandler.getHandler((int)pass).layers) {
            if (!this.block.canRenderInLayer(state, layer)) continue;
            return true;
        }
        return false;
    }

    public IBlockState getState() {
        return this.block.func_176203_a(this.meta);
    }
}

