/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.trials.affix;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import xt9.deepmoblearning.common.entity.EntityGlitch;
import xt9.deepmoblearning.common.trials.affix.ITrialAffix;

public class LootHoarderAffix
implements ITrialAffix {
    private BlockPos pos;
    private World world;
    private int ticks = 0;

    public LootHoarderAffix() {
        this.pos = new BlockPos(0, 0, 0);
        this.world = null;
    }

    public LootHoarderAffix(BlockPos pos, World world) {
        this.pos = pos;
        this.world = world;
    }

    @Override
    public void apply(EntityLiving entity) {
    }

    @Override
    public void applyToGlitch(EntityGlitch entity) {
    }

    @Override
    public void run() {
        ++this.ticks;
        if (this.ticks % 300 == 0) {
            if (ThreadLocalRandom.current().nextInt(1, 100) > 75) {
                EntityZombie hoarder = new EntityZombie(this.world);
                hoarder.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag));
                hoarder.func_96094_a("Loot Hoarder");
                hoarder.func_82227_f(true);
                int randomX = this.pos.func_177958_n() + ThreadLocalRandom.current().nextInt(-5, 5);
                int randomY = this.pos.func_177956_o() + ThreadLocalRandom.current().nextInt(0, 1);
                int randomZ = this.pos.func_177952_p() + ThreadLocalRandom.current().nextInt(-5, 5);
                hoarder.func_70012_b((double)randomX, (double)randomY, (double)randomZ, 0.0f, 0.0f);
                hoarder.getEntityData().func_74778_a("deepmoblearning:mob_type", "loot_hoarders");
                hoarder.func_110163_bv();
                LootTable table = this.world.func_184146_ak().func_186521_a(new ResourceLocation("deepmoblearning", "loot_hoarder"));
                LootContext ctx = new LootContext.Builder((WorldServer)this.world).func_186471_a();
                List looted = table.func_186462_a(this.world.field_73012_v, ctx);
                if (looted.size() > 0) {
                    hoarder.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)looted.get(0));
                }
                this.world.func_72838_d((Entity)hoarder);
            }
            this.ticks = 0;
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getAffixName() {
        return "Loot Hoarders";
    }

    @Override
    public String getAffixNameWithFormatting() {
        return "\u00a76" + this.getAffixName() + "\u00a7r";
    }
}

