/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.block;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.ModUtil;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.ConversionHSV2RGB;
import mod.flatcoloredblocks.block.EnumFlatColorAttributes;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemBlockFlatColored
extends ItemBlock {
    public BlockFlatColored getColoredBlock() {
        return (BlockFlatColored)this.field_150939_a;
    }

    public IBlockState getStateFromStack(@Nonnull ItemStack stack) {
        return ModUtil.getStateFromMeta(this.func_179223_d(), stack.func_77952_i());
    }

    private String getColorPrefix(Set<EnumFlatColorAttributes> which) {
        if (which.contains((Object)EnumFlatColorAttributes.dark)) {
            return "flatcoloredblocks.dark";
        }
        if (which.contains((Object)EnumFlatColorAttributes.light)) {
            return "flatcoloredblocks.light";
        }
        return "flatcoloredblocks.";
    }

    private String getColorHueName(Set<EnumFlatColorAttributes> characteristics) {
        for (EnumFlatColorAttributes c : characteristics) {
            if (c.isModifier) continue;
            return c.name();
        }
        return EnumFlatColorAttributes.black.name();
    }

    public ItemBlockFlatColored(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77653_i(@Nonnull ItemStack stack) {
        IBlockState state = this.getStateFromStack(stack);
        int shadeNum = this.getColoredBlock().getShadeNumber(state);
        Set<EnumFlatColorAttributes> colorChars = this.getColoredBlock().getFlatColorAttributes(state);
        String type = this.getTypeLocalization();
        String prefix = this.getColorPrefix(colorChars);
        String hue = this.getColorHueName(colorChars);
        return type + ModUtil.translateToLocal(prefix + hue + ".name") + " " + ModUtil.translateToLocal("flatcoloredblocks.Shade.name") + shadeNum;
    }

    private String getTypeLocalization() {
        switch (this.getColoredBlock().getType()) {
            case GLOWING: {
                return ModUtil.translateToLocal("flatcoloredblocks.Glowing.name") + " ";
            }
            case TRANSPARENT: {
                return ModUtil.translateToLocal("flatcoloredblocks.Transparent.name") + " ";
            }
        }
        return "";
    }

    public void func_77624_a(@Nonnull ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        StringBuilder sb;
        IBlockState state = this.getStateFromStack(stack);
        BlockFlatColored blk = this.getColoredBlock();
        int hsv = blk.hsvFromState(state);
        int rgb = ConversionHSV2RGB.toRGB(hsv);
        if (FlatColoredBlocks.instance.config.showRGB) {
            this.addColor(ColorFormat.RGB, rgb, tooltip);
        }
        if (FlatColoredBlocks.instance.config.showHEX) {
            this.addColor(ColorFormat.HEX, rgb, tooltip);
        }
        if (FlatColoredBlocks.instance.config.showHSV) {
            this.addColor(ColorFormat.HSV, hsv, tooltip);
        }
        if (FlatColoredBlocks.instance.config.showLight && blk.field_149784_t > 0) {
            sb = new StringBuilder();
            sb.append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.lightvalue")).append(' ');
            sb.append(blk.field_149784_t).append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.lightValueUnit"));
            tooltip.add(sb.toString());
        }
        if (FlatColoredBlocks.instance.config.showOpacity && blk.opacity < 100) {
            sb = new StringBuilder();
            sb.append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.opacity")).append(' ');
            sb.append(blk.opacity).append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.percent"));
            tooltip.add(sb.toString());
        }
        super.func_77624_a(stack, worldIn, tooltip, advanced);
    }

    private void addColor(ColorFormat Format, int value, List<String> tooltip) {
        int r_h = value >> 16 & 0xFF;
        int g_s = value >> 8 & 0xFF;
        int b_v = value & 0xFF;
        StringBuilder sb = new StringBuilder();
        if (Format == ColorFormat.HEX) {
            sb.append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.hex")).append(' ');
            sb.append("#").append(ItemBlockFlatColored.hexPad(Integer.toString(r_h, 16))).append(ItemBlockFlatColored.hexPad(Integer.toString(g_s, 16))).append(ItemBlockFlatColored.hexPad(Integer.toString(b_v, 16)));
        } else if (Format == ColorFormat.RGB) {
            sb.append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.rgb")).append(' ');
            sb.append(TextFormatting.RED).append(r_h).append(' ');
            sb.append(TextFormatting.GREEN).append(g_s).append(' ');
            sb.append(TextFormatting.BLUE).append(b_v);
        } else {
            sb.append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.hsv")).append(' ');
            sb.append(360 * r_h / 255).append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.deg") + ' ');
            sb.append(100 * g_s / 255).append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.percent") + ' ');
            sb.append(100 * b_v / 255).append(ModUtil.translateToLocal("flatcoloredblocks.tooltips.percent"));
        }
        tooltip.add(sb.toString());
    }

    public static String hexPad(String string) {
        if (string.length() == 0) {
            return "00";
        }
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public int getColorFromItemStack(@Nonnull ItemStack stack, int renderPass) {
        IBlockState state = this.getStateFromStack(stack);
        return this.getColoredBlock().colorFromState(state);
    }

    public static enum ColorFormat {
        HEX,
        RGB,
        HSV;

    }
}

