/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.alloy.endergy;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.alloy.IAlloy;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.StringUtils;

public enum AlloyEndergy implements IStringSerializable,
IAlloy
{
    CRUDE_STEEL("crudeSteel", 2.0f, 12826545, 140),
    CRYSTALLINE_ALLOY("crystallineAlloy", 6.0f, 8837593, 1152),
    MELODIC_ALLOY("melodicAlloy", 5.0f, 8674948, 940),
    STELLAR_ALLOY("stellarAlloy", 10.0f, 0xE7EAEA, 1202),
    CRYSTALLINE_PINK_SLIME("crystallinePinkSlime", 7.0f, 3516635, 1174),
    ENERGETIC_SILVER("energeticSilver", 7.0f, 7972293, 855),
    VIVID_ALLOY("vividAlloy", 4.0f, 4963030, 650);

    @Nonnull
    public final String baseName;
    @Nonnull
    private final String oreName;
    private final float hardness;
    private final int color;
    private final int meltingPoint;

    private AlloyEndergy(String baseName, float hardness, int color, int meltingPoint) {
        this.baseName = baseName.replaceAll("([A-Z])", "_$0").toLowerCase(Locale.ENGLISH);
        this.oreName = StringUtils.capitalize((String)baseName);
        this.hardness = hardness;
        this.color = color;
        this.meltingPoint = meltingPoint;
    }

    @Override
    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    @Nonnull
    public String getFluidName() {
        return this.baseName;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getMeltingPoint() {
        return this.meltingPoint;
    }

    @Override
    @Nonnull
    public ItemStack getStackNugget() {
        return this.getStackNugget(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackNugget(int size) {
        return new ItemStack(ModObject.itemAlloyEndergyNugget.getItemNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getStackIngot() {
        return this.getStackIngot(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackIngot(int size) {
        return new ItemStack(ModObject.itemAlloyEndergyIngot.getItemNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getStackBall() {
        return this.getStackBall(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackBall(int size) {
        return new ItemStack(ModObject.itemAlloyEndergyBall.getItemNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getStackBlock() {
        return this.getStackBlock(1);
    }

    @Override
    @Nonnull
    public ItemStack getStackBlock(int size) {
        return new ItemStack(ModObject.blockAlloyEndergy.getBlockNN(), size, this.ordinal());
    }

    @Override
    @Nonnull
    public String getOreName() {
        return this.oreName;
    }

    @Override
    @Nonnull
    public String getOreNugget() {
        return "nugget" + this.oreName;
    }

    @Override
    @Nonnull
    public String getOreIngot() {
        return "ingot" + this.oreName;
    }

    @Override
    @Nonnull
    public String getOreBall() {
        return "ball" + this.oreName;
    }

    @Override
    @Nonnull
    public String getOreBlock() {
        return "block" + this.oreName;
    }

    @Nonnull
    public String func_176610_l() {
        return this.baseName;
    }

    @Nonnull
    public static AlloyEndergy getTypeFromMeta(int meta) {
        return (AlloyEndergy)NullHelper.notnullJ((Object)AlloyEndergy.values()[meta >= 0 && meta < AlloyEndergy.values().length ? meta : 0], (String)"Enum.values()");
    }

    public static int getMetaFromType(@Nonnull AlloyEndergy value) {
        return value.ordinal();
    }
}

