/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.fertilizer;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.IFertilizer;
import crazypants.enderio.base.farming.fertilizer.Bonemeal;
import crazypants.enderio.base.farming.fertilizer.NoFertilizer;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enderio")
public class Fertilizer {
    private static IForgeRegistry<IFertilizer> REGISTRY = null;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("enderio", "fertilizer")).setType(IFertilizer.class).setIDRange(0, 0x7FFFFFFE).create();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerFertilizer(@Nonnull RegistryEvent.Register<IFertilizer> event) {
        event.getRegistry().register((IForgeRegistryEntry)new Bonemeal(new ItemStack(Items.field_151100_aR, 1, 15)));
    }

    @Nonnull
    public static IFertilizer getInstance(@Nonnull ItemStack stack) {
        for (IFertilizer fertilizer : REGISTRY.getValues()) {
            if (!fertilizer.matches(stack)) continue;
            return fertilizer;
        }
        return NoFertilizer.getNone();
    }

    public static boolean isFertilizer(@Nonnull ItemStack stack) {
        return Fertilizer.getInstance(stack) != NoFertilizer.getNone();
    }

    @Nonnull
    public static NNList<ItemStack> getStacks() {
        NNList result = new NNList();
        for (IFertilizer fertilizer : REGISTRY.getValues()) {
            result.addAll(fertilizer.getGuiItem());
        }
        return result;
    }
}

