/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class SavedData
extends WorldSavedData {
    private NBTTagCompound globalVars = new NBTTagCompound();
    private Map<ItemStack, Integer> delayedLoot = new HashMap<ItemStack, Integer>();

    public SavedData(String id) {
        super(id);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.globalVars = nbt.func_74775_l("GlobalVariables");
        NBTTagList delayedLootList = nbt.func_150295_c("DelayedLoot", 10);
        this.delayedLoot.clear();
        delayedLootList.forEach(tagBase -> {
            if (tagBase instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)tagBase;
                ItemStack stack = new ItemStack(tag.func_74775_l("ItemStack"));
                int delay = tag.func_74762_e("Delay");
                this.delayedLoot.put(stack, delay);
            }
        });
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a("GlobalVariables", (NBTBase)this.globalVars);
        NBTTagList delayedLootList = new NBTTagList();
        this.delayedLoot.forEach((stack, delay) -> {
            NBTTagCompound delayTag = new NBTTagCompound();
            delayTag.func_74768_a("Delay", delay.intValue());
            delayTag.func_74782_a("ItemStack", (NBTBase)stack.serializeNBT());
            delayedLootList.func_74742_a((NBTBase)delayTag);
        });
        nbt.func_74782_a("DelayedLoot", (NBTBase)delayedLootList);
        return nbt;
    }

    public void setGlobalVar(String name, StoredVar var) {
        this.globalVars.func_74782_a(name, var.toNBT());
        this.func_76185_a();
    }

    @Nullable
    public StoredVar getGlobalVar(String name) {
        NBTBase tag = this.globalVars.func_74781_a(name);
        return SavedData.getVarFromTag(tag);
    }

    public StoredVar getGlobalVarByType(String name, String type) {
        NBTBase tag = this.globalVars.func_74781_a(name);
        return SavedData.getVarByTypeOrDefault(tag, name, type);
    }

    public String[] getGlobalVarNames() {
        return this.globalVars.func_150296_c().toArray(new String[0]);
    }

    public void setLootDelay(ItemStack stack, int delay) {
        this.delayedLoot.put(stack, delay);
        this.func_76185_a();
    }

    public List<ItemStack> decrementLootDelays() {
        ArrayList<ItemStack> expiredDelays = new ArrayList<ItemStack>();
        Iterator<Map.Entry<ItemStack, Integer>> iterator = this.delayedLoot.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ItemStack, Integer> entry = iterator.next();
            entry.setValue(entry.getValue() - 1);
            if (entry.getValue() <= 0) {
                expiredDelays.add(entry.getKey());
                iterator.remove();
            }
            this.func_76185_a();
        }
        return expiredDelays;
    }

    public static SavedData getSavedData(World world) {
        SavedData data = (SavedData)world.getPerWorldStorage().func_75742_a(SavedData.class, "lootoverhaul");
        if (data == null) {
            data = new SavedData("lootoverhaul");
            world.getPerWorldStorage().func_75745_a("lootoverhaul", (WorldSavedData)data);
        }
        return data;
    }

    public static void setEntityVar(Entity entity, String name, StoredVar var) {
        NBTTagCompound entityVars = SavedData.getEntityVarsTag(entity);
        entityVars.func_74782_a(name, var.toNBT());
        if (entity instanceof EntityPlayer) {
            NBTTagCompound persisted = entity.getEntityData().func_74775_l("PlayerPersisted");
            persisted.func_74782_a("EntityVariables", (NBTBase)entityVars);
            entity.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persisted);
        } else {
            entity.getEntityData().func_74782_a("EntityVariables", (NBTBase)entityVars);
        }
    }

    @Nullable
    public static StoredVar getEntityVar(Entity entity, String name) {
        NBTTagCompound entityVars = SavedData.getEntityVarsTag(entity);
        NBTBase tag = entityVars.func_74781_a(name);
        return SavedData.getVarFromTag(tag);
    }

    public static StoredVar getEntityVar(Entity entity, String name, String type) {
        NBTTagCompound entityVars = SavedData.getEntityVarsTag(entity);
        NBTBase tag = entityVars.func_74781_a(name);
        return SavedData.getVarByTypeOrDefault(tag, name, type);
    }

    public static String[] getEntityVarNames(Entity entity) {
        NBTTagCompound entityVars = SavedData.getEntityVarsTag(entity);
        return entityVars.func_150296_c().toArray(new String[0]);
    }

    public static NBTTagCompound getEntityVarsTag(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return entity.getEntityData().func_74775_l("PlayerPersisted").func_74775_l("EntityVariables");
        }
        return entity.getEntityData().func_74775_l("EntityVariables");
    }

    @Nullable
    public static StoredVar getVarFromTag(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            return new StoredVarString((NBTTagString)tag);
        }
        if (tag instanceof NBTTagByte) {
            return new StoredVarBoolean((NBTTagByte)tag);
        }
        if (tag instanceof NBTTagInt) {
            return new StoredVarInt((NBTTagInt)tag);
        }
        if (tag instanceof NBTTagFloat) {
            return new StoredVarFloat((NBTTagFloat)tag);
        }
        return null;
    }

    public static StoredVar getVarByTypeOrDefault(NBTBase tag, String name, String type) {
        if (type.equalsIgnoreCase("string")) {
            if (tag instanceof NBTTagString) {
                return SavedData.getVarFromTag(tag);
            }
            return new StoredVarString("");
        }
        if (type.equalsIgnoreCase("integer")) {
            if (tag instanceof NBTTagInt) {
                return SavedData.getVarFromTag(tag);
            }
            return new StoredVarInt(0);
        }
        if (type.equalsIgnoreCase("float")) {
            if (tag instanceof NBTTagFloat) {
                return SavedData.getVarFromTag(tag);
            }
            return new StoredVarFloat(0.0f);
        }
        if (tag instanceof NBTTagByte) {
            return SavedData.getVarFromTag(tag);
        }
        return new StoredVarBoolean(false);
    }

    public static class StoredVarFloat
    extends StoredVar {
        public float value;

        public StoredVarFloat(float valueToSet) {
            this.value = valueToSet;
        }

        public StoredVarFloat(NBTTagFloat tag) {
            this(tag.func_150288_h());
        }

        @Override
        public void invert() {
            this.value = -this.value;
        }

        @Override
        public boolean add(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value += (float)((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value += ((StoredVarFloat)other).value;
                return true;
            }
            return false;
        }

        @Override
        public boolean multiply(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value *= (float)((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value *= ((StoredVarFloat)other).value;
                return true;
            }
            return false;
        }

        @Override
        public boolean divide(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value /= (float)((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value /= ((StoredVarFloat)other).value;
                return true;
            }
            return false;
        }

        @Override
        public boolean mod(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value %= (float)((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value %= ((StoredVarFloat)other).value;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(StoredVar other) {
            if (other instanceof StoredVarBoolean) {
                return ((StoredVarBoolean)other).value ? this.value == 1.0f : this.value == 0.0f;
            }
            if (other instanceof StoredVarInt) {
                return this.value == (float)((StoredVarInt)other).value;
            }
            if (other instanceof StoredVarFloat) {
                return this.value == ((StoredVarFloat)other).value;
            }
            return false;
        }

        @Override
        public boolean lessThan(StoredVar other) {
            if (other instanceof StoredVarInt) {
                return this.value < (float)((StoredVarInt)other).value;
            }
            if (other instanceof StoredVarFloat) {
                return this.value < ((StoredVarFloat)other).value;
            }
            return false;
        }

        @Override
        public boolean greaterThan(StoredVar other) {
            if (other instanceof StoredVarInt) {
                return this.value > (float)((StoredVarInt)other).value;
            }
            if (other instanceof StoredVarFloat) {
                return this.value > ((StoredVarFloat)other).value;
            }
            return false;
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public NBTBase toNBT() {
            return new NBTTagFloat(this.value);
        }

        @Override
        public String getType() {
            return "float";
        }
    }

    public static class StoredVarInt
    extends StoredVar {
        public int value;

        public StoredVarInt(int valueToSet) {
            this.value = valueToSet;
        }

        public StoredVarInt(NBTTagInt tag) {
            this(tag.func_150287_d());
        }

        @Override
        public void invert() {
            this.value = -this.value;
        }

        @Override
        public boolean add(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value += ((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value = MathHelper.func_76141_d((float)((float)this.value + ((StoredVarFloat)other).value));
                return true;
            }
            return false;
        }

        @Override
        public boolean multiply(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value *= ((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value = MathHelper.func_76141_d((float)((float)this.value * ((StoredVarFloat)other).value));
                return true;
            }
            return false;
        }

        @Override
        public boolean divide(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value /= ((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value = MathHelper.func_76141_d((float)((float)this.value / ((StoredVarFloat)other).value));
                return true;
            }
            return false;
        }

        @Override
        public boolean mod(StoredVar other) {
            if (other instanceof StoredVarInt) {
                this.value %= ((StoredVarInt)other).value;
                return true;
            }
            if (other instanceof StoredVarFloat) {
                this.value = MathHelper.func_76141_d((float)((float)this.value % ((StoredVarFloat)other).value));
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(StoredVar other) {
            if (other instanceof StoredVarBoolean) {
                return ((StoredVarBoolean)other).value ? this.value == 1 : this.value == 0;
            }
            if (other instanceof StoredVarInt) {
                return this.value == ((StoredVarInt)other).value;
            }
            if (other instanceof StoredVarFloat) {
                return (float)this.value == ((StoredVarFloat)other).value;
            }
            return false;
        }

        @Override
        public boolean lessThan(StoredVar other) {
            if (other instanceof StoredVarInt) {
                return this.value < ((StoredVarInt)other).value;
            }
            if (other instanceof StoredVarFloat) {
                return (float)this.value < ((StoredVarFloat)other).value;
            }
            return false;
        }

        @Override
        public boolean greaterThan(StoredVar other) {
            if (other instanceof StoredVarInt) {
                return this.value > ((StoredVarInt)other).value;
            }
            if (other instanceof StoredVarFloat) {
                return (float)this.value > ((StoredVarFloat)other).value;
            }
            return false;
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public NBTBase toNBT() {
            return new NBTTagInt(this.value);
        }

        @Override
        public String getType() {
            return "integer";
        }
    }

    public static class StoredVarBoolean
    extends StoredVar {
        public boolean value;

        public StoredVarBoolean(boolean valueToSet) {
            this.value = valueToSet;
        }

        public StoredVarBoolean(NBTTagByte tag) {
            this(tag.func_150290_f() != 0);
        }

        @Override
        public void invert() {
            this.value = !this.value;
        }

        @Override
        public boolean equals(StoredVar other) {
            if (other instanceof StoredVarBoolean) {
                return this.value == ((StoredVarBoolean)other).value;
            }
            return false;
        }

        public String toString() {
            return "" + this.value;
        }

        @Override
        public NBTBase toNBT() {
            return new NBTTagByte((byte)(this.value ? 1 : 0));
        }

        @Override
        public String getType() {
            return "boolean";
        }
    }

    public static class StoredVarString
    extends StoredVar {
        public String value;

        public StoredVarString(String valueToSet) {
            this.value = valueToSet;
        }

        public StoredVarString(NBTTagString tag) {
            this(tag.func_150285_a_());
        }

        @Override
        public void invert() {
            this.value = new StringBuilder(this.value).reverse().toString();
        }

        @Override
        public boolean add(StoredVar other) {
            this.value = this.value + other;
            return true;
        }

        @Override
        public boolean equals(StoredVar other) {
            return this.value.equals(other.toString());
        }

        @Override
        public boolean lessThan(StoredVar other) {
            return this.value.length() < other.toString().length();
        }

        @Override
        public boolean greaterThan(StoredVar other) {
            return this.value.length() > other.toString().length();
        }

        public String toString() {
            return this.value;
        }

        @Override
        public NBTBase toNBT() {
            return new NBTTagString(this.value);
        }

        @Override
        public String getType() {
            return "string";
        }
    }

    public static abstract class StoredVar {
        public abstract NBTBase toNBT();

        public abstract String getType();

        public void invert() {
        }

        public boolean add(StoredVar other) {
            return false;
        }

        public boolean multiply(StoredVar other) {
            return false;
        }

        public boolean divide(StoredVar other) {
            return false;
        }

        public boolean mod(StoredVar other) {
            return false;
        }

        public boolean equals(StoredVar other) {
            return false;
        }

        public boolean lessThan(StoredVar other) {
            return false;
        }

        public boolean greaterThan(StoredVar other) {
            return false;
        }

        public boolean test(String operation, StoredVar other) {
            boolean equal = this.equals(other);
            if (operation.equals("=")) {
                return equal;
            }
            if (operation.equals("!=")) {
                return !equal;
            }
            if (operation.contains("<")) {
                boolean less = this.lessThan(other);
                if (operation.equals("<")) {
                    return less;
                }
                if (operation.equals("<=")) {
                    return less || equal;
                }
            }
            if (operation.contains(">")) {
                boolean greater = this.greaterThan(other);
                if (operation.equals(">")) {
                    return greater;
                }
                if (operation.equals(">=")) {
                    return greater || equal;
                }
            }
            return false;
        }
    }
}

