/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.utilities;

import com.tmtravlr.lootoverhaul.ConfigLoader;
import com.tmtravlr.lootoverhaul.LootOverhaul;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigIdFileGenerator {
    public static void generateIDFiles() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        boolean singleplayer = server != null && server.func_71264_H();
        File itemIds = new File(ConfigLoader.idFolder, "Item IDs.txt");
        File blockIds = new File(ConfigLoader.idFolder, "Block IDs.txt");
        File biomeIds = new File(ConfigLoader.idFolder, "Biome IDs.txt");
        File dimensionIds = new File(ConfigLoader.idFolder, "Dimension IDs.txt");
        File entityIds = new File(ConfigLoader.idFolder, "Entity IDs.txt");
        File potionIds = new File(ConfigLoader.idFolder, "Potion IDs.txt");
        File potionTypeIds = new File(ConfigLoader.idFolder, "Potion Type IDs.txt");
        File enchantIds = new File(ConfigLoader.idFolder, "Enchantment IDs.txt");
        File oreDictionary = new File(ConfigLoader.idFolder, "Ore Dictionary Info.txt");
        try {
            PrintStream itemWriteStream = new PrintStream(itemIds);
            itemWriteStream.println("## Item IDs: in the form <string id> - <number id> ##");
            Item.field_150901_e.forEach(item -> itemWriteStream.println(Item.field_150901_e.func_177774_c(item) + " - " + Item.func_150891_b((Item)item)));
            itemWriteStream.close();
            PrintStream blockWriteStream = new PrintStream(blockIds);
            blockWriteStream.println("## Block IDs: in the form <string id> - <number id> ##");
            Block.field_149771_c.forEach(block -> blockWriteStream.println(Block.field_149771_c.func_177774_c(block) + " - " + Block.func_149682_b((Block)block)));
            blockWriteStream.close();
            PrintStream entityWriteStream = new PrintStream(entityIds);
            entityWriteStream.println("## Entity IDs: in the form <string id> - <number id> ##");
            ForgeRegistries.ENTITIES.forEach(entity -> entityWriteStream.println(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity) + " - " + EntityList.getID((Class)entity.getEntityClass())));
            entityWriteStream.close();
            PrintStream biomeWriteStream = new PrintStream(biomeIds);
            biomeWriteStream.println("## Biome IDs                                           ##");
            biomeWriteStream.println("#########################################################");
            biomeWriteStream.println("## In the form:                                        ##");
            biomeWriteStream.println("## <biome name>                                        ##");
            biomeWriteStream.println("##    - Id: <biome id>                                 ##");
            biomeWriteStream.println("##    - Height Base: <biome height base>               ##");
            biomeWriteStream.println("##    - Height Variation: <biome height variation>     ##");
            biomeWriteStream.println("##    - Humidity: <biome humidity>                     ##");
            biomeWriteStream.println("##    - Temperature: <biome temperature base>          ##");
            biomeWriteStream.println("##    - Forge Biome Types: <list of forge biome types> ##");
            biomeWriteStream.println("#########################################################");
            Biome.field_185377_q.forEach(biome -> {
                biomeWriteStream.println(Biome.field_185377_q.func_177774_c(biome));
                biomeWriteStream.println("   - Id: " + Biome.func_185362_a((Biome)biome));
                biomeWriteStream.println("   - Height Base: " + biome.func_185355_j());
                biomeWriteStream.println("   - Height Variation: " + biome.func_185360_m());
                biomeWriteStream.println("   - Humidity: " + biome.func_76727_i());
                biomeWriteStream.println("   - Temperature: " + biome.func_185353_n());
                biomeWriteStream.print("   - Forge Biome Types: ");
                for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                    biomeWriteStream.print(type.getName() + " ");
                }
                biomeWriteStream.println();
                biomeWriteStream.println();
                biomeWriteStream.println();
            });
            biomeWriteStream.close();
            PrintStream dimensionWriteStream = new PrintStream(dimensionIds);
            dimensionWriteStream.println("## Dimension IDs                                                      ##");
            dimensionWriteStream.println("########################################################################");
            dimensionWriteStream.println("## In the form:                                                       ##");
            dimensionWriteStream.println("## <dimension name>                                                   ##");
            dimensionWriteStream.println("##    - Id: <dimension id>                                            ##");
            dimensionWriteStream.println("##    - Height: <dimension height>                                    ##");
            dimensionWriteStream.println("##    - Has Sky? <true if dimension has a sky>                        ##");
            dimensionWriteStream.println("##    - Cloud Height: <height of dimension's clouds (only on client)> ##");
            dimensionWriteStream.println("##    - Can Respawn Here? <true if players can respawn here>          ##");
            dimensionWriteStream.println("##    - Terrain Scale: <distance travelled per block (nether is 8)>   ##");
            dimensionWriteStream.println("########################################################################");
            if (server != null && server.field_71305_c.length > 0) {
                for (WorldServer world : server.field_71305_c) {
                    dimensionWriteStream.println(world.field_73011_w.func_186058_p().func_186065_b());
                    dimensionWriteStream.println("\t- Id: " + world.field_73011_w.getDimension());
                    dimensionWriteStream.println("\t- Height: " + world.field_73011_w.getActualHeight());
                    dimensionWriteStream.println("\t- Has Sky? " + world.field_73011_w.func_191066_m());
                    if (singleplayer) {
                        dimensionWriteStream.println("\t- Cloud Height: " + world.field_73011_w.func_76571_f());
                    }
                    dimensionWriteStream.println("\t- Can Respawn Here? " + world.field_73011_w.func_76567_e());
                    dimensionWriteStream.println("\t- Terrain Scale: " + world.field_73011_w.getMovementFactor());
                    dimensionWriteStream.println();
                    dimensionWriteStream.println();
                }
            }
            dimensionWriteStream.close();
            PrintStream potionWriteStream = new PrintStream(potionIds);
            potionWriteStream.println("## Potion IDs                                                          ##");
            potionWriteStream.println("#########################################################################");
            potionWriteStream.println("## In the form:                                                        ##");
            potionWriteStream.println("## <potion name>                                                       ##");
            potionWriteStream.println("##    - Id: <potion id>                                                ##");
            potionWriteStream.println("##    - Color: <potion color>                                          ##");
            potionWriteStream.println("##    - Is Instant: <true if an instant potion (like health)>          ##");
            potionWriteStream.println("##    - Is Bad: <true if considered a 'bad' potion>                    ##");
            potionWriteStream.println("##    - Is Beneficial: <true if considered 'beneficial' (client only)> ##");
            potionWriteStream.println("#########################################################################");
            Potion.field_188414_b.forEach(potion -> {
                potionWriteStream.println(Potion.field_188414_b.func_177774_c(potion));
                potionWriteStream.println("   - Id: " + Potion.func_188409_a((Potion)potion));
                potionWriteStream.println("   - Color: " + potion.func_76401_j());
                potionWriteStream.println("   - Is Instant: " + potion.func_76403_b());
                potionWriteStream.println("   - Is Bad: " + potion.func_76398_f());
                if (singleplayer) {
                    potionWriteStream.println("\t- Is Beneficial: " + potion.func_188408_i());
                }
                potionWriteStream.println();
                potionWriteStream.println();
            });
            potionWriteStream.close();
            PrintStream potionTypeWriteStream = new PrintStream(potionTypeIds);
            potionTypeWriteStream.println("## Potion Type IDs                                                        ##");
            potionTypeWriteStream.println("############################################################################");
            potionTypeWriteStream.println("## In the form:                                                           ##");
            potionTypeWriteStream.println("## <potion type name>                                                     ##");
            potionTypeWriteStream.println("##    - Effects: <List of potion effects>                                 ##");
            potionTypeWriteStream.println("##        <name> - <duration> - <amplifier> - <ambient> - <showParticles> ##");
            potionTypeWriteStream.println("##        etc...                                                          ##");
            potionTypeWriteStream.println("############################################################################");
            PotionType.field_185176_a.forEach(potionType -> {
                potionTypeWriteStream.println(PotionType.field_185176_a.func_177774_c(potionType));
                potionTypeWriteStream.println("   - Effects: ");
                potionType.func_185170_a().forEach(effect -> potionTypeWriteStream.println("       " + Potion.field_188414_b.func_177774_c((Object)effect.func_188419_a()) + " - " + effect.func_76459_b() + " - " + effect.func_76458_c() + " - " + effect.func_82720_e() + " - " + effect.func_188418_e()));
                potionTypeWriteStream.println();
                potionTypeWriteStream.println();
            });
            potionTypeWriteStream.close();
            PrintStream enchantmentWriteStream = new PrintStream(enchantIds);
            enchantmentWriteStream.println("## Enchantment IDs                                   ##");
            enchantmentWriteStream.println("#######################################################");
            enchantmentWriteStream.println("## In the form:                                      ##");
            enchantmentWriteStream.println("## <enchantment name>                                ##");
            enchantmentWriteStream.println("##    - Id: <enchantment id>                         ##");
            enchantmentWriteStream.println("##    - Rarity: <enchantment rarity (weight)>        ##");
            enchantmentWriteStream.println("##    - Is Treasure: <can only get through treasure> ##");
            enchantmentWriteStream.println("##    - Min Level: <min xp level for enchantment>    ##");
            enchantmentWriteStream.println("##    - Max Level: <max xp level for enchantment>    ##");
            enchantmentWriteStream.println("#######################################################");
            Enchantment.field_185264_b.forEach(enchantment -> {
                enchantmentWriteStream.println(Enchantment.field_185264_b.func_177774_c(enchantment));
                enchantmentWriteStream.println("   - Id: " + Enchantment.func_185258_b((Enchantment)enchantment));
                enchantmentWriteStream.println("   - Rarity: " + enchantment.func_77324_c());
                enchantmentWriteStream.println("   - Treasure: " + enchantment.func_185261_e());
                enchantmentWriteStream.println("   - Min Level: " + enchantment.func_77319_d());
                enchantmentWriteStream.println("   - Max Level: " + enchantment.func_77325_b());
                enchantmentWriteStream.println();
                enchantmentWriteStream.println();
            });
            enchantmentWriteStream.close();
            PrintStream oreDictWriteStream = new PrintStream(oreDictionary);
            oreDictWriteStream.println("## Ore Dictionary Info                      ##");
            oreDictWriteStream.println("##############################################");
            oreDictWriteStream.println("## In the form:                             ##");
            oreDictWriteStream.println("## <ore dictionary entry>                   ##");
            oreDictWriteStream.println("##     <item id registered> - <item damage> ##");
            oreDictWriteStream.println("##     etc...                               ##");
            oreDictWriteStream.println("##############################################");
            List<String> registeredEntries = Arrays.asList(OreDictionary.getOreNames());
            Collections.sort(registeredEntries);
            for (String entry : registeredEntries) {
                oreDictWriteStream.println(entry);
                for (ItemStack stack : OreDictionary.getOres((String)entry)) {
                    oreDictWriteStream.println(Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()) + " - " + (stack.func_77952_i() == Short.MAX_VALUE ? "any" : Integer.valueOf(stack.func_77952_i())));
                }
                oreDictWriteStream.println();
                oreDictWriteStream.println();
            }
            oreDictWriteStream.close();
        }
        catch (IOException x) {
            LootOverhaul.logger.error("Caught IO Exception while trying to write out ID files", (Throwable)x);
        }
    }
}

