/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.LootOverhaul;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import com.tmtravlr.lootoverhaul.utilities.SavedData;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class FunctionReplaceNBT
extends LootFunction {
    private String replace;
    private String[] valueList;
    private RandomValueRange valueRange;
    private String selector;
    private LootContextExtended.ExtendedEntityTarget target;
    private String scoreboardName;
    private String globalVar;
    private String entityVar;
    private EntityInfoType infoType;

    public FunctionReplaceNBT(LootCondition[] conditionsIn, String replaceIn, String[] replaceListIn, RandomValueRange rangeIn, String selectorIn, LootContextExtended.ExtendedEntityTarget targetIn, String scoreboardIn, String entityVar, String globalVar, EntityInfoType infoTypeIn) {
        super(conditionsIn);
        this.replace = replaceIn;
        this.valueList = replaceListIn;
        this.valueRange = rangeIn;
        this.target = targetIn;
        this.selector = selectorIn;
        this.scoreboardName = scoreboardIn;
        this.entityVar = entityVar;
        this.globalVar = globalVar;
        this.infoType = infoTypeIn;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (stack.func_77942_o()) {
            MinecraftServer server;
            String tagString = stack.func_77978_p().toString();
            String replacement = null;
            if (this.valueList != null) {
                replacement = this.valueList[rand.nextInt(this.valueList.length)];
            } else if (this.valueRange != null) {
                float value = this.valueRange.func_186507_b(rand);
                if (Math.floor(this.valueRange.func_186512_b()) == (double)this.valueRange.func_186512_b() && Math.floor(this.valueRange.func_186509_a()) == (double)this.valueRange.func_186509_a()) {
                    int intValue = MathHelper.func_76141_d((float)value);
                    replacement = "" + intValue;
                } else {
                    replacement = "" + value;
                }
            } else if (this.infoType == EntityInfoType.NAME) {
                Entity targetEntity = this.getEntityFromTargetOrSelector(context, this.target, this.selector);
                if (targetEntity != null) {
                    replacement = targetEntity.func_70005_c_();
                }
            } else if (this.infoType == EntityInfoType.UUID) {
                Entity targetEntity = this.getEntityFromTargetOrSelector(context, this.target, this.selector);
                if (targetEntity != null) {
                    replacement = targetEntity.func_110124_au().toString();
                }
            } else if (this.infoType == EntityInfoType.UUID_LEAST) {
                Entity targetEntity = this.getEntityFromTargetOrSelector(context, this.target, this.selector);
                if (targetEntity != null) {
                    replacement = String.valueOf(targetEntity.func_110124_au().getLeastSignificantBits()) + 'L';
                }
            } else if (this.infoType == EntityInfoType.UUID_MOST) {
                Entity targetEntity = this.getEntityFromTargetOrSelector(context, this.target, this.selector);
                if (targetEntity != null) {
                    replacement = String.valueOf(targetEntity.func_110124_au().getMostSignificantBits()) + 'L';
                }
            } else if (this.infoType == EntityInfoType.SCOREBOARD && this.scoreboardName != null) {
                Entity targetEntity = this.getEntityFromTargetOrSelector(context, this.target, this.selector);
                if (targetEntity != null) {
                    replacement = String.valueOf(LootHelper.getScoreboardScore(targetEntity, this.scoreboardName));
                }
            } else if (this.infoType == EntityInfoType.ENTITY_VAR) {
                Entity targetEntity = this.getEntityFromTargetOrSelector(context, this.target, this.selector);
                if (targetEntity != null) {
                    replacement = String.valueOf(SavedData.getEntityVar(targetEntity, this.entityVar));
                }
            } else if (this.infoType == EntityInfoType.GLOBAL_VAR && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
                replacement = String.valueOf((Object)SavedData.getSavedData(server.func_130014_f_()));
            }
            if (replacement == null) {
                replacement = "";
            }
            if (!this.replace.equals(replacement)) {
                tagString = tagString.replace(this.replace, replacement);
            }
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)tagString));
            }
            catch (NBTException e) {
                LootOverhaul.logger.warn("Unable to generate loot with replacement.", (Throwable)e);
            }
        }
        return stack;
    }

    private Entity getEntityFromTargetOrSelector(LootContext context, LootContextExtended.ExtendedEntityTarget target, String selector) {
        if (target != null) {
            return LootHelper.getEntityFromContext(context, this.target);
        }
        try {
            return CommandBase.func_184885_b((MinecraftServer)context.getWorld().func_73046_m(), (ICommandSender)context.getWorld().func_73046_m(), (String)selector);
        }
        catch (CommandException e) {
            return null;
        }
    }

    private static enum EntityInfoType {
        NAME,
        UUID,
        UUID_LEAST,
        UUID_MOST,
        SCOREBOARD,
        ENTITY_VAR,
        GLOBAL_VAR;

    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionReplaceNBT> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "replace_nbt"), FunctionReplaceNBT.class);
        }

        public void serialize(JsonObject json, FunctionReplaceNBT value, JsonSerializationContext context) {
            json.add("replace", (JsonElement)new JsonPrimitive(value.replace));
            if (value.valueRange != null) {
                json.add("range", context.serialize((Object)value.valueRange));
            } else if (value.valueList != null) {
                LootHelper.serializeStringArray(value.valueList, json, "list");
            } else if (value.infoType == EntityInfoType.NAME) {
                if (value.target == null) {
                    json.addProperty("name", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "name", value.target);
                }
            } else if (value.infoType == EntityInfoType.UUID) {
                if (value.target == null) {
                    json.addProperty("uuid", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "uuid", value.target);
                }
            } else if (value.infoType == EntityInfoType.UUID_LEAST) {
                if (value.target == null) {
                    json.addProperty("uuid", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "uuid_least", value.target);
                }
            } else if (value.infoType == EntityInfoType.UUID_MOST) {
                if (value.target == null) {
                    json.addProperty("uuid", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "uuid_most", value.target);
                }
            } else if (value.scoreboardName != null && value.infoType == EntityInfoType.SCOREBOARD) {
                json.addProperty("score", value.scoreboardName);
                if (value.target == null) {
                    json.addProperty("target", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "target", value.target);
                }
            } else if (value.scoreboardName != null && value.infoType == EntityInfoType.ENTITY_VAR) {
                json.addProperty("entity_variable", value.entityVar);
                if (value.target == null) {
                    json.addProperty("target", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "target", value.target);
                }
            } else if (value.scoreboardName != null && value.infoType == EntityInfoType.GLOBAL_VAR) {
                json.addProperty("global_variable", value.globalVar);
                if (value.target == null) {
                    json.addProperty("target", value.selector);
                } else {
                    LootHelper.serializeExtendedEntityTarget(json, "target", value.target);
                }
            }
        }

        public FunctionReplaceNBT deserialize(JsonObject json, JsonDeserializationContext context, LootCondition[] conditions) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"replace");
            String[] values = null;
            RandomValueRange range = null;
            String selector = null;
            LootContextExtended.ExtendedEntityTarget target = null;
            String scoreboardName = null;
            String entityVar = null;
            String globalVar = null;
            EntityInfoType infoType = null;
            if (json.has("range")) {
                range = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"range", (JsonDeserializationContext)context, RandomValueRange.class);
            } else if (json.has("list")) {
                values = LootHelper.deserializeStringArray(json, "list");
            } else if (json.has("name")) {
                infoType = EntityInfoType.NAME;
                target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "name");
                if (target == null) {
                    selector = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
                }
            } else if (json.has("uuid")) {
                infoType = EntityInfoType.UUID;
                target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "uuid");
                if (target == null) {
                    selector = JsonUtils.func_151200_h((JsonObject)json, (String)"uuid");
                }
            } else if (json.has("uuid_least")) {
                infoType = EntityInfoType.UUID_LEAST;
                target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "uuid_least");
                if (target == null) {
                    selector = JsonUtils.func_151200_h((JsonObject)json, (String)"uuid_least");
                }
            } else if (json.has("uuid_most")) {
                infoType = EntityInfoType.UUID_MOST;
                target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "uuid_most");
                if (target == null) {
                    selector = JsonUtils.func_151200_h((JsonObject)json, (String)"uuid_most");
                }
            } else if (json.has("score")) {
                infoType = EntityInfoType.SCOREBOARD;
                scoreboardName = JsonUtils.func_151200_h((JsonObject)json, (String)"score");
                target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "target");
                if (target == null) {
                    selector = JsonUtils.func_151200_h((JsonObject)json, (String)"target");
                }
            } else if (json.has("entity_variable")) {
                infoType = EntityInfoType.ENTITY_VAR;
                entityVar = JsonUtils.func_151200_h((JsonObject)json, (String)"entity_variable");
                target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "target");
                if (target == null) {
                    selector = JsonUtils.func_151200_h((JsonObject)json, (String)"target");
                }
            } else if (json.has("global_variable")) {
                infoType = EntityInfoType.GLOBAL_VAR;
                globalVar = JsonUtils.func_151200_h((JsonObject)json, (String)"global_variable");
            } else {
                throw new JsonSyntaxException("Valid replacement type not found for " + name);
            }
            return new FunctionReplaceNBT(conditions, name, values, range, selector, target, scoreboardName, entityVar, globalVar, infoType);
        }
    }
}

