/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class FunctionFortuneEnchant
extends LootFunction {
    private RandomValueRange count;
    private int limit;

    public FunctionFortuneEnchant(LootCondition[] conditions, RandomValueRange countIn, int limitIn) {
        super(conditions);
        this.count = countIn;
        this.limit = limitIn;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        LootContextExtended contextExtended;
        Entity entity;
        if (context instanceof LootContextExtended && (entity = (contextExtended = (LootContextExtended)context).getLooter()) instanceof EntityLivingBase && context instanceof LootContextExtended) {
            int fortune = contextExtended.getFortuneModifier();
            if (fortune == 0) {
                return stack;
            }
            float extra = (float)fortune * this.count.func_186507_b(rand);
            stack.func_190917_f(Math.round(extra));
            if (this.limit != 0 && stack.func_190916_E() > this.limit) {
                stack.func_190920_e(this.limit);
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionFortuneEnchant> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "fortune_enchant"), FunctionFortuneEnchant.class);
        }

        public void serialize(JsonObject object, FunctionFortuneEnchant value, JsonSerializationContext serializationContext) {
            object.add("count", serializationContext.serialize((Object)value.count));
            if (value.limit > 0) {
                object.add("limit", serializationContext.serialize((Object)value.limit));
            }
        }

        public FunctionFortuneEnchant deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new FunctionFortuneEnchant(conditionsIn, (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), JsonUtils.func_151208_a((JsonObject)object, (String)"limit", (int)0));
        }
    }
}

