/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionWeather
implements LootCondition {
    private List<WeatherType> weatherTypes;

    public ConditionWeather(List<WeatherType> weatherToSet) {
        this.weatherTypes = weatherToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        BlockPos pos = LootHelper.getPosFromContext(context);
        boolean rain = context.getWorld().func_72896_J();
        boolean snow = false;
        boolean overcast = false;
        if (pos != null) {
            Biome biome = context.getWorld().func_180494_b(pos);
            rain = context.getWorld().func_175727_C(pos);
            snow = context.getWorld().func_72896_J() && context.getWorld().func_175708_f(pos, false);
            overcast = context.getWorld().func_72896_J() && !biome.func_76738_d();
        }
        boolean thunder = context.getWorld().func_72911_I();
        boolean clear = !rain && !snow && !overcast && !thunder;
        for (WeatherType weather : this.weatherTypes) {
            if (!(weather == WeatherType.CLEAR && clear || weather == WeatherType.OVERCAST && overcast || weather == WeatherType.RAIN && rain || weather == WeatherType.SNOW && snow) && (weather != WeatherType.THUNDER || !thunder)) continue;
            return true;
        }
        return false;
    }

    private static enum WeatherType {
        CLEAR,
        OVERCAST,
        RAIN,
        SNOW,
        THUNDER;

    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionWeather> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "weather"), ConditionWeather.class);
        }

        public void serialize(JsonObject json, ConditionWeather value, JsonSerializationContext context) {
            LootHelper.serializeStringArray(value.weatherTypes.stream().map(Enum::name).collect(Collectors.toList()).toArray(new String[0]), json, "weather");
        }

        public ConditionWeather deserialize(JsonObject json, JsonDeserializationContext context) {
            String[] weatherStrings = LootHelper.deserializeStringArray(json, "weather");
            ArrayList<WeatherType> weatherTypes = new ArrayList<WeatherType>();
            Arrays.stream(weatherStrings).forEach(name -> {
                try {
                    weatherTypes.add(WeatherType.valueOf(name.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Weather type '" + name + "' not recognized; it must be CLEAR, OVERCAST, RAIN, SNOW, or THUNDER.");
                }
            });
            return new ConditionWeather(weatherTypes);
        }

        private void checkNames(String[] weatherStrings) {
        }
    }
}

