/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionToolType
implements LootCondition {
    private String[] toolTypes;

    public ConditionToolType(String[] toolTypes) {
        this.toolTypes = toolTypes;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity looter = context instanceof LootContextExtended ? LootHelper.getEntityFromContext(context, LootContextExtended.ExtendedEntityTarget.LOOTER) : context.func_186492_c();
        if (looter instanceof EntityLivingBase) {
            ItemStack heldItemStack = ((EntityLivingBase)looter).func_184614_ca();
            Item heldItem = heldItemStack.func_77973_b();
            HashSet<String> heldItemTypes = new HashSet<String>(heldItem.getToolClasses(heldItemStack));
            if (heldItem instanceof ItemSword) {
                heldItemTypes.add("sword");
            }
            if (heldItem instanceof ItemShears) {
                heldItemTypes.add("shears");
            }
            if (heldItem instanceof ItemHoe) {
                heldItemTypes.add("hoe");
            }
            if (heldItem instanceof ItemBow) {
                heldItemTypes.add("bow");
            }
            for (String toolType : this.toolTypes) {
                if (!heldItemTypes.contains(toolType)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionToolType> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "tool_type"), ConditionToolType.class);
        }

        public void serialize(JsonObject json, ConditionToolType value, JsonSerializationContext context) {
            LootHelper.serializeStringArray(value.toolTypes, json, "type");
        }

        public ConditionToolType deserialize(JsonObject json, JsonDeserializationContext context) {
            String[] types = LootHelper.deserializeStringArray(json, "type");
            return new ConditionToolType(types);
        }
    }
}

