/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionRandomChanceWithFortune
implements LootCondition {
    private final float chance;
    private final float fortuneMultiplier;

    public ConditionRandomChanceWithFortune(float chanceIn, float fortuneMultiplierIn) {
        this.chance = chanceIn;
        this.fortuneMultiplier = fortuneMultiplierIn;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        int i = LootHelper.getFortuneModifierFromContext(context);
        return rand.nextFloat() < this.chance + (float)i * this.fortuneMultiplier;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionRandomChanceWithFortune> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "random_chance_with_fortune"), ConditionRandomChanceWithFortune.class);
        }

        public void serialize(JsonObject json, ConditionRandomChanceWithFortune value, JsonSerializationContext context) {
            json.addProperty("chance", (Number)Float.valueOf(value.chance));
            json.addProperty("fortune_multiplier", (Number)Float.valueOf(value.fortuneMultiplier));
        }

        public ConditionRandomChanceWithFortune deserialize(JsonObject json, JsonDeserializationContext context) {
            return new ConditionRandomChanceWithFortune(JsonUtils.func_151217_k((JsonObject)json, (String)"chance"), JsonUtils.func_151217_k((JsonObject)json, (String)"fortune_multiplier"));
        }
    }
}

