/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionLightLevel
implements LootCondition {
    private LightType type;
    private LootHelper.RangeFloat level;

    public ConditionLightLevel(LootHelper.RangeFloat level, LightType type) {
        this.level = level;
        this.type = type;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        BlockPos pos = LootHelper.getPosFromContext(context);
        if (pos != null) {
            float skyLight = context.getWorld().func_175642_b(EnumSkyBlock.SKY, pos);
            float blockLight = context.getWorld().func_175642_b(EnumSkyBlock.BLOCK, pos);
            if (this.type == LightType.SKY) {
                return this.level.isInRange(Float.valueOf(skyLight));
            }
            if (this.type == LightType.BLOCK) {
                return this.level.isInRange(Float.valueOf(blockLight));
            }
            return this.level.isInRange(Float.valueOf(Math.max(skyLight, blockLight)));
        }
        return false;
    }

    private static enum LightType {
        SKY,
        BLOCK,
        COMBINED;

    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionLightLevel> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "light_level"), ConditionLightLevel.class);
        }

        public void serialize(JsonObject json, ConditionLightLevel value, JsonSerializationContext context) {
        }

        public ConditionLightLevel deserialize(JsonObject json, JsonDeserializationContext context) {
            LootHelper.RangeFloat level = LootHelper.deserializeRangeFloat(json, "level");
            LightType type = LightType.COMBINED;
            if (json.has("type")) {
                try {
                    type = LightType.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"type").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new JsonSyntaxException("Unknown light type. Try using SKY, BLOCK, or COMBINED.", (Throwable)e);
                }
            }
            return new ConditionLightLevel(level, type);
        }
    }
}

