/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import com.tmtravlr.lootoverhaul.utilities.SavedData;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionEntityVar
implements LootCondition {
    private String name;
    private String type;
    private NBTBase[] valueList;
    private LootHelper.RangeFloat valueRange;
    private LootContextExtended.ExtendedEntityTarget target;

    public ConditionEntityVar(String nameToSet, String typeToSet, NBTBase[] valuesToSet, LootHelper.RangeFloat rangeToSet, LootContextExtended.ExtendedEntityTarget targetToSet) {
        this.name = nameToSet;
        this.type = typeToSet;
        this.valueList = valuesToSet;
        this.valueRange = rangeToSet;
        this.target = targetToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity entity = LootHelper.getEntityFromContext(context, this.target);
        if (entity == null) {
            return false;
        }
        if (this.type.isEmpty()) {
            SavedData.StoredVar var = SavedData.getEntityVar(entity, this.name);
            return var != null;
        }
        if (this.valueRange == null && this.valueList == null) {
            SavedData.StoredVar var = SavedData.getEntityVar(entity, this.name);
            return var != null && var.getType() == this.type;
        }
        SavedData.StoredVar var = SavedData.getEntityVar(entity, this.name, this.type);
        if (this.valueRange != null) {
            if (var instanceof SavedData.StoredVarFloat) {
                return this.valueRange.isInRange(Float.valueOf(((SavedData.StoredVarFloat)var).value));
            }
            if (var instanceof SavedData.StoredVarInt) {
                return this.valueRange.isInRange(Float.valueOf(((SavedData.StoredVarInt)var).value));
            }
        }
        if (this.valueList != null) {
            for (NBTBase value : this.valueList) {
                if (!value.equals((Object)var.toNBT())) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionEntityVar> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "entity_variable"), ConditionEntityVar.class);
        }

        public void serialize(JsonObject json, ConditionEntityVar value, JsonSerializationContext context) {
            json.add("name", (JsonElement)new JsonPrimitive(value.name));
            json.add("type", (JsonElement)new JsonPrimitive(value.type));
            if (value.valueList.length == 1) {
                LootHelper.serializeNBT(json, "value", value.valueList[0]);
            }
            JsonArray array = new JsonArray();
            for (NBTBase base : value.valueList) {
                JsonObject innerJson = new JsonObject();
                LootHelper.serializeNBT(innerJson, "value", base);
                array.add((JsonElement)innerJson);
            }
            json.add("value", (JsonElement)array);
            LootHelper.serializeExtendedEntityTarget(json, "target", value.target);
        }

        public ConditionEntityVar deserialize(JsonObject json, JsonDeserializationContext context) {
            NBTBase[] array = null;
            LootHelper.RangeFloat range = null;
            String type = JsonUtils.func_151219_a((JsonObject)json, (String)"type", (String)"");
            if (!type.isEmpty() && json.has("value")) {
                if ((type.equalsIgnoreCase("float") || type.equalsIgnoreCase("integer")) && json.has("value") && json.get("value").isJsonObject()) {
                    range = LootHelper.deserializeRangeFloat(json, "value");
                } else {
                    array = LootHelper.deserializeNBTArray(json, "value");
                }
            }
            LootContextExtended.ExtendedEntityTarget target = LootHelper.deserializeExtendedEntityTarget(json, "target", LootContextExtended.ExtendedEntityTarget.THIS);
            return new ConditionEntityVar(JsonUtils.func_151200_h((JsonObject)json, (String)"name"), type, array, range, target);
        }
    }
}

