/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import com.tmtravlr.lootoverhaul.utilities.BlockStateMatcher;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionBlockState
implements LootCondition {
    private LootHelper.RangeFloat metaRange;
    private int[] metaList;
    private BlockStateMatcher[] states;

    public ConditionBlockState(LootHelper.RangeFloat metaRangeToSet, int[] metaListToSet, BlockStateMatcher[] blockStatesToSet) {
        this.metaRange = metaRangeToSet;
        this.metaList = metaListToSet;
        this.states = blockStatesToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        if (context instanceof LootContextExtended) {
            LootContextExtended contextExtended = (LootContextExtended)context;
            BlockPos pos = contextExtended.getPosition();
            IBlockState state = contextExtended.getBrokenBlockState();
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            if (this.metaRange != null && !this.metaRange.isInRange(Float.valueOf(meta))) {
                return false;
            }
            if (this.metaList != null && !Arrays.asList(new int[][]{this.metaList}).contains(meta)) {
                return false;
            }
            if (this.states != null) {
                for (BlockStateMatcher stateMatcher : this.states) {
                    if (stateMatcher.matches(state)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionBlockState> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "block_state"), ConditionBlockState.class);
        }

        public void serialize(JsonObject json, ConditionBlockState value, JsonSerializationContext context) {
            if (value.metaList != null) {
                LootHelper.serializeIntArray(value.metaList, json, "meta");
            } else if (value.metaRange != null) {
                value.metaRange.serialize(json, "meta");
            }
            if (value.states != null) {
                BlockStateMatcher.serialize(value.states, json, "state");
            }
        }

        public ConditionBlockState deserialize(JsonObject json, JsonDeserializationContext context) {
            LootHelper.RangeFloat metaRange = null;
            int[] metaList = null;
            BlockStateMatcher[] states = null;
            if (json.has("meta")) {
                if (json.get("meta").isJsonObject()) {
                    metaRange = LootHelper.deserializeRangeFloat(json, "meta");
                } else {
                    metaList = LootHelper.deserializeIntArray(json, "meta");
                }
            }
            if (json.has("state")) {
                states = BlockStateMatcher.deserialize(json, "state");
            }
            if (metaRange == null && metaList == null && states == null) {
                throw new JsonSyntaxException("Expected one or both fields 'state' and 'meta'");
            }
            return new ConditionBlockState(metaRange, metaList, states);
        }
    }
}

