/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.BiomeDictionary;

public class ConditionBiomeType
implements LootCondition {
    private final BiomeDictionary.Type[] biomeTypes;

    public ConditionBiomeType(BiomeDictionary.Type[] biomesToSet) {
        this.biomeTypes = biomesToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        BlockPos pos = LootHelper.getPosFromContext(context);
        if (pos != null) {
            Biome biome = context.getWorld().func_180494_b(pos);
            Set currentTypes = BiomeDictionary.getTypes((Biome)biome);
            for (BiomeDictionary.Type biomeType : this.biomeTypes) {
                for (BiomeDictionary.Type currentType : currentTypes) {
                    if (currentType != biomeType) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionBiomeType> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "biome_type"), ConditionBiomeType.class);
        }

        public void serialize(JsonObject json, ConditionBiomeType value, JsonSerializationContext context) {
            if (value.biomeTypes.length == 1) {
                json.add("biome_type", (JsonElement)new JsonPrimitive(value.biomeTypes[0].getName()));
            } else {
                JsonArray biomeList = new JsonArray();
                for (BiomeDictionary.Type biomeType : value.biomeTypes) {
                    biomeList.add((JsonElement)new JsonPrimitive(biomeType.getName()));
                }
                json.add("biome_type", (JsonElement)biomeList);
            }
        }

        public ConditionBiomeType deserialize(JsonObject json, JsonDeserializationContext context) {
            if (JsonUtils.func_151205_a((JsonObject)json, (String)"biome_type")) {
                return new ConditionBiomeType(new BiomeDictionary.Type[]{this.getBiomeTypeFromString(JsonUtils.func_151200_h((JsonObject)json, (String)"biome_type"))});
            }
            JsonArray biomeArray = JsonUtils.func_151214_t((JsonObject)json, (String)"biome_type");
            BiomeDictionary.Type[] biomesToSet = new BiomeDictionary.Type[biomeArray.size()];
            for (int i = 0; i < biomeArray.size(); ++i) {
                if (!biomeArray.get(i).isJsonPrimitive() || !biomeArray.get(i).getAsJsonPrimitive().isString()) {
                    throw new JsonSyntaxException("Expected biome type array element to be a String");
                }
                biomesToSet[i] = this.getBiomeTypeFromString(biomeArray.get(i).getAsString());
            }
            return new ConditionBiomeType(biomesToSet);
        }

        private BiomeDictionary.Type getBiomeTypeFromString(String biomeTypeName) {
            BiomeDictionary.Type biomeType = BiomeDictionary.Type.getType((String)biomeTypeName, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            return biomeType;
        }
    }
}

