/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.LootOverhaul;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionBiome;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionBiomeHeight;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionBiomeHumidity;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionBiomeTemp;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionBiomeType;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionBlockState;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionCommand;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionDifficulty;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionDimension;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionDimensionHasSky;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionDimensionHeight;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionDimensionWaterVaporize;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionEntityType;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionEntityVar;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionGlobalVar;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionLightLevel;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionMoon;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionNBTMatches;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionNearBlock;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionNot;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionOr;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionRandomChanceWithFortune;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionSeeSky;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionSilkTouch;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionToolType;
import com.tmtravlr.lootoverhaul.loot.conditions.ConditionWeather;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionCustomPotionEffects;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionDelay;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionEnchantments;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionFortuneEnchant;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionGroup;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionOffset;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionPosition;
import com.tmtravlr.lootoverhaul.loot.functions.FunctionReplaceNBT;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;

public class LootHelper {
    public static final ResourceLocation ALL_ENTTIIES = new ResourceLocation("entities/all");

    public static void loadConditions() {
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionNot.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionOr.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionDimension.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionDimensionHasSky.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionDimensionHeight.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionDimensionWaterVaporize.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionBiome.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionBiomeType.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionBiomeTemp.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionBiomeHeight.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionBiomeHumidity.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionWeather.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionSeeSky.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionLightLevel.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionMoon.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionDifficulty.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionEntityType.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionNBTMatches.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionCommand.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionGlobalVar.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionEntityVar.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionNearBlock.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionBlockState.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionSilkTouch.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionToolType.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new ConditionRandomChanceWithFortune.Serializer());
    }

    public static void loadFuntions() {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionReplaceNBT.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionFortuneEnchant.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionDelay.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionPosition.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionOffset.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionCustomPotionEffects.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionEnchantments.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new FunctionGroup.Serializer());
    }

    public static int getScoreboardScore(Entity entity, String scoreboardName) {
        int score = 0;
        if (entity.func_184102_h() == null) {
            return score;
        }
        Scoreboard scoreboard = entity.func_184102_h().func_71218_a(0).func_96441_U();
        ScoreObjective scoreObjective = scoreboard.func_96518_b(scoreboardName);
        if (scoreObjective == null) {
            return score;
        }
        String entityName = entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_70005_c_() : entity.func_189512_bd();
        if (scoreboard.func_178819_b(entityName, scoreObjective)) {
            score = scoreboard.func_96529_a(entityName, scoreObjective).func_96652_c();
        }
        return score;
    }

    public static IBlockState getStateFromNBT(Block block, NBTTagCompound stateTag) {
        IBlockState state = block.func_176223_P();
        BlockStateContainer blockstatecontainer = block.func_176194_O();
        if (stateTag == null || stateTag.func_82582_d()) {
            return state;
        }
        for (String key : stateTag.func_150296_c()) {
            NBTBase value = stateTag.func_74781_a(key);
            IProperty property = blockstatecontainer.func_185920_a(key);
            if (property == null) continue;
            Comparable<Byte> comparable = null;
            switch (value.func_74732_a()) {
                case 1: {
                    comparable = ((NBTTagByte)value).func_150290_f();
                    break;
                }
                case 2: {
                    comparable = ((NBTTagShort)value).func_150289_e();
                    break;
                }
                case 3: {
                    comparable = ((NBTTagInt)value).func_150287_d();
                    break;
                }
                case 4: {
                    comparable = ((NBTTagLong)value).func_150291_c();
                    break;
                }
                case 5: {
                    comparable = Float.valueOf(((NBTTagFloat)value).func_150288_h());
                    break;
                }
                case 6: {
                    comparable = ((NBTTagDouble)value).func_150286_g();
                    break;
                }
                case 8: {
                    comparable = (Comparable)property.func_185929_b(((NBTTagString)value).func_150285_a_()).orNull();
                }
            }
            if (comparable == null) continue;
            try {
                state = LootHelper.getBlockState(state, property, comparable);
            }
            catch (IllegalArgumentException e) {
                LootOverhaul.logger.warn("Tried to parse an invalid block state '" + key + ": " + comparable + "'. Ignoring.", (Throwable)e);
            }
        }
        return state;
    }

    private static <T extends Comparable<T>> IBlockState getBlockState(IBlockState state, IProperty<T> property, Comparable<?> comparable) {
        return state.func_177226_a(property, comparable);
    }

    @Nullable
    public static BlockPos getPosFromContext(LootContext context) {
        BlockPos pos = null;
        if (context instanceof LootContextExtended) {
            pos = ((LootContextExtended)context).getPosition();
        } else if (context.func_186493_a() != null) {
            pos = context.func_186493_a().func_180425_c();
        } else if (context.func_186492_c() != null) {
            pos = context.func_186492_c().func_180425_c();
        } else if (context.func_186495_b() != null) {
            pos = context.func_186495_b().func_180425_c();
        }
        return pos;
    }

    @Nullable
    public static Entity getEntityFromContext(LootContext context, LootContextExtended.ExtendedEntityTarget target) {
        Entity entity = null;
        if (context instanceof LootContextExtended) {
            entity = ((LootContextExtended)context).getEntityExtended(target);
        } else if (target.getEntityTargets().length > 0) {
            LootContext.EntityTarget oldTarget;
            LootContext.EntityTarget[] entityTargetArray = target.getEntityTargets();
            int n = entityTargetArray.length;
            for (int i = 0; i < n && (entity = context.func_186494_a(oldTarget = entityTargetArray[i])) == null; ++i) {
            }
        }
        return entity;
    }

    public static int getFortuneModifierFromContext(LootContext context) {
        int fortune = 0;
        if (context instanceof LootContextExtended) {
            fortune = ((LootContextExtended)context).getFortuneModifier();
        } else {
            Entity looter = LootHelper.getEntityFromContext(context, LootContextExtended.ExtendedEntityTarget.LOOTER);
            if (looter instanceof EntityLivingBase) {
                fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((EntityLivingBase)looter).func_184614_ca());
            }
        }
        return fortune;
    }

    public static boolean getHasSilkTouchFromContext(LootContext context) {
        boolean silkTouch = false;
        if (context instanceof LootContextExtended) {
            silkTouch = ((LootContextExtended)context).isSilkTouch();
        } else {
            Entity looter = LootHelper.getEntityFromContext(context, LootContextExtended.ExtendedEntityTarget.LOOTER);
            if (looter instanceof EntityLivingBase) {
                silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)((EntityLivingBase)looter).func_184614_ca()) > 0;
            }
        }
        return silkTouch;
    }

    public static RangeFloat deserializeRangeFloat(JsonObject json, String name) {
        Float min = null;
        Float max = null;
        if (json.get(name).isJsonPrimitive() && json.get(name).getAsJsonPrimitive().isNumber()) {
            min = max = Float.valueOf(JsonUtils.func_151217_k((JsonObject)json, (String)name));
        } else {
            JsonObject innerJson = JsonUtils.func_152754_s((JsonObject)json, (String)name);
            if (!JsonUtils.func_151204_g((JsonObject)innerJson, (String)"min") && !JsonUtils.func_151204_g((JsonObject)innerJson, (String)"max")) {
                throw new JsonSyntaxException(name + ": Expected one or both fields 'min' and 'max'");
            }
            if (JsonUtils.func_151204_g((JsonObject)innerJson, (String)"min")) {
                min = Float.valueOf(JsonUtils.func_151217_k((JsonObject)innerJson, (String)"min"));
            }
            if (JsonUtils.func_151204_g((JsonObject)innerJson, (String)"max")) {
                max = Float.valueOf(JsonUtils.func_151217_k((JsonObject)innerJson, (String)"max"));
            }
        }
        return new RangeFloat(min, max);
    }

    public static String[] deserializeStringArray(JsonObject json, String name) {
        if (JsonUtils.func_151205_a((JsonObject)json, (String)name)) {
            return new String[]{JsonUtils.func_151200_h((JsonObject)json, (String)name)};
        }
        JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)name);
        String[] array = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (!jsonArray.get(i).isJsonPrimitive() || !jsonArray.get(i).getAsJsonPrimitive().isString()) {
                throw new JsonSyntaxException("Expected '" + name + "' array element to be a string");
            }
            array[i] = jsonArray.get(i).getAsString();
        }
        return array;
    }

    public static int[] deserializeIntArray(JsonObject json, String name) {
        if (JsonUtils.func_188175_b((JsonElement)json.get(name))) {
            return new int[]{JsonUtils.func_151203_m((JsonObject)json, (String)name)};
        }
        JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)name);
        int[] array = new int[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (!JsonUtils.func_188175_b((JsonElement)jsonArray.get(i))) {
                throw new JsonSyntaxException("Expected '" + name + "' array element to be an integer");
            }
            array[i] = jsonArray.get(i).getAsInt();
        }
        return array;
    }

    public static void serializeStringArray(String[] array, JsonObject json, String name) {
        if (array.length == 1) {
            json.add(name, (JsonElement)new JsonPrimitive(array[0]));
        } else {
            JsonArray commandList = new JsonArray();
            for (String element : array) {
                commandList.add((JsonElement)new JsonPrimitive(element));
            }
            json.add(name, (JsonElement)commandList);
        }
    }

    public static void serializeIntArray(int[] array, JsonObject json, String name) {
        if (array.length == 1) {
            json.add(name, (JsonElement)new JsonPrimitive((Number)array[0]));
        } else {
            JsonArray commandList = new JsonArray();
            for (int element : array) {
                commandList.add((JsonElement)new JsonPrimitive((Number)element));
            }
            json.add(name, (JsonElement)commandList);
        }
    }

    public static NBTBase deserializeNBT(JsonObject json, String name) {
        return LootHelper.deserializeNBTArray(json, name)[0];
    }

    public static NBTBase[] deserializeNBTArray(JsonObject json, String name) {
        String type = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        if (JsonUtils.func_151202_d((JsonObject)json, (String)name)) {
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)name);
            NBTBase[] array = new NBTBase[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (type.equalsIgnoreCase("string")) {
                    array[i] = new NBTTagString(JsonUtils.func_151200_h((JsonObject)json, (String)name));
                    continue;
                }
                if (type.equalsIgnoreCase("boolean")) {
                    array[i] = new NBTTagByte(JsonUtils.func_151212_i((JsonObject)json, (String)name) ? (byte)1 : 0);
                    continue;
                }
                if (type.equalsIgnoreCase("integer")) {
                    array[i] = new NBTTagInt(JsonUtils.func_151203_m((JsonObject)json, (String)name));
                    continue;
                }
                if (type.equalsIgnoreCase("float")) {
                    array[i] = new NBTTagFloat(JsonUtils.func_151217_k((JsonObject)json, (String)name));
                    continue;
                }
                throw new JsonSyntaxException(name + ": Unrecognized variable type '" + type + "'. Valid types are 'string', 'boolean', 'integer', and 'float'.");
            }
            return array;
        }
        if (type.equalsIgnoreCase("string")) {
            return new NBTBase[]{new NBTTagString(JsonUtils.func_151200_h((JsonObject)json, (String)name))};
        }
        if (type.equalsIgnoreCase("boolean")) {
            return new NBTBase[]{new NBTTagByte(JsonUtils.func_151212_i((JsonObject)json, (String)name) ? (byte)1 : 0)};
        }
        if (type.equalsIgnoreCase("integer")) {
            return new NBTBase[]{new NBTTagInt(JsonUtils.func_151203_m((JsonObject)json, (String)name))};
        }
        if (type.equalsIgnoreCase("float")) {
            return new NBTBase[]{new NBTTagFloat(JsonUtils.func_151217_k((JsonObject)json, (String)name))};
        }
        throw new JsonSyntaxException(name + ": Unrecognized variable type '" + type + "'. Valid types are 'string', 'boolean', 'integer', and 'float'.");
    }

    public static void serializeNBT(JsonObject json, String name, NBTBase nbt) {
        LootHelper.serializeNBTArray(json, name, new NBTBase[]{nbt});
    }

    public static void serializeNBTArray(JsonObject json, String name, NBTBase[] nbtArray) {
        String type = "?";
        if (nbtArray.length == 1) {
            NBTBase nbt = nbtArray[0];
            if (nbt instanceof NBTTagString) {
                json.add(name, (JsonElement)new JsonPrimitive(((NBTTagString)nbt).func_150285_a_()));
                type = "string";
            } else if (nbt instanceof NBTTagByte) {
                json.add(name, (JsonElement)new JsonPrimitive(Boolean.valueOf(((NBTTagByte)nbt).func_150290_f() == 1)));
                type = "boolean";
            } else if (nbt instanceof NBTTagInt) {
                json.add(name, (JsonElement)new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d()));
                type = "integer";
            } else if (nbt instanceof NBTTagFloat) {
                json.add(name, (JsonElement)new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)nbt).func_150288_h())));
                type = "float";
            }
        } else {
            JsonArray array = new JsonArray();
            for (NBTBase nbt : nbtArray) {
                if (nbt instanceof NBTTagString) {
                    array.add((JsonElement)new JsonPrimitive(((NBTTagString)nbt).func_150285_a_()));
                    type = "string";
                    continue;
                }
                if (nbt instanceof NBTTagByte) {
                    array.add((JsonElement)new JsonPrimitive(Boolean.valueOf(((NBTTagByte)nbt).func_150290_f() == 1)));
                    type = "boolean";
                    continue;
                }
                if (nbt instanceof NBTTagInt) {
                    array.add((JsonElement)new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d()));
                    type = "integer";
                    continue;
                }
                if (!(nbt instanceof NBTTagFloat)) continue;
                array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)nbt).func_150288_h())));
                type = "float";
            }
            json.add(name, (JsonElement)array);
        }
        json.add("type", (JsonElement)new JsonPrimitive(type));
    }

    public static void serializeExtendedEntityTarget(JsonObject json, String name, LootContextExtended.ExtendedEntityTarget target) {
        json.addProperty(name, target.name());
    }

    public static LootContextExtended.ExtendedEntityTarget deserializeExtendedEntityTarget(JsonObject json, String name) {
        return LootHelper.deserializeExtendedEntityTarget(json, name, null);
    }

    public static LootContextExtended.ExtendedEntityTarget deserializeExtendedEntityTarget(JsonObject json, String name, LootContextExtended.ExtendedEntityTarget fallback) {
        if (JsonUtils.func_151205_a((JsonObject)json, (String)name)) {
            String targetName = JsonUtils.func_151200_h((JsonObject)json, (String)name);
            return LootContextExtended.ExtendedEntityTarget.valueOf(targetName.toUpperCase());
        }
        if (fallback == null) {
            throw new JsonSyntaxException("Expected entity target for " + name);
        }
        return fallback;
    }

    public static LootContextExtended.ExtendedEntityTarget deserializeExtendedEntityTargetOrNull(JsonObject json, String name) {
        try {
            return LootHelper.deserializeExtendedEntityTarget(json, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static class RangeFloat {
        public Float min;
        public Float max;

        public RangeFloat(Float minToSet, Float maxToSet) {
            this.min = minToSet;
            this.max = maxToSet;
        }

        public boolean isInRange(Float toTest) {
            if (this.min != null && toTest.floatValue() < this.min.floatValue()) {
                return false;
            }
            return this.max == null || !(toTest.floatValue() > this.max.floatValue());
        }

        public void serialize(JsonObject json, String name) {
            if (this.min != null || this.max != null) {
                JsonObject innerJson = new JsonObject();
                if (this.min != null) {
                    innerJson.addProperty("min", (Number)this.min);
                }
                if (this.max != null) {
                    innerJson.addProperty("max", (Number)this.max);
                }
                json.add(name, (JsonElement)innerJson);
            }
        }

        public String toString() {
            return "{ min: " + this.min + ", max: " + this.max + " }";
        }
    }
}

