/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;

public class LootContextExtended
extends LootContext {
    private BlockPos pos;
    private DamageSource damageSource;
    private Entity looter;
    private EntityPlayer looterPlayer;
    private TileEntity lootedTileEntity;
    private TileEntity brokenTileEntity;
    private IBlockState brokenState;
    private int fortune;
    private boolean silkTouch;

    public LootContextExtended(LootContext previous, DamageSource sourceIn, BlockPos posIn, Entity looterIn, TileEntity lootedTileEntityIn, TileEntity brokenTileEntityIn, IBlockState brokenStateIn, Integer fortuneIn, Boolean silkTouchIn) {
        super(previous.func_186491_f(), previous.getWorld(), previous.func_186497_e(), previous.func_186493_a(), previous.func_186495_b() instanceof EntityPlayer ? (EntityPlayer)previous.func_186495_b() : null, sourceIn);
        this.damageSource = sourceIn;
        Entity entity = looterIn != null ? looterIn : (this.looter = previous.func_186492_c() != null ? previous.func_186492_c() : previous.func_186495_b());
        this.looterPlayer = this.looter instanceof EntityPlayer ? (EntityPlayer)this.looter : (previous.func_186495_b() instanceof EntityPlayer ? (EntityPlayer)previous.func_186495_b() : null);
        this.lootedTileEntity = lootedTileEntityIn;
        this.brokenTileEntity = brokenTileEntityIn;
        this.brokenState = brokenStateIn;
        int n = fortuneIn != null ? fortuneIn : (this.fortune = this.looter != null && this.looter instanceof EntityLivingBase ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((EntityLivingBase)this.looter).func_184614_ca()) : 0);
        boolean bl = silkTouchIn != null ? silkTouchIn : (this.looter != null && this.looter instanceof EntityLivingBase ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)((EntityLivingBase)this.looter).func_184614_ca()) > 0 : (this.silkTouch = false));
        this.pos = posIn != null ? posIn : (this.looter != null ? this.looter.func_180425_c() : (this.lootedTileEntity != null ? this.lootedTileEntity.func_174877_v() : (this.brokenTileEntity != null ? this.brokenTileEntity.func_174877_v() : null)));
    }

    @Nullable
    public BlockPos getPosition() {
        if (this.pos != null) {
            return this.pos;
        }
        if (this.func_186493_a() != null) {
            return this.func_186493_a().func_180425_c();
        }
        if (this.lootedTileEntity != null) {
            return this.lootedTileEntity.func_174877_v();
        }
        if (this.brokenTileEntity != null) {
            return this.brokenTileEntity.func_174877_v();
        }
        return null;
    }

    @Nullable
    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    @Nullable
    public Entity getLooter() {
        return this.looter;
    }

    @Nullable
    public EntityPlayer getLooterPlayer() {
        return this.looterPlayer;
    }

    @Nullable
    public TileEntity getLootedTileEntity() {
        return this.lootedTileEntity;
    }

    @Nullable
    public TileEntity getBrokenTileEntity() {
        return this.brokenTileEntity;
    }

    @Nullable
    public IBlockState getBrokenBlockState() {
        return this.brokenState;
    }

    public int getFortuneModifier() {
        return this.fortune;
    }

    public boolean isSilkTouch() {
        return this.silkTouch;
    }

    @Nullable
    public Entity getEntityExtended(ExtendedEntityTarget target) {
        switch (target) {
            case THIS: {
                return this.func_186493_a();
            }
            case KILLER: {
                return this.func_186492_c();
            }
            case KILLER_PLAYER: {
                return this.func_186495_b();
            }
            case LOOTER: {
                return this.getLooter();
            }
        }
        return null;
    }

    public static enum ExtendedEntityTarget {
        THIS(LootContext.EntityTarget.THIS),
        KILLER(LootContext.EntityTarget.KILLER),
        KILLER_PLAYER(LootContext.EntityTarget.KILLER_PLAYER),
        LOOTER(LootContext.EntityTarget.KILLER, LootContext.EntityTarget.KILLER_PLAYER);

        private final LootContext.EntityTarget[] oldTargetTypes;

        private ExtendedEntityTarget(LootContext.EntityTarget ... oldTargetTypes) {
            this.oldTargetTypes = oldTargetTypes;
        }

        public LootContext.EntityTarget[] getEntityTargets() {
            return this.oldTargetTypes;
        }
    }
}

