/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.items;

import com.tmtravlr.lootoverhaul.LootOverhaul;
import com.tmtravlr.lootoverhaul.items.ItemLoot;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class ItemLootStructure
extends ItemLoot {
    public static final Item INSTANCE = (Item)new ItemLootStructure().func_77655_b("loot_structure").setRegistryName("loot_structure");

    @Override
    protected void generateSpecificLoot(ItemStack stack, World world, Vec3d position) {
        if (world instanceof WorldServer) {
            if (!stack.func_77942_o()) {
                return;
            }
            String name = stack.func_77978_p().func_74779_i("Name");
            String mirrorType = stack.func_77978_p().func_74779_i("Mirror");
            int rotationType = stack.func_77978_p().func_74762_e("Rotation");
            boolean ignoreEntities = stack.func_77978_p().func_74767_n("IgnoreEntities");
            float integrity = stack.func_77978_p().func_74764_b("Integrity") ? stack.func_77978_p().func_74760_g("Integrity") : 1.0f;
            long seed = stack.func_77978_p().func_74764_b("Seed") ? stack.func_77978_p().func_74763_f("Seed") : 0L;
            Mirror mirror = Mirror.NONE;
            if (mirrorType != null && !mirrorType.isEmpty()) {
                if (mirrorType.equals("left-right")) {
                    mirror = Mirror.LEFT_RIGHT;
                } else if (mirrorType.equals("front-back")) {
                    mirror = Mirror.FRONT_BACK;
                } else if (!mirrorType.equals("none")) {
                    LootOverhaul.logger.warn("Loot Structure: Mirror type '" + mirrorType + "' not recognized. Valid options are 'none', 'left-right', and 'front-back'.");
                }
            }
            Rotation rotation = Rotation.NONE;
            if (rotationType == 90) {
                rotation = Rotation.CLOCKWISE_90;
            } else if (rotationType == 180) {
                rotation = Rotation.CLOCKWISE_180;
            } else if (rotationType == 270) {
                rotation = Rotation.COUNTERCLOCKWISE_90;
            } else if (rotationType != 0) {
                LootOverhaul.logger.warn("Loot Structure: Rotation " + rotationType + " not accetped. Valid options (in degrees clockwise) are 0, 90, 180, and 270.");
            }
            BlockPos startPos = new BlockPos(position);
            WorldServer worldserver = (WorldServer)world;
            MinecraftServer minecraftserver = world.func_73046_m();
            TemplateManager templatemanager = worldserver.func_184163_y();
            Template template = templatemanager.func_189942_b(minecraftserver, new ResourceLocation(name));
            if (template != null) {
                PlacementSettings placementsettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186222_a(ignoreEntities).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);
                if (integrity < 1.0f) {
                    placementsettings.func_189946_a(MathHelper.func_76131_a((float)integrity, (float)0.0f, (float)1.0f)).func_189949_a(Long.valueOf(seed));
                }
                template.func_186260_a((World)worldserver, startPos, placementsettings);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String structureName;
        String name = super.func_77653_i(stack);
        String string = structureName = stack.func_77942_o() && stack.func_77978_p().func_150297_b("Name", 8) ? stack.func_77978_p().func_74779_i("Name").split(" ")[0] : null;
        if (structureName != null) {
            name = name + " " + structureName;
        }
        return name;
    }
}

