/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.items;

import com.tmtravlr.lootoverhaul.items.ItemLoot;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemLootFill
extends ItemLoot {
    private static final Random RAND = new Random();
    public static final Item INSTANCE = (Item)new ItemLootFill().func_77655_b("loot_fill").setRegistryName("loot_fill");

    @Override
    protected void generateSpecificLoot(ItemStack stack, World world, Vec3d position) {
        if (!(stack.func_77942_o() && stack.func_77978_p().func_150297_b("Size", 10) && stack.func_77978_p().func_150297_b("Blocks", 9))) {
            return;
        }
        int sizeX = stack.func_77978_p().func_74775_l("Size").func_74762_e("X");
        int sizeY = stack.func_77978_p().func_74775_l("Size").func_74762_e("Y");
        int sizeZ = stack.func_77978_p().func_74775_l("Size").func_74762_e("Z");
        String axis = stack.func_77978_p().func_74764_b("Axis") ? stack.func_77978_p().func_74779_i("Axis") : "Y";
        FillShape fillShape = FillShape.getFillShapeOrDefault(stack.func_77978_p().func_74779_i("Shape"));
        NBTTagList blockWeightTags = stack.func_77978_p().func_150295_c("Blocks", 10);
        ArrayList<WeightedBlockInfo> weightedBlocks = new ArrayList<WeightedBlockInfo>();
        int weightTotal = 0;
        for (NBTBase nbtBase : blockWeightTags) {
            NBTTagCompound blockWeightTag = (NBTTagCompound)nbtBase;
            int weight = blockWeightTag.func_74762_e("Weight");
            if (weight <= 0) {
                weight = 1;
            }
            weightTotal += weight;
            weightedBlocks.add(new WeightedBlockInfo(weight, blockWeightTag));
        }
        if (weightTotal == 0 || weightedBlocks.isEmpty()) {
            return;
        }
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        int startX = MathHelper.func_76128_c((double)position.field_72450_a);
        int startY = MathHelper.func_76128_c((double)position.field_72448_b);
        int startZ = MathHelper.func_76128_c((double)position.field_72449_c);
        double radiusX = (double)sizeX / 2.0;
        double radiusY = (double)sizeY / 2.0;
        double radiusZ = (double)sizeZ / 2.0;
        for (int x = startX; x < startX + sizeX; ++x) {
            for (int y = startY; y < startY + sizeY; ++y) {
                for (int z = startZ; z < startZ + sizeZ; ++z) {
                    TileEntity tileentity;
                    double offsetX = radiusX - (double)x + (double)startX - 0.5;
                    double offsetY = radiusY - (double)y + (double)startY - 0.5;
                    double offsetZ = radiusZ - (double)z + (double)startZ - 0.5;
                    if (fillShape == FillShape.HOLLOW) {
                        if (x != startX && x != startX + sizeX - 1 && y != startY && y != startY + sizeY - 1 && z != startZ && z != startZ + sizeZ - 1) {
                            continue;
                        }
                    } else if (fillShape == FillShape.SPHERE) {
                        if (offsetX * offsetX / (radiusX * radiusX) + offsetY * offsetY / (radiusY * radiusY) + offsetZ * offsetZ / (radiusZ * radiusZ) > 1.0) {
                            continue;
                        }
                    } else if (fillShape == FillShape.CYLINDER && ("X".equalsIgnoreCase(axis) && offsetY * offsetY / (radiusY * radiusY) + offsetZ * offsetZ / (radiusZ * radiusZ) > 1.0 || "Y".equalsIgnoreCase(axis) && offsetX * offsetX / (radiusX * radiusX) + offsetZ * offsetZ / (radiusZ * radiusZ) > 1.0 || "Z".equalsIgnoreCase(axis) && offsetX * offsetX / (radiusX * radiusX) + offsetY * offsetY / (radiusY * radiusY) > 1.0)) continue;
                    pos.func_181079_c(x, y, z);
                    if (world.func_189509_E((BlockPos)pos) || stack.func_77978_p().func_74767_n("Keep") && !world.func_180495_p((BlockPos)pos).func_185904_a().func_76222_j()) continue;
                    int currentWeight = RAND.nextInt(weightTotal);
                    NBTTagCompound blockTag = null;
                    for (WeightedBlockInfo weightedBlock : weightedBlocks) {
                        if (currentWeight <= 0) {
                            blockTag = weightedBlock.blockTag;
                            break;
                        }
                        currentWeight -= weightedBlock.weight;
                    }
                    if (blockTag == null) continue;
                    ResourceLocation blockLocation = new ResourceLocation(blockTag.func_74779_i("Block"));
                    boolean noUpdate = blockTag.func_74767_n("NoUpdate");
                    NBTTagCompound tileTag = blockTag.func_150297_b("BlockEntityTag", 10) ? blockTag.func_74775_l("BlockEntityTag") : null;
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)blockLocation);
                    IBlockState state = block.func_176223_P();
                    if (blockTag.func_74764_b("Meta")) {
                        state = block.func_176203_a(blockTag.func_74762_e("Meta"));
                    } else if (blockTag.func_74764_b("State")) {
                        state = LootHelper.getStateFromNBT(block, blockTag.func_74775_l("State"));
                    }
                    if (block == null || block == Blocks.field_150350_a && !blockLocation.toString().equals("minecraft:air") || !world.func_180501_a((BlockPos)pos, state, 2)) continue;
                    if (tileTag != null && (tileentity = world.func_175625_s((BlockPos)pos)) != null) {
                        tileTag.func_74768_a("x", pos.func_177958_n());
                        tileTag.func_74768_a("y", pos.func_177956_o());
                        tileTag.func_74768_a("z", pos.func_177952_p());
                        tileentity.func_145839_a(tileTag);
                    }
                    if (noUpdate) continue;
                    world.func_175722_b((BlockPos)pos, block, false);
                }
            }
        }
        pos.func_185344_t();
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack) + " - " + (stack.func_77942_o() && stack.func_77978_p().func_150297_b("Shape", 8) ? stack.func_77978_p().func_74779_i("Shape") : "Cube");
    }

    public static enum FillShape {
        CUBE,
        HOLLOW,
        SPHERE,
        CYLINDER;


        public static FillShape getFillShapeOrDefault(String name) {
            for (FillShape shape : FillShape.values()) {
                if (!name.toUpperCase().equals(shape.toString().toUpperCase())) continue;
                return shape;
            }
            return CUBE;
        }
    }

    private class WeightedBlockInfo {
        public int weight;
        public NBTTagCompound blockTag;

        public WeightedBlockInfo(int weight, NBTTagCompound blockTag) {
            this.weight = weight;
            this.blockTag = blockTag;
        }
    }
}

