/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.items;

import com.tmtravlr.lootoverhaul.LootOverhaul;
import com.tmtravlr.lootoverhaul.items.ItemLootItem;
import com.tmtravlr.lootoverhaul.utilities.SavedData;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ItemLoot
extends Item {
    private static final Random RAND = new Random();

    public ItemLoot() {
        this.func_77625_d(1);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (!entityItem.field_70170_p.field_72995_K && entityItem.field_70173_aa > 5) {
            if (entityItem == null || entityItem.func_92059_d().func_190926_b() || !entityItem.func_92059_d().func_77942_o()) {
                entityItem.func_70106_y();
                return true;
            }
            this.generateLoot(entityItem.func_92059_d(), entityItem.field_70170_p, entityItem.func_174791_d());
            entityItem.func_70106_y();
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            this.generateLoot(stack, world, entity.func_174791_d());
        }
    }

    public void generateLoot(ItemStack stack, World world, Vec3d position) {
        NBTTagCompound positionTag;
        if (!stack.func_77942_o() || stack.func_190926_b()) {
            return;
        }
        if (stack.func_77978_p().func_74764_b("Delay")) {
            int delay = stack.func_77978_p().func_74762_e("Delay");
            stack.func_77978_p().func_82580_o("Delay");
            if (delay > 0) {
                NBTTagCompound positionTag2 = stack.func_77978_p().func_74775_l("Position");
                if (!positionTag2.func_74764_b("X")) {
                    positionTag2.func_74780_a("X", position.field_72450_a);
                }
                if (!positionTag2.func_74764_b("Y")) {
                    positionTag2.func_74780_a("Y", position.field_72448_b);
                }
                if (!positionTag2.func_74764_b("Z")) {
                    positionTag2.func_74780_a("Z", position.field_72449_c);
                }
                stack.func_77978_p().func_74782_a("Position", (NBTBase)positionTag2);
                SavedData savedData = SavedData.getSavedData(world);
                savedData.setLootDelay(stack, delay);
            }
            return;
        }
        if (stack.func_77978_p().func_150297_b("Position", 10)) {
            positionTag = stack.func_77978_p().func_74775_l("Position");
            if (positionTag.func_74764_b("Entity")) {
                String entityString = positionTag.func_74779_i("Entity");
                Entity entity = null;
                try {
                    entity = CommandBase.func_184885_b((MinecraftServer)world.func_73046_m(), (ICommandSender)world.func_73046_m(), (String)entityString);
                }
                catch (Exception e) {
                    LootOverhaul.logger.catching((Throwable)e);
                }
                if (entity != null) {
                    position = entity.func_174791_d();
                }
            } else {
                double posX = position.field_72450_a;
                double posY = position.field_72448_b;
                double posZ = position.field_72449_c;
                if (positionTag.func_74764_b("X")) {
                    posX = positionTag.func_74769_h("X");
                }
                if (positionTag.func_74764_b("Y")) {
                    posY = positionTag.func_74769_h("Y");
                }
                if (positionTag.func_74764_b("Z")) {
                    posZ = positionTag.func_74769_h("Z");
                }
                position = new Vec3d(posX, posY, posZ);
            }
        }
        if (stack.func_77978_p().func_150297_b("Offset", 10)) {
            float offsetRadius;
            positionTag = stack.func_77978_p().func_74775_l("Offset");
            if (positionTag.func_74764_b("X") || positionTag.func_74764_b("Y") || positionTag.func_74764_b("Z")) {
                float offsetX = positionTag.func_74760_g("X");
                float offsetY = positionTag.func_74760_g("Y");
                float offsetZ = positionTag.func_74760_g("Z");
                position = position.func_72441_c((double)offsetX, (double)offsetY, (double)offsetZ);
            }
            if (positionTag.func_74764_b("Radius") && (offsetRadius = Math.abs(positionTag.func_74760_g("Radius"))) > 0.0f) {
                double angle = RAND.nextDouble() * Math.PI * 2.0;
                double offsetX = Math.cos(angle) * (double)offsetRadius;
                double offsetZ = Math.sin(angle) * (double)offsetRadius;
                position = position.func_72441_c(offsetX, 0.0, offsetZ);
            }
            if (positionTag.func_74764_b("SurfaceSearch")) {
                int maxSearch = positionTag.func_74762_e("SurfaceSearch");
                BlockPos startPos = new BlockPos(position);
                if (!world.func_180495_p(startPos.func_177977_b()).isSideSolid((IBlockAccess)world, startPos.func_177977_b(), EnumFacing.UP) || !world.func_180495_p(startPos).func_185904_a().func_76222_j()) {
                    boolean foundPos = false;
                    block2: for (int ySearch = 0; ySearch < maxSearch && !foundPos; ++ySearch) {
                        for (int yDirection : new int[]{1, -1}) {
                            BlockPos searchPos = startPos.func_177982_a(0, ySearch * yDirection, 0);
                            IBlockState state = world.func_180495_p(searchPos);
                            if (!world.func_180495_p(searchPos.func_177977_b()).isSideSolid((IBlockAccess)world, searchPos.func_177977_b(), EnumFacing.UP) || !state.func_185904_a().func_76222_j() && state.func_185890_d((IBlockAccess)world, searchPos) != null) continue;
                            position.func_72441_c(0.0, (double)(ySearch * yDirection), 0.0);
                            foundPos = true;
                            continue block2;
                        }
                    }
                }
            }
        }
        this.generateSpecificLoot(stack, world, position);
        stack.func_190920_e(0);
    }

    protected abstract void generateSpecificLoot(ItemStack var1, World var2, Vec3d var3);

    public static ItemStack createStackFromItem(ItemStack original) {
        NBTTagCompound originalTag = original.func_77955_b(new NBTTagCompound());
        ItemStack newLootStack = new ItemStack(ItemLootItem.INSTANCE);
        newLootStack.func_77982_d(new NBTTagCompound());
        newLootStack.func_77978_p().func_74782_a("Item", (NBTBase)originalTag);
        return newLootStack;
    }
}

