/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.commands;

import com.tmtravlr.lootoverhaul.LootOverhaul;
import com.tmtravlr.lootoverhaul.utilities.SavedData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandEntityVar
extends CommandBase {
    private static final Random RANDOM = new Random();

    public String func_71517_b() {
        return "entityvar";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands." + this.func_71517_b() + ".usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        List entities = CommandEntityVar.func_184890_c((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        if (entities.isEmpty()) {
            throw new CommandException("commands.generic.entity.notFound", new Object[]{args[0]});
        }
        String varName = args[1];
        if (args.length == 2) {
            boolean foundEntity = false;
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                if (var == null) continue;
                CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(entity.func_70005_c_() + ": " + var.toString()), (Object[])new Object[0]);
                foundEntity = true;
            }
            if (foundEntity) {
                return;
            }
            throw new CommandException("commands.entityvar.failure", new Object[]{varName, args[0]});
        }
        if (args[2].equalsIgnoreCase("invert")) {
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                var.invert();
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.entityvar.success.invert", (Object[])new Object[]{varName});
        } else if (args[2].equalsIgnoreCase("set")) {
            for (Entity entity : entities) {
                if (args.length < 4) {
                    throw new WrongUsageException("commands.entityvar.operation.usage", new Object[]{"set"});
                }
                SavedData.StoredVar newVar = this.getOtherVar(server, sender, "set", Arrays.copyOfRange(args, 3, args.length));
                SavedData.setEntityVar(entity, varName, newVar);
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.entityvar.success.set" + (entities.size() == 1 ? ".singular" : "")), (Object[])new Object[]{varName, entities.size()});
        } else if (args[2].equalsIgnoreCase("add")) {
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                String operation = "add";
                if (args.length < 4) {
                    throw new WrongUsageException("commands.entityvar.operation.usage", new Object[]{operation});
                }
                SavedData.StoredVar other = this.getOtherVar(server, sender, operation, Arrays.copyOfRange(args, 3, args.length));
                if (var.add(other)) continue;
                throw new CommandException("commands.entityvar.failure.operation", new Object[]{operation, var.getType(), other.getType(), entity.func_70005_c_()});
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.entityvar.success.add" + (entities.size() == 1 ? ".singular" : "")), (Object[])new Object[]{varName, entities.size()});
        } else if (args[2].equalsIgnoreCase("multiply")) {
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                String operation = "multiply";
                if (args.length < 4) {
                    throw new WrongUsageException("commands.entityvar.operation.usage", new Object[]{operation});
                }
                SavedData.StoredVar other = this.getOtherVar(server, sender, operation, Arrays.copyOfRange(args, 3, args.length));
                if (var.multiply(other)) continue;
                throw new CommandException("commands.entityvar.failure.operation", new Object[]{operation, var.getType(), other.getType(), entity.func_70005_c_()});
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.entityvar.success.multiply" + (entities.size() == 1 ? ".singular" : "")), (Object[])new Object[]{varName, entities.size()});
        } else if (args[2].equalsIgnoreCase("divide")) {
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                String operation = "divide";
                if (args.length < 4) {
                    throw new WrongUsageException("commands.entityvar.operation.usage", new Object[]{operation});
                }
                SavedData.StoredVar other = this.getOtherVar(server, sender, operation, Arrays.copyOfRange(args, 3, args.length));
                if (var.divide(other)) continue;
                throw new CommandException("commands.entityvar.failure.operation", new Object[]{operation, var.getType(), other.getType(), entity.func_70005_c_()});
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.entityvar.success.divide" + (entities.size() == 1 ? ".singular" : "")), (Object[])new Object[]{varName, entities.size()});
        } else if (args[2].equalsIgnoreCase("mod")) {
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                String operation = "mod";
                if (args.length < 4) {
                    throw new WrongUsageException("commands.entityvar.operation.usage", new Object[]{operation});
                }
                SavedData.StoredVar other = this.getOtherVar(server, sender, operation, Arrays.copyOfRange(args, 3, args.length));
                if (var.mod(other)) continue;
                throw new CommandException("commands.entityvar.failure.operation", new Object[]{operation, var.getType(), other.getType(), entity.func_70005_c_()});
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.entityvar.success.mod" + (entities.size() == 1 ? ".singular" : "")), (Object[])new Object[]{varName, entities.size()});
        } else if (args[2].equalsIgnoreCase("test")) {
            for (Entity entity : entities) {
                SavedData.StoredVar var = SavedData.getEntityVar(entity, varName);
                String operation = "test <operation>";
                if (args.length < 5) {
                    throw new WrongUsageException("commands.entityvar.operation.usage", new Object[]{operation});
                }
                SavedData.StoredVar other = this.getOtherVar(server, sender, operation, Arrays.copyOfRange(args, 4, args.length));
                if (var.test(args[3], other)) continue;
                throw new CommandException("commands.entityvar.failure.test", new Object[]{var, args[3], other, entity.func_70005_c_()});
            }
            CommandEntityVar.func_152373_a((ICommandSender)sender, (ICommand)this, (String)("commands.entityvar.success.test" + (entities.size() == 1 ? ".singular" : "")), (Object[])new Object[]{args[3], entities.size()});
        }
    }

    public SavedData.StoredVar getOtherVar(MinecraftServer server, ICommandSender sender, String operation, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equalsIgnoreCase("value")) {
            if (args.length < 3) {
                throw new WrongUsageException("commands.entityvar.operation.value.usage", new Object[]{operation});
            }
            String type = args[1];
            if (type.equalsIgnoreCase("string")) {
                return new SavedData.StoredVarString(CommandEntityVar.func_180529_a((String[])args, (int)2));
            }
            if (type.equalsIgnoreCase("boolean")) {
                return new SavedData.StoredVarBoolean(args[2].equals("true"));
            }
            if (type.equalsIgnoreCase("integer")) {
                return new SavedData.StoredVarInt(CommandEntityVar.func_175755_a((String)args[2]));
            }
            if (type.equalsIgnoreCase("float")) {
                return new SavedData.StoredVarFloat((float)CommandEntityVar.func_175765_c((String)args[2]));
            }
        } else if (args[0].equalsIgnoreCase("random")) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.entityvar.operation.random.usage", new Object[]{operation});
            }
            String type = args[1];
            if (type.equalsIgnoreCase("string")) {
                return new SavedData.StoredVarString(args.length > 2 ? args[RANDOM.nextInt(args.length - 2) + 2] : "");
            }
            if (type.equalsIgnoreCase("boolean")) {
                return new SavedData.StoredVarBoolean(RANDOM.nextBoolean());
            }
            if (type.equalsIgnoreCase("integer")) {
                int min = Integer.MIN_VALUE;
                int max = 0x7FFFFFFE;
                if (args.length > 2) {
                    min = CommandEntityVar.func_175755_a((String)args[2]);
                }
                if (args.length > 3) {
                    max = CommandEntityVar.func_175755_a((String)args[3]);
                }
                if (max < min) {
                    max = min;
                }
                return new SavedData.StoredVarInt(RANDOM.nextInt(max - min + 1) + min);
            }
            if (type.equalsIgnoreCase("float")) {
                float min = 1000000.0f;
                float max = 1000000.0f;
                if (args.length > 2) {
                    min = (float)CommandEntityVar.func_175765_c((String)args[2]);
                }
                if (args.length > 3) {
                    max = (float)CommandEntityVar.func_175765_c((String)args[3]);
                }
                if (max < min) {
                    max = min;
                }
                return new SavedData.StoredVarFloat(RANDOM.nextFloat() * (max - min) + min);
            }
        } else {
            if (args[0].equalsIgnoreCase("globalvar")) {
                if (args.length < 2) {
                    throw new WrongUsageException("commands.entityvar.operation.globalvar.usage", new Object[]{operation});
                }
                SavedData.StoredVar var = SavedData.getSavedData(server.func_130014_f_()).getGlobalVar(args[1]);
                if (var == null) {
                    throw new WrongUsageException("commands.entityvar.failure.globalvar", new Object[]{args[1]});
                }
                return var;
            }
            if (args[0].equalsIgnoreCase("entityvar")) {
                if (args.length < 3) {
                    throw new WrongUsageException("commands.entityvar.operation.entityvar.usage", new Object[]{operation});
                }
                Entity entity = CommandEntityVar.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                SavedData.StoredVar var = SavedData.getEntityVar(entity, args[2]);
                if (var == null) {
                    throw new WrongUsageException("commands.entityvar.failure.entityvar", new Object[]{args[2], entity.func_70005_c_()});
                }
                return var;
            }
            if (args[0].equalsIgnoreCase("scoreboard")) {
                if (args.length < 3) {
                    throw new WrongUsageException("commands.entityvar.operation.scoreboard.usage", new Object[]{operation});
                }
                String entityName = CommandEntityVar.func_184891_e((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                Scoreboard scoreboard = server.func_71218_a(0).func_96441_U();
                ScoreObjective scoreobjective = scoreboard.func_96518_b(args[2]);
                if (scoreobjective == null) {
                    throw new CommandException("commands.scoreboard.objectiveNotFound", new Object[]{args[2]});
                }
                if (scoreboard.func_178819_b(entityName, scoreobjective)) {
                    return new SavedData.StoredVarInt(scoreboard.func_96529_a(entityName, scoreobjective).func_96652_c());
                }
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandEntityVar.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandEntityVar.func_71530_a((String[])args, (String[])this.getEntityVarNames(server, sender, args));
        }
        if (args.length == 3) {
            return CommandEntityVar.func_71530_a((String[])args, (String[])new String[]{"set", "invert", "add", "multiply", "divide", "mod", "test"});
        }
        if (args.length == 4 && args[2].equalsIgnoreCase("test")) {
            return CommandEntityVar.func_71530_a((String[])args, (String[])new String[]{"=", "!=", "<", ">", "<=", ">="});
        }
        if (args.length == 4 || args.length == 5 && args[2].equalsIgnoreCase("test")) {
            return CommandEntityVar.func_71530_a((String[])args, (String[])new String[]{"value", "random", "globalvar", "entityvar", "scoreboard"});
        }
        if (args.length >= 5) {
            if (args[args.length - 2].equalsIgnoreCase("value") || args[args.length - 2].equalsIgnoreCase("random")) {
                return CommandEntityVar.func_71530_a((String[])args, (String[])new String[]{"string", "boolean", "integer", "float"});
            }
            if (args[args.length - 2].equalsIgnoreCase("globalvar")) {
                return CommandEntityVar.func_71530_a((String[])args, (String[])SavedData.getSavedData(server.func_130014_f_()).getGlobalVarNames());
            }
            if (args[args.length - 2].equalsIgnoreCase("entityvar")) {
                return CommandEntityVar.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            if (args[args.length - 3].equalsIgnoreCase("entityvar")) {
                return CommandEntityVar.func_71530_a((String[])args, (String[])this.getEntityVarNames(server, sender, args));
            }
            if (args[args.length - 2].equalsIgnoreCase("scoreboard")) {
                return CommandEntityVar.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            if (args[args.length - 3].equalsIgnoreCase("scoreboard")) {
                Collection scoreboardList = server.func_71218_a(0).func_96441_U().func_96514_c();
                String[] objectiveNames = new String[scoreboardList.size()];
                int i = 0;
                for (ScoreObjective objective : scoreboardList) {
                    objectiveNames[i] = objective.func_96679_b();
                    ++i;
                }
                return CommandEntityVar.func_71530_a((String[])args, (String[])objectiveNames);
            }
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        if (index == 0) {
            return true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("entityvar") && !args[i].equals("scoreboard")) continue;
            return index == i + 1;
        }
        return false;
    }

    private String[] getEntityVarNames(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length >= 2) {
            String entityArg = args[args.length - 2];
            try {
                Entity entity = CommandEntityVar.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)entityArg);
                return SavedData.getEntityVarNames(entity);
            }
            catch (CommandException e) {
                LootOverhaul.logger.catching((Throwable)e);
            }
        }
        return new String[0];
    }
}

