/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.steelworks.tank;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.steelworks.IHighOvenFilter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;

public class HighOvenTank
extends SmelteryTank {
    private FluidStack filter;
    private IHighOvenFilter cache;
    private static final String TAG_FILTER = "filter";

    public HighOvenTank(ISmelteryTankHandler parent) {
        super(parent);
    }

    public void setFilter(@Nullable FluidStack filter) {
        if (filter != null) {
            filter = filter.copy();
        }
        this.filter = filter;
        this.cache = null;
    }

    public FluidStack getFilterFluid() {
        if (this.filter == null) {
            return null;
        }
        for (FluidStack liquid : this.liquids) {
            if (!this.filter.isFluidEqual(liquid)) continue;
            return liquid;
        }
        return null;
    }

    public FilterMatchType matchesFilter(FluidStack resource, boolean update) {
        if (this.liquids.isEmpty()) {
            this.filter = null;
        }
        if (this.filter == null) {
            if (update) {
                this.setFilter(resource);
            }
            return FilterMatchType.INPUT;
        }
        if (this.filter.isFluidEqual(resource)) {
            return FilterMatchType.INPUT;
        }
        if (this.cache != null && this.cache.matches(this.filter, resource)) {
            return FilterMatchType.OUTPUT;
        }
        IHighOvenFilter recipe = TCompRegistry.getFilter(this.filter, resource);
        if (recipe != null) {
            this.cache = recipe;
            return FilterMatchType.OUTPUT;
        }
        return FilterMatchType.NONE;
    }

    public int fillInternal(@Nonnull FluidStack resource, boolean doFill) {
        return super.fill(resource, doFill);
    }

    public void moveFluidToBottom(FluidStack fluid) {
        int i;
        for (i = 0; i < this.liquids.size() && !fluid.isFluidEqual((FluidStack)this.liquids.get(i)); ++i) {
        }
        if (i != 0 && i < this.liquids.size()) {
            this.moveFluidToBottom(i);
        }
    }

    public FluidStack drainInternal(@Nonnull FluidStack resource, boolean doDrain) {
        return super.drain(resource, doDrain);
    }

    public int fill(@Nonnull FluidStack resource, boolean doFill) {
        if (this.matchesFilter(resource, doFill) == FilterMatchType.NONE) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = this.drainInternal(resource, doDrain);
        if (doDrain && drained != null && this.liquids.isEmpty()) {
            this.setFilter(null);
        }
        return drained;
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.filter != null) {
            NBTTagCompound filterTag = new NBTTagCompound();
            this.filter.writeToNBT(filterTag);
            tag.func_74782_a(TAG_FILTER, (NBTBase)filterTag);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_150297_b(TAG_FILTER, 10)) {
            NBTTagCompound filterTag = tag.func_74775_l(TAG_FILTER);
            this.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)filterTag);
        }
    }

    public static enum FilterMatchType {
        NONE,
        INPUT,
        OUTPUT;

    }
}

