/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.jei.highoven.mix;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import knightminer.tcomplement.library.steelworks.MixRecipe;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class HighOvenMixWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private MixRecipe recipe;
    private List<List<ItemStack>> inputStacks;
    private FluidStack inputFluid;
    private FluidStack outputFluid;
    private int temp;

    public HighOvenMixWrapper(MixRecipe recipe, List<ItemStack> meltingInputs) {
        this.recipe = recipe;
        this.inputFluid = recipe.getInput();
        this.outputFluid = recipe.getOutput();
        this.temp = recipe.getTemperature();
        ImmutableList.Builder stacks = ImmutableList.builder();
        for (MixAdditive type : MixAdditive.values()) {
            stacks.add(recipe.getAdditives(type));
        }
        stacks.add(meltingInputs);
        this.inputStacks = stacks.build();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputStacks);
        ingredients.setInput(FluidStack.class, (Object)this.inputFluid);
        ingredients.setOutput(FluidStack.class, (Object)this.outputFluid);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String tmpStr = Util.celsiusString(this.temp);
        int x = 86 - minecraft.field_71466_p.func_78256_a(tmpStr) / 2;
        minecraft.field_71466_p.func_78276_b(tmpStr, x, 8, Util.getHighOvenTempColor(this.temp));
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        Integer chance;
        if (slotIndex == 3) {
            tooltip.add(Util.translateFormatted("gui.jei.high_oven.mix.represenative", this.inputFluid.getLocalizedName()));
            return;
        }
        if (slotIndex <= 2 && (chance = this.recipe.getAdditiveConsumeChance(MixAdditive.fromIndex(slotIndex), ingredient)) != null) {
            tooltip.add(String.format("%s%s%s", TextFormatting.GRAY, TextFormatting.ITALIC, Util.translateFormatted("gui.jei.high_oven.mix.consume", chance)));
        }
    }
}

