/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.biolib.common;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;

public class MaterialBuilder {
    private Material mat = null;
    private HeadMaterialStats headStats = null;
    private HandleMaterialStats handleStats = null;
    private ExtraMaterialStats extraStats = null;
    private BowMaterialStats bowStats = null;
    private FletchingMaterialStats fletchingStats = null;
    private MaterialIntegration integration = null;

    public MaterialBuilder(Material material) {
        this.mat = material;
    }

    public Material getMat() {
        return this.mat;
    }

    public MaterialBuilder setCraftable(boolean bool) {
        this.mat.setCraftable(bool);
        return this;
    }

    public MaterialBuilder setCastable(boolean bool) {
        this.mat.setCastable(bool);
        return this;
    }

    public void setHeadStats(int durability, float miningspeed, float attack, int harvestLevel) {
        this.headStats = new HeadMaterialStats(durability, miningspeed, attack, harvestLevel);
    }

    public HeadMaterialStats getHeadStats() {
        return this.headStats;
    }

    public void setHandleStats(float modifier, int durability) {
        this.handleStats = new HandleMaterialStats(modifier, durability);
    }

    public HandleMaterialStats getHandleStats() {
        return this.handleStats;
    }

    public void setExtraStats(int extradurability) {
        this.extraStats = new ExtraMaterialStats(extradurability);
    }

    public ExtraMaterialStats getExtraStats() {
        return this.extraStats;
    }

    public void setBowStats(float drawspeed, float range, float bonusDamage) {
        this.bowStats = new BowMaterialStats(drawspeed, range, bonusDamage);
    }

    public BowMaterialStats getBowStats() {
        return this.bowStats;
    }

    public void addFletchingStats(float accuracy, float modifier) {
        this.fletchingStats = new FletchingMaterialStats(accuracy, modifier);
    }

    public void setTrait(AbstractTrait trait) {
        this.mat.addTrait((ITrait)trait);
    }

    public void setTrait(AbstractTrait trait, String dependency) {
        this.mat.addTrait((ITrait)trait, dependency);
    }

    public void setFluid(Fluid fluid) {
        this.mat.setFluid(fluid);
    }

    public void addCommonItems(String ore) {
        this.mat.addCommonItems(ore);
    }

    public void addGem(String ore) {
        this.mat.addItem("gem" + ore, 1, 666);
    }

    public void addIngot(String ore) {
        this.mat.addItem(ore, 1, 144);
    }

    public void addItem(String ore, int mat) {
        this.mat.addItem(ore, 1, mat);
    }

    public void addIngot(Item item) {
        this.mat.addItem(item, 1, 144);
    }

    public void addIngot(ItemStack item) {
        this.mat.addItem(item, 1, 144);
    }

    public void addPlank(Block block) {
        this.mat.addItem(block, 144);
    }

    public void addBlock(String ore) {
        this.mat.addItem("block" + ore, 9, 1296);
    }

    public void addBlock(Block block) {
        this.mat.addItem(block, 9);
    }

    public void addGear(String ore) {
        this.mat.addItem("gear" + ore, 4, 576);
    }

    public void addPlate(String ore) {
        this.mat.addItem("plate" + ore, 1, 144);
    }

    public void setRepresentativeItem(String ore) {
        this.mat.setRepresentativeItem(ore);
    }

    public void setRepresentativeItem(ItemStack itemstack) {
        this.mat.setRepresentativeItem(itemstack);
    }

    public void setRepresentativeItem(Item item) {
        this.mat.setRepresentativeItem(item);
    }

    public void preInit(String ore) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.headStats, (IMaterialStats[])new IMaterialStats[]{this.handleStats, this.extraStats});
        if (this.bowStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.bowStats);
        }
        if (this.fletchingStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.fletchingStats);
        }
        if (this.integration == null) {
            TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore)).preInit();
        } else {
            TinkerRegistry.integrate((MaterialIntegration)this.integration).preInit();
        }
    }

    public void preInit(String ore, Fluid fluid) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.headStats, (IMaterialStats[])new IMaterialStats[]{this.handleStats, this.extraStats});
        if (this.bowStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.bowStats);
        }
        if (this.fletchingStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.fletchingStats);
        }
        if (this.integration == null) {
            TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore, fluid)).preInit();
        } else {
            TinkerRegistry.integrate((MaterialIntegration)this.integration).preInit();
        }
    }

    public void preInit(Fluid fluid) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.headStats, (IMaterialStats[])new IMaterialStats[]{this.handleStats, this.extraStats});
        if (this.bowStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.bowStats);
        }
        if (this.fletchingStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.fletchingStats);
        }
        if (this.integration == null) {
            TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(fluid)).preInit();
        } else {
            TinkerRegistry.integrate((MaterialIntegration)this.integration).preInit();
        }
    }

    public void preInit(String ore, String oreRequirement, Fluid fluid) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.headStats, (IMaterialStats[])new IMaterialStats[]{this.handleStats, this.extraStats});
        if (this.bowStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.bowStats);
        }
        if (this.fletchingStats != null) {
            TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.fletchingStats);
        }
        if (this.integration == null) {
            TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore, fluid, oreRequirement)).preInit();
        } else {
            TinkerRegistry.integrate((MaterialIntegration)this.integration).preInit();
        }
    }

    public void fletchingPreInit(String ore) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.fletchingStats);
        TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore)).preInit();
    }

    public void bowPreInit(String ore) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.bowStats);
        TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore)).preInit();
    }

    public void fletchingPreInit(String ore, Fluid fluid) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.fletchingStats);
        TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore, fluid)).preInit();
    }

    public void bowPreInit(String ore, Fluid fluid) {
        TinkerRegistry.addMaterialStats((Material)this.mat, (IMaterialStats)this.bowStats);
        TinkerRegistry.integrate((MaterialIntegration)this.addMaterialIntegration(ore, fluid)).preInit();
    }

    public void registerInitFluid(Fluid fluid, String ore) {
        this.addCommonItems(ore);
        this.mat.setCraftable(false).setCastable(true);
        this.mat.setFluid(fluid);
    }

    public static void registerTrait(ITrait trait) {
        TinkerRegistry.addTrait((ITrait)trait);
    }

    private MaterialIntegration addMaterialIntegration() {
        this.integration = new MaterialIntegration(this.mat);
        return this.integration;
    }

    private MaterialIntegration addMaterialIntegration(String ore) {
        this.integration = new MaterialIntegration(this.mat).setRepresentativeItem(ore);
        return this.integration;
    }

    private MaterialIntegration addMaterialIntegration(Fluid fluid) {
        this.integration = new MaterialIntegration(this.mat, fluid);
        return this.integration;
    }

    private MaterialIntegration addMaterialIntegration(String ore, Fluid fluid) {
        this.integration = new MaterialIntegration(this.mat, fluid, ore).setRepresentativeItem("ingot" + ore);
        return this.integration;
    }

    private MaterialIntegration addMaterialIntegration(String ore, Fluid fluid, String orerequirement) {
        this.integration = new MaterialIntegration(this.mat, fluid, ore, new String[]{orerequirement + ore}).setRepresentativeItem(orerequirement + ore);
        return this.integration;
    }
}

