/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.recipe;

import com.mattdahepic.mdecore.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTRespectingShapedOreRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    protected ItemStack output = null;
    protected List<ItemStack> input = null;
    protected int width = 0;
    protected int height = 0;

    public NBTRespectingShapedOreRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public NBTRespectingShapedOreRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public NBTRespectingShapedOreRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int i = 0;
        if (recipe[i] instanceof String[]) {
            String[] parts;
            for (String string : parts = (String[])recipe[i++]) {
                this.width = string.length();
                shape = shape + string;
            }
            this.height = parts.length;
        } else {
            while (recipe[i] instanceof String) {
                String s = (String)recipe[i++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object object : recipe) {
                ret = ret + object + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        final HashMap<Character, ItemStack> itemMap = new HashMap<Character, ItemStack>();
        while (i < recipe.length) {
            Object in;
            final Character c = (Character)recipe[i];
            if ((in = recipe[++i]) instanceof ItemStack) {
                itemMap.put(c, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(c, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(c, new ItemStack((Block)in));
            } else if (in instanceof String) {
                OreDictionary.getOres((String)((String)in)).forEach((Consumer)new Consumer<ItemStack>(){

                    @Override
                    public void accept(ItemStack s) {
                        itemMap.put(c, s);
                    }
                });
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            ++i;
        }
        this.input = new ArrayList<ItemStack>(itemMap.size());
        for (char c : shape.toCharArray()) {
            this.input.add((ItemStack)itemMap.get(Character.valueOf(c)));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting c) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return this.input.size() <= width * height;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        int matches = 0;
        for (int x = 0; x < this.width; ++x) {
            block1: for (int y = 0; y < this.height; ++y) {
                ItemStack target = this.input.get(x + y * this.width);
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (!this.isItemSame(target, slot)) continue;
                    ++matches;
                    continue;
                }
                if (!(target instanceof List)) continue;
                for (ItemStack s : (List)target) {
                    if (!this.isItemSame(s, slot)) continue;
                    ++matches;
                    continue block1;
                }
            }
        }
        return matches == this.input.size();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean isItemSame(ItemStack stack1, ItemStack stack2) {
        return ItemHelper.isSameIgnoreStackSize(stack1, stack2, true);
    }
}

