/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.mdecore.helpers;

import com.mattdahepic.mdecore.MDECore;
import com.mattdahepic.mdecore.helpers.EnvironmentHelper;
import com.mattdahepic.mdecore.network.PacketHandler;
import com.mattdahepic.mdecore.network.packet.TickratePacket;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Timer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TickrateHelper {
    private static final TickrateHelper INSTANCE = new TickrateHelper();
    public static float DEFAULT_TICKRATE = 20.0f;
    public static float TICKS_PER_SECOND = 20.0f;
    public static long MILISECONDS_PER_TICK = 50L;
    public static final float MIN_TICKRATE = 0.01f;
    public static final float MAX_TICKRATE = 1000.0f;
    private Field clientTimer = null;

    public static TickrateHelper instance() {
        return INSTANCE;
    }

    public static void setTickrate(MinecraftServer server, float tickrate) {
        TickrateHelper.setAllClientTickrate(server, tickrate);
        TickrateHelper.setServerTickrate(tickrate);
    }

    public static void setServerTickrate(float tickrate) {
        TickrateHelper.instance().updateServerTickrate(tickrate);
    }

    public static void setAllClientTickrate(MinecraftServer server, float tickrate) {
        if (EnvironmentHelper.isServer) {
            for (EntityPlayer p : server.func_184103_al().func_181057_v()) {
                TickrateHelper.setClientTickrate(p, tickrate);
            }
        } else {
            TickrateHelper.setClientTickrate(null, tickrate);
        }
    }

    public static void setClientTickrate(EntityPlayer p, float tickrate) {
        if (p == null || p.field_70170_p.field_72995_K) {
            if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
                return;
            }
            if (p != null && p != Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            TickrateHelper.instance().updateClientTickrate(tickrate);
        } else {
            PacketHandler.net.sendTo((IMessage)new TickratePacket.TickrateMessage(tickrate), (EntityPlayerMP)p);
        }
    }

    public static void resetClientTickrate() {
        TickrateHelper.setClientTickrate(null, DEFAULT_TICKRATE);
    }

    public static void setClientToCurrentServerTickrate(EntityPlayer p) {
        TickrateHelper.setClientTickrate(p, TickrateHelper.getServerTickrate());
    }

    public static float getClientTickrate() {
        return TICKS_PER_SECOND;
    }

    public static long getServerTickrate() {
        return 1000L / MILISECONDS_PER_TICK;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClientTickrate(float tickrate) {
        if (!TickrateHelper.isTickrateValid(tickrate)) {
            MDECore.logger.info("Ignoring invalid tickrate: " + tickrate);
            return;
        }
        MDECore.logger.debug("Updating client tickrate to " + tickrate);
        TICKS_PER_SECOND = tickrate;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        try {
            if (this.clientTimer == null) {
                MDECore.logger.debug("Creating reflection instances...");
                for (Field f : mc.getClass().getDeclaredFields()) {
                    if (f.getType() != Timer.class) continue;
                    this.clientTimer = f;
                    this.clientTimer.setAccessible(true);
                    break;
                }
            }
            this.clientTimer.set(mc, new Timer(TICKS_PER_SECOND));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateServerTickrate(float tickrate) {
        if (!TickrateHelper.isTickrateValid(tickrate)) {
            MDECore.logger.info("Ignoring invalid tickrate: " + tickrate);
            return;
        }
        MDECore.logger.debug("Updating server tickrate to " + tickrate);
        MILISECONDS_PER_TICK = (long)(1000.0f / tickrate);
    }

    public static boolean isTickrateValid(float tickrate) {
        return tickrate > 0.0f;
    }
}

