/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityOakGenerator;
import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOakGenerator
extends BlockContainerImpl
implements IVisualizable {
    public BlockOakGenerator() {
        super(Material.field_151575_d, "oak_generator", TileEntityOakGenerator.class, "oak_generator");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTreeGrow(SaplingGrowTreeEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!world.field_72995_K && IAuraType.forWorld(world).isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) && world.func_180495_p(pos).func_177230_c() instanceof BlockSapling) {
            Helper.getTileEntitiesInArea(world, pos, 10, tile -> {
                long seed;
                if (!(tile instanceof TileEntityOakGenerator)) {
                    return false;
                }
                Random rand = event.getRand();
                if (rand.nextInt(10) == 0) {
                    ((TileEntityOakGenerator)tile).scheduledBigTrees.add(pos);
                }
                do {
                    seed = rand.nextLong();
                    rand.setSeed(seed);
                } while (rand.nextInt(10) == 0);
                rand.setSeed(seed);
                return true;
            });
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return new AxisAlignedBB(pos).func_186662_g(10.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 3045905;
    }
}

