/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.blocks.multi.Multiblock;
import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.misc.WorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.util.vector.Vector3f;

public class InternalHooks
implements NaturesAuraAPI.IInternalHooks {
    @Override
    public boolean extractAuraFromPlayer(EntityPlayer player, int amount, boolean simulate) {
        return this.auraPlayerInteraction(player, amount, true, simulate);
    }

    @Override
    public boolean insertAuraIntoPlayer(EntityPlayer player, int amount, boolean simulate) {
        return this.auraPlayerInteraction(player, amount, false, simulate);
    }

    private boolean auraPlayerInteraction(EntityPlayer player, int amount, boolean extract, boolean simulate) {
        if (extract && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (Compat.baubles) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack.func_190926_b() || !stack.hasCapability(NaturesAuraAPI.capAuraContainer, null)) continue;
                IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer, null);
                amount = extract ? (amount -= container.drainAura(amount, simulate)) : (amount -= container.storeAura(amount, simulate));
                if (amount > 0) continue;
                return true;
            }
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || !stack.hasCapability(NaturesAuraAPI.capAuraContainer, null)) continue;
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer, null);
            amount = extract ? (amount -= container.drainAura(amount, simulate)) : (amount -= container.storeAura(amount, simulate));
            if (amount > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void spawnMagicParticle(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade) {
        NaturesAura.proxy.spawnMagicParticle(posX, posY, posZ, motionX, motionY, motionZ, color, scale, maxAge, gravity, collision, fade);
    }

    @Override
    public void spawnParticleStream(float startX, float startY, float startZ, float endX, float endY, float endZ, float speed, int color, float scale) {
        Vector3f dir = new Vector3f(endX - startX, endY - startY, endZ - startZ);
        float length = dir.length();
        if (length > 0.0f) {
            dir.normalise();
            this.spawnMagicParticle(startX, startY, startZ, dir.x * speed, dir.y * speed, dir.z * speed, color, scale, (int)(length / speed), 0.0f, false, false);
        }
    }

    @Override
    public void setParticleDepth(boolean depth) {
        NaturesAura.proxy.setParticleDepth(depth);
    }

    @Override
    public void setParticleSpawnRange(int range) {
        NaturesAura.proxy.setParticleSpawnRange(range);
    }

    @Override
    public IMultiblock createMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        return new Multiblock(name, pattern, rawMatchers);
    }

    @Override
    public List<Tuple<Vec3d, Integer>> getActiveEffectPowders(World world, AxisAlignedBB area, ResourceLocation name) {
        world.field_72984_F.func_194340_a(() -> "naturesaura:getActiveEffectPowders");
        ArrayList<Tuple<Vec3d, Integer>> found = new ArrayList<Tuple<Vec3d, Integer>>();
        for (Tuple powder : ((WorldData)IWorldData.getWorldData((World)world)).effectPowders.get((Object)name)) {
            if (!area.func_72318_a((Vec3d)powder.func_76341_a())) continue;
            found.add((Tuple<Vec3d, Integer>)powder);
        }
        world.field_72984_F.func_76319_b();
        return found;
    }

    @Override
    public boolean isEffectPowderActive(World world, BlockPos pos, ResourceLocation name) {
        world.field_72984_F.func_194340_a(() -> "naturesaura:isEffectPowderActive");
        Vec3d posVec = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        List<Tuple<Vec3d, Integer>> powders = this.getActiveEffectPowders(world, new AxisAlignedBB(pos).func_186662_g(64.0), name);
        for (Tuple<Vec3d, Integer> powder : powders) {
            AxisAlignedBB bounds = Helper.aabb((Vec3d)powder.func_76341_a()).func_186662_g((double)((Integer)powder.func_76340_b()).intValue());
            if (!bounds.func_72318_a(posVec)) continue;
            world.field_72984_F.func_76319_b();
            return true;
        }
        world.field_72984_F.func_76319_b();
        return false;
    }

    @Override
    public void getAuraSpotsInArea(World world, BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        world.field_72984_F.func_194340_a(() -> "naturesaura:getSpotsInArea");
        Helper.getAuraChunksInArea(world, pos, radius, chunk -> chunk.getSpotsInArea(pos, radius, consumer));
        world.field_72984_F.func_76319_b();
    }

    @Override
    public int getSpotAmountInArea(World world, BlockPos pos, int radius) {
        MutableInt result = new MutableInt();
        this.getAuraSpotsInArea(world, pos, radius, (blockpos, drainSpot) -> result.increment());
        return result.intValue();
    }

    @Override
    public int getAuraInArea(World world, BlockPos pos, int radius) {
        MutableInt result = new MutableInt(1000000);
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> result.add((Number)drainSpot));
        return result.intValue();
    }

    @Override
    public int triangulateAuraInArea(World world, BlockPos pos, int radius) {
        MutableFloat result = new MutableFloat(1000000.0f);
        IAuraChunk.getSpotsInArea(world, pos, radius, (blockPos, spot) -> {
            float percentage = 1.0f - (float)pos.func_185332_f(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()) / (float)radius;
            result.add((float)spot.intValue() * percentage);
        });
        return result.intValue();
    }

    @Override
    public BlockPos getLowestAuraDrainSpot(World world, BlockPos pos, int radius, BlockPos defaultSpot) {
        MutableInt lowestAmount = new MutableInt(Integer.MAX_VALUE);
        MutableObject lowestSpot = new MutableObject();
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> {
            if (drainSpot < lowestAmount.intValue()) {
                lowestAmount.setValue((Number)drainSpot);
                lowestSpot.setValue(blockPos);
            }
        });
        BlockPos lowest = (BlockPos)lowestSpot.getValue();
        if (lowest == null || lowestAmount.intValue() >= 0) {
            lowest = defaultSpot;
        }
        return lowest;
    }

    @Override
    public BlockPos getHighestAuraDrainSpot(World world, BlockPos pos, int radius, BlockPos defaultSpot) {
        MutableInt highestAmount = new MutableInt(Integer.MIN_VALUE);
        MutableObject highestSpot = new MutableObject();
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> {
            if (drainSpot > highestAmount.intValue()) {
                highestAmount.setValue((Number)drainSpot);
                highestSpot.setValue(blockPos);
            }
        });
        BlockPos highest = (BlockPos)highestSpot.getValue();
        if (highest == null || highestAmount.intValue() <= 0) {
            highest = defaultSpot;
        }
        return highest;
    }
}

