/*
 * Decompiled with CFR 0.152.
 */
package familiarfauna.entities;

import com.google.common.collect.Sets;
import familiarfauna.api.FFSounds;
import familiarfauna.config.ConfigurationHandler;
import familiarfauna.init.ModLootTable;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityDeer
extends EntityAnimal
implements IAnimals {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151034_e});
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityDeer.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityDeer(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.6f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.8, true, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, new AIAvoidEntity<EntityPlayer>(this, EntityPlayer.class, 5.0f, 2.0, 2.5));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FFSounds.deer_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return FFSounds.deer_dead;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(FFSounds.deer_step, 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("DeerType", this.getDeerType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setDeerType(tagCompund.func_74762_e("DeerType"));
    }

    public EntityDeer createChild(EntityAgeable ageable) {
        return new EntityDeer(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTable.DEER_LOOT;
    }

    protected boolean canMate() {
        return !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityDeer) {
            EntityDeer deer = (EntityDeer)otherAnimal;
            if (this.getDeerType() != deer.getDeerType()) {
                return this.canMate() && deer.canMate();
            }
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !ConfigurationHandler.deerEnable) {
            this.func_70106_y();
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.field_70146_Z.nextInt(2);
        int ii = this.field_70146_Z.nextInt(5);
        boolean flag = false;
        if (livingdata instanceof DeerTypeData) {
            i = ((DeerTypeData)livingdata).typeData;
            flag = true;
        } else {
            livingdata = new DeerTypeData(i);
        }
        this.setDeerType(i);
        if (ii == 0) {
            this.func_70873_a(-24000);
        }
        return livingdata;
    }

    public int getDeerType() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    public void setDeerType(int deerTypeId) {
        this.field_70180_af.func_187227_b(TYPE, (Object)((byte)deerTypeId));
    }

    public static class DeerTypeData
    implements IEntityLivingData {
        public int typeData;

        public DeerTypeData(int type) {
            this.typeData = type;
        }
    }

    static class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final EntityDeer deer;

        public AIAvoidEntity(EntityDeer deer, Class<T> p_i46403_2_, float p_i46403_3_, double p_i46403_4_, double p_i46403_6_) {
            super((EntityCreature)deer, p_i46403_2_, p_i46403_3_, p_i46403_4_, p_i46403_6_);
            this.deer = deer;
        }
    }
}

