/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Sets;
import hellfirepvp.astralsorcery.common.util.nbt.NBTComparator;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemComparator {
    public static boolean compare(@Nonnull ItemStack thisStack, @Nonnull ItemStack sampleCompare, Clause ... clauses) {
        boolean sampleHasTag;
        HashSet lClauses = Sets.newHashSet((Object[])clauses);
        if (lClauses.contains((Object)Clause.ITEM)) {
            if (thisStack.func_190926_b() && !sampleCompare.func_190926_b()) {
                return false;
            }
            if (!thisStack.func_190926_b() && !thisStack.func_77973_b().equals(sampleCompare.func_77973_b())) {
                return false;
            }
        }
        if (lClauses.contains((Object)Clause.AMOUNT_EXACT) ? thisStack.func_190916_E() != sampleCompare.func_190916_E() : lClauses.contains((Object)Clause.AMOUNT_LEAST) && thisStack.func_190916_E() > sampleCompare.func_190916_E()) {
            return false;
        }
        if (lClauses.contains((Object)Clause.META_STRICT) ? thisStack.func_77960_j() != sampleCompare.func_77960_j() : lClauses.contains((Object)Clause.META_WILDCARD) && thisStack.func_77960_j() != sampleCompare.func_77960_j() && thisStack.func_77960_j() != Short.MAX_VALUE && sampleCompare.func_77952_i() != Short.MAX_VALUE) {
            return false;
        }
        boolean thisHasTag = thisStack.func_77942_o() && !ItemComparator.isTagEmpty(thisStack.func_77978_p());
        boolean bl = sampleHasTag = sampleCompare.func_77942_o() && !ItemComparator.isTagEmpty(sampleCompare.func_77978_p());
        if (lClauses.contains((Object)Clause.NBT_STRICT)) {
            if (!thisHasTag && sampleHasTag) {
                return false;
            }
            if (!(!thisHasTag || sampleHasTag && thisStack.func_77978_p().equals((Object)sampleCompare.func_77978_p()))) {
                return false;
            }
        } else if (lClauses.contains((Object)Clause.NBT_LEAST) && thisHasTag) {
            if (!sampleHasTag) {
                return false;
            }
            if (!NBTComparator.contains(thisStack.func_77978_p(), sampleCompare.func_77978_p())) {
                return false;
            }
        }
        return !lClauses.contains((Object)Clause.CAPABILITIES_COMPATIBLE) || thisStack.areCapsCompatible(sampleCompare);
    }

    private static boolean isTagEmpty(NBTTagCompound compound) {
        for (String key : compound.func_150296_c()) {
            NBTBase value = compound.func_74781_a(key);
            if (value instanceof NBTTagCompound) {
                if (ItemComparator.isTagEmpty((NBTTagCompound)value)) continue;
                return false;
            }
            if (value instanceof NBTTagList) {
                if (ItemComparator.isListEmpty((NBTTagList)value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isListEmpty(NBTTagList list) {
        if (!list.func_82582_d()) {
            if (list.func_150303_d() != 9 && list.func_150303_d() != 10) {
                return false;
            }
            for (NBTBase element : list) {
                if (!(element instanceof NBTTagCompound ? !ItemComparator.isTagEmpty((NBTTagCompound)element) : element instanceof NBTTagList && !ItemComparator.isListEmpty((NBTTagList)element))) continue;
                return false;
            }
        }
        return true;
    }

    public static enum Clause {
        ITEM,
        AMOUNT_EXACT,
        AMOUNT_LEAST,
        META_STRICT,
        META_WILDCARD,
        NBT_STRICT,
        NBT_LEAST,
        CAPABILITIES_COMPATIBLE;


        public static class Sets {
            public static final Clause[] ITEMSTACK_STRICT = new Clause[]{ITEM, AMOUNT_EXACT, META_STRICT, NBT_STRICT, CAPABILITIES_COMPATIBLE};
        }
    }
}

