/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.entities.EntityShootingStar;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ShootingStarHandler
implements ITickHandler {
    private static final ShootingStarHandler instance = new ShootingStarHandler();
    private static final Random rand = new Random();
    private Map<UUID, List<Integer>> fleetingServerCache = Maps.newHashMap();

    private ShootingStarHandler() {
    }

    public static ShootingStarHandler getInstance() {
        return instance;
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        Side side = (Side)context[1];
        if (side == Side.SERVER) {
            int day;
            List<Integer> handledDays;
            EntityPlayer player = (EntityPlayer)context[0];
            World w = player.func_130014_f_();
            if (w.field_73011_w.func_177495_o() || !w.field_73011_w.func_191066_m() || !w.field_73011_w.func_76569_d()) {
                return;
            }
            int midnight = Math.round((float)Config.dayLength * 0.75f);
            int tfHalf = Config.dayLength / 12;
            int ch = Config.dayLength / 8;
            int dayTime = (int)(player.func_130014_f_().func_72820_D() % (long)Config.dayLength);
            if (dayTime >= midnight - tfHalf && dayTime <= midnight + tfHalf && rand.nextInt(ch) == 0 && !(handledDays = this.fleetingServerCache.getOrDefault(player.func_110124_au(), Lists.newArrayList())).contains(day = (int)(player.func_130014_f_().func_72820_D() / (long)Config.dayLength))) {
                Vector3 movement = Vector3.positiveYRandom().setY(0).normalize().multiply(0.2);
                EntityShootingStar star = new EntityShootingStar(player.func_130014_f_(), player.field_70165_t, 560.0, player.field_70161_v, movement);
                player.func_130014_f_().func_72838_d((Entity)star);
                handledDays.add(day);
                this.fleetingServerCache.put(player.func_110124_au(), handledDays);
            }
        }
    }

    public void clearServerCache() {
        this.fleetingServerCache.clear();
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return StarConfigEntry.enabled && phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "ShootingStar Handler";
    }

    public static class StarConfigEntry
    extends ConfigEntry {
        public static boolean enabled = true;
        public static boolean doExplosion = true;

        public StarConfigEntry() {
            super(ConfigEntry.Section.GENERAL, "shooting_stars");
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            enabled = cfg.getBoolean("enabled", this.getConfigurationSection(), enabled, "Set to false to disable shooting stars from spawning");
            doExplosion = cfg.getBoolean("doExplosion", this.getConfigurationSection(), doExplosion, "Set to true to make shooting stars do a little explosion where they land");
        }
    }
}

