/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.sky;

import asmodeuscore.core.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class CloudProviderBase
extends IRenderHandler {
    static Minecraft mc = Minecraft.func_71410_x();
    public long cloudTicks;
    public long cloudTicksPrev;
    public float cloudSpeed = 2.0f;

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (world.field_73011_w.getCloudRenderer() instanceof CloudProviderBase && mc.field_71474_y.func_181147_e() >= 1) {
            GL11.glPushMatrix();
            if (mc.field_71474_y.field_74347_j) {
                GL11.glEnable((int)2912);
            }
            this.renderClouds(partialTicks);
            GL11.glDisable((int)2912);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderClouds(float renderPartialTicks) {
        GlStateManager.func_179129_p();
        Entity entity = mc.func_175606_aa();
        float yOffset = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)renderPartialTicks);
        int cloudSections = 4;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        double viewX = (entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)renderPartialTicks + this.getCloudMovementX(entity.field_70170_p, this.cloudTicksPrev, this.cloudTicks) * (double)0.03f) / 12.0;
        double viewZ = (entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)renderPartialTicks + this.getCloudMovementZ(entity.field_70170_p, this.cloudTicksPrev, this.cloudTicks) * (double)0.03f) / 12.0;
        float cloudHeight = CloudProviderBase.mc.field_71441_e.field_73011_w.func_76571_f() - yOffset + 0.33f;
        viewX -= (double)(MathHelper.func_76128_c((double)(viewX / 2048.0)) * 2048);
        viewZ -= (double)(MathHelper.func_76128_c((double)(viewZ / 2048.0)) * 2048);
        CloudProviderBase.mc.field_71446_o.func_110577_a(this.getCloudTexture());
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float r = (float)this.getCloudColor((float)renderPartialTicks).field_72450_a / 255.0f;
        float g = (float)this.getCloudColor((float)renderPartialTicks).field_72448_b / 255.0f;
        float b = (float)this.getCloudColor((float)renderPartialTicks).field_72449_c / 255.0f;
        float alpha = (float)(1.0 - entity.field_70163_u / 700.0);
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        float f17 = (float)MathHelper.func_76128_c((double)viewX) * 0.00390625f;
        float f18 = (float)MathHelper.func_76128_c((double)viewZ) * 0.00390625f;
        float f19 = (float)(viewX - (double)MathHelper.func_76128_c((double)(viewX - 6.0)));
        float f20 = (float)(viewZ - (double)MathHelper.func_76128_c((double)(viewZ - 6.0)));
        GlStateManager.func_179152_a((float)12.0f, (float)1.0f, (float)12.0f);
        for (int pass = 0; pass < 2; ++pass) {
            if (pass == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int x = -cloudSections + 1; x <= cloudSections; ++x) {
                for (int z = -cloudSections + 1; z <= cloudSections; ++z) {
                    int v;
                    vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                    float cU = x * 8;
                    float cV = z * 8;
                    float cX = cU - f19;
                    float cZ = cV - f20;
                    if (cloudHeight > -5.0f) {
                        vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 0.0f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 0.0f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 0.0f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 0.0f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (cloudHeight <= 5.0f) {
                        vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 4.0f - 9.765625E-4f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 4.0f - 9.765625E-4f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 4.0f - 9.765625E-4f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 4.0f - 9.765625E-4f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (x > -1) {
                        for (v = 0; v < 8; ++v) {
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 0.0f), (double)(cloudHeight + 0.0f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 0.0f), (double)(cloudHeight + 4.0f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 0.0f), (double)(cloudHeight + 4.0f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 0.0f), (double)(cloudHeight + 0.0f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (x <= 1) {
                        for (v = 0; v < 8; ++v) {
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 1.0f - 9.765625E-4f), (double)(cloudHeight + 0.0f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 1.0f - 9.765625E-4f), (double)(cloudHeight + 4.0f), (double)(cZ + 8.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 8.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 1.0f - 9.765625E-4f), (double)(cloudHeight + 4.0f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + (float)v + 1.0f - 9.765625E-4f), (double)(cloudHeight + 0.0f), (double)(cZ + 0.0f)).func_187315_a((double)((cU + (float)v + 0.5f) * 0.00390625f + f17), (double)((cV + 0.0f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (z > -1) {
                        for (v = 0; v < 8; ++v) {
                            vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 4.0f), (double)(cZ + (float)v + 0.0f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 4.0f), (double)(cZ + (float)v + 0.0f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 0.0f), (double)(cZ + (float)v + 0.0f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 0.0f), (double)(cZ + (float)v + 0.0f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (z <= 1) {
                        for (v = 0; v < 8; ++v) {
                            vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 4.0f), (double)(cZ + (float)v + 1.0f - 9.765625E-4f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 4.0f), (double)(cZ + (float)v + 1.0f - 9.765625E-4f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + 8.0f), (double)(cloudHeight + 0.0f), (double)(cZ + (float)v + 1.0f - 9.765625E-4f)).func_187315_a((double)((cU + 8.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(cX + 0.0f), (double)(cloudHeight + 0.0f), (double)(cZ + (float)v + 1.0f - 9.765625E-4f)).func_187315_a((double)((cU + 0.0f) * 0.00390625f + f17), (double)((cV + (float)v + 0.5f) * 0.00390625f + f18)).func_181666_a(r, g, b, alpha).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        }
                    }
                    tessellator.func_78381_a();
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    private double getCloudMovementX(World world, float cloudTicksPrev, float cloudTicks) {
        return Utils.interpolateRotation(cloudTicksPrev, cloudTicks, Minecraft.func_71410_x().func_184121_ak());
    }

    private double getCloudMovementZ(World world, float cloudTicksPrev, float cloudTicks) {
        return 3.0;
    }

    public abstract float getCloudMovementSpeed(World var1);

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getCloudTexture();

    @SideOnly(value=Side.CLIENT)
    public abstract Vec3d getCloudColor(float var1);
}

