/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.worldengine;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.dimension.IProviderFreeze;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_BiomeProvider;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_ChunkProviderSpace;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_WorldProvider;
import galaxyspace.core.configs.GSConfigCore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeProviderDefault;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import net.minecraft.block.Block;
import net.minecraft.command.CommandTime;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WE_WorldProviderSpace
extends WE_WorldProvider
implements IGalacticraftWorldProvider,
ISolarLevel,
IExitHeight,
IAdvancedSpace,
IProviderFreeze {
    private long timeCurrentOffset = 0L;
    public long preTickTime = Long.MIN_VALUE;
    private long saveTCO = 0L;
    static Field tickCounter;

    @Override
    public void func_76572_b() {
        this.field_191067_f = true;
        if (this.getBiomeProviderClass() != null) {
            try {
                Constructor<?>[] constructors;
                Class<? extends BiomeProvider> biomeProviderClass = this.getBiomeProviderClass();
                for (Constructor<?> constr : constructors = biomeProviderClass.getConstructors()) {
                    System.out.println(constr.toString());
                    if (Arrays.equals(constr.getParameterTypes(), new Object[]{World.class})) {
                        this.field_76578_c = (BiomeProvider)constr.newInstance(this.field_76579_a);
                        continue;
                    }
                    if (constr.getParameterTypes().length != 0) continue;
                    this.field_76578_c = (BiomeProvider)constr.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.field_76578_c = new BiomeProviderDefault(this.getCelestialBody());
        }
        System.out.println("Init WE for: " + this.getCelestialBody().getName());
        System.out.println("Biome Provider: " + this.field_76578_c.toString());
    }

    @Override
    public IChunkGenerator func_186060_c() {
        System.out.println("WorldEngine: -Starting WorldEngine...");
        this.chunk_provider = new WE_ChunkProviderSpace(this);
        WE_Biome.setChunkProvider(this.chunk_provider);
        System.out.println("WorldEngine: -WorldEngine started successfully!");
        return this.chunk_provider;
    }

    public void updateWeather() {
        if (!this.field_76579_a.field_72995_K) {
            long newTime = this.field_76579_a.func_72912_H().func_76073_f();
            if (this.preTickTime == Long.MIN_VALUE) {
                int savedTick = 0;
                try {
                    tickCounter.setAccessible(true);
                    savedTick = tickCounter.getInt(this.field_76579_a.field_72982_D);
                    if (savedTick < 0) {
                        savedTick = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeCurrentOffset = (long)savedTick - newTime;
            } else {
                long diff = newTime - this.preTickTime;
                if (diff > 1L) {
                    this.timeCurrentOffset -= diff - 1L;
                    this.saveTime();
                }
            }
            this.preTickTime = newTime;
            this.saveTCO = 0L;
        }
        if (this.shouldDisablePrecipitation()) {
            this.field_76579_a.func_72912_H().func_76080_g(0);
            this.field_76579_a.func_72912_H().func_76084_b(false);
            this.field_76579_a.func_72912_H().func_76090_f(0);
            this.field_76579_a.func_72912_H().func_76069_a(false);
            this.field_76579_a.field_73004_o = 0.0f;
            this.field_76579_a.field_73017_q = 0.0f;
        } else {
            this.updateWeatherOverride();
        }
    }

    public float getGravity() {
        if (this.getCelestialBody() instanceof IExBody) {
            return ((IExBody)this.getCelestialBody()).getGravity();
        }
        return 0.058f;
    }

    public float getThermalLevelModifier() {
        if (this.enableAdvancedThermalLevel() && this.field_76579_a != null) {
            float angle = this.field_76579_a.func_72826_c((float)this.getDayLength());
            float value = MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * this.getThermalValueMod();
            float def = this.getCelestialBody().atmosphere.thermalLevel();
            if ((double)def < 0.0) {
                value *= -1.0f;
            }
            return def == 0.0f ? value : value * def + def;
        }
        return this.getCelestialBody().atmosphere.thermalLevel();
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getCelestialBody().getTierRequirement();
    }

    public float getSolarSizeForMoon() {
        return 1.0f / ((Moon)this.getCelestialBody()).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getCelestialBody() instanceof IChildBody ? (double)this.getSolarSizeForMoon() : (double)this.getSolarSize();
            solarMultiplier += s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getCelestialBody() instanceof IChildBody ? (double)this.getSolarSizeForMoon() : (double)this.getSolarSize();
            solarMultiplier = s * s;
        }
        return solarMultiplier;
    }

    public double getYCoordinateToTeleport() {
        return 1000.0;
    }

    public int func_76559_b(long time) {
        long timeday = this.getDayLength() > 0L ? this.getDayLength() : 1L;
        return (int)(time / timeday % 8L + 8L) % 8;
    }

    public String getSaveFolder() {
        return "DIM" + this.getCelestialBody().getDimensionID();
    }

    public boolean isGasPresent(EnumAtmosphericGas gas) {
        return this.getCelestialBody().atmosphere.isGasPresent(gas);
    }

    public boolean hasNoAtmosphere() {
        return this.getCelestialBody().atmosphere.hasNoGases();
    }

    public boolean hasBreathableAtmosphere() {
        return this.getCelestialBody().atmosphere.isBreathable();
    }

    public boolean shouldDisablePrecipitation() {
        return !this.getCelestialBody().atmosphere.hasPrecipitation();
    }

    public float getSoundVolReductionAmount() {
        float d = this.getCelestialBody().atmosphere.relativeDensity();
        if (d <= 0.0f) {
            return 20.0f;
        }
        if (d > 5.0f) {
            return 0.2f;
        }
        return 1.0f / d;
    }

    public double getMeteorFrequency() {
        float d = this.getCelestialBody().atmosphere.relativeDensity();
        if (d <= 0.0f) {
            return 5.0;
        }
        return (double)d * 100.0;
    }

    public float getWindLevel() {
        return this.getCelestialBody().atmosphere.windLevel();
    }

    public boolean shouldCorrodeArmor() {
        return this.getCelestialBody().atmosphere.isCorrosive();
    }

    public boolean canDoLightning(Chunk chunk) {
        return !this.shouldDisablePrecipitation();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return !this.shouldDisablePrecipitation();
    }

    public float getSolarSize() {
        return 1.0f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public float[] func_76560_a(float var1, float var2) {
        return this.hasSunset() ? super.func_76560_a(var1, var2) : null;
    }

    public boolean enableAdvancedThermalLevel() {
        return GSConfigCore.enableAdvancedThermalSystem;
    }

    protected float getThermalValueMod() {
        return 0.5f;
    }

    public long getDayLength() {
        if (this.getCelestialBody() instanceof IExBody) {
            return ((IExBody)this.getCelestialBody()).getDayLength();
        }
        return 24000L;
    }

    public float func_76563_a(long par1, float par3) {
        par1 = this.getWorldTime();
        int j = (int)(par1 % this.getDayLength());
        float f1 = ((float)j + par3) / (float)this.getDayLength() - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 += (f2 - f1) / 3.0f;
        return f1;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float var1, float var2) {
        Vector3 fogColor = this.getFogColor();
        return new Vec3d((double)fogColor.floatX(), (double)fogColor.floatY(), (double)fogColor.floatZ());
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        Vector3 skyColor = this.getSkyColor();
        return new Vec3d((double)skyColor.floatX(), (double)skyColor.floatY(), (double)skyColor.floatZ());
    }

    public boolean func_76561_g() {
        return true;
    }

    public boolean func_76569_d() {
        return this.field_76579_a != null;
    }

    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.shouldForceRespawn() ? this.getDimension() : 0;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public boolean netherPortalsOperational() {
        return false;
    }

    public float getArrowGravity() {
        return 0.005f;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return WE_BiomeProvider.class;
    }

    public BiomeProvider func_177499_m() {
        if (this.getBiomeProviderClass() == null) {
            BiomeAdaptive.setBody((CelestialBody)this.getCelestialBody());
        }
        return this.field_76578_c;
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return false;
    }

    public void setWorldTime(long time) {
        this.field_76579_a.func_72912_H().func_76068_b(time);
        if (!this.field_76579_a.field_72995_K) {
            if (JavaUtil.instance.isCalledBy(CommandTime.class)) {
                this.timeCurrentOffset = this.saveTCO;
                this.saveTime();
                this.preTickTime = time;
            } else {
                long newTCO = time - this.field_76579_a.func_72912_H().func_76073_f();
                long diff = newTCO - this.timeCurrentOffset;
                if (diff > 1L || diff < -1L) {
                    this.timeCurrentOffset = newTCO;
                    this.saveTime();
                    this.preTickTime = time;
                }
            }
            this.saveTCO = 0L;
        }
    }

    public long getWorldTime() {
        if (JavaUtil.instance.isCalledBy(CommandTime.class)) {
            this.saveTCO = this.timeCurrentOffset;
        }
        return this.field_76579_a.func_72912_H().func_76073_f() + this.timeCurrentOffset;
    }

    public void adjustTimeOffset(long diff) {
        if (diff != 0L) {
            this.timeCurrentOffset -= diff;
            this.preTickTime += diff;
            this.saveTime();
        }
    }

    public void adjustTime(long newTime) {
        long diff = newTime - this.preTickTime;
        if (diff != 0L) {
            this.timeCurrentOffset -= diff;
            this.preTickTime = newTime;
            this.saveTime();
        }
    }

    private void saveTime() {
        try {
            VillageCollection vc = this.field_76579_a.field_72982_D;
            tickCounter.setAccessible(true);
            tickCounter.setInt(vc, (int)this.getWorldTime());
            vc.func_76185_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateWeatherOverride() {
        super.updateWeather();
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public abstract boolean hasSunset();

    public abstract Vector3 getFogColor();

    public abstract Vector3 getSkyColor();

    public abstract Class<? extends IChunkGenerator> getChunkProviderClass();

    @Override
    public abstract void onChunkProvider(int var1, int var2, ChunkPrimer var3);

    @Override
    public abstract void onPopulate(int var1, int var2);

    @Override
    public abstract void recreateStructures(Chunk var1, int var2, int var3);

    static {
        try {
            tickCounter = VillageCollection.class.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "tickCounter" : "field_75553_e");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

