/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.thermalexpansion;

import cofh.api.util.ThermalExpansionHelper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.init.TFItems;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.fluidreplicator.FluidReplicatorRecipe;
import techreborn.api.fluidreplicator.FluidReplicatorRecipeList;
import techreborn.api.recipe.Fuels;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.compat.ICompatModule;
import techreborn.init.ModItems;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemDynamicCell;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemPlates;

@RebornRegistry(modOnly="thermalexpansion", modID="techreborn")
public class ThermalExpansionCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="thermal_expansion", key="EnableDistillationTowerThermalExpansionRecipes", comment="Enable distillation tower recipes related to ThermalExpansion content")
    public static boolean enableDistillationTowerThermalExpansionRecipes = true;
    @ConfigRegistry(config="compat", category="thermal_expansion", key="EnableThermalExpansionFuels", comment="Allow Thermal Expansion fuels to be used in the fuel generators")
    public static boolean enableThermalExpansionFuels = true;
    @ConfigRegistry(config="compat", category="thermal_expansion", key="DisableInductionSmelterRecipesBypassingBlastFurnace", comment="Disable induction smelter recipes that bypass the use of the blast furnace (i.e. tungsten ingots)")
    public static boolean disableInductionSmelterRecipesBypassingBlastFurnace = true;

    public void init(FMLInitializationEvent event) {
        ThermalExpansionHelper.addPulverizerRecipe((int)2000, (ItemStack)new ItemStack(Items.field_151079_bi), (ItemStack)RecipeMethods.getMaterial((String)"ender_pearl", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST));
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)new ItemStack(Items.field_151061_bv), (ItemStack)RecipeMethods.getMaterial((String)"ender_eye", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST));
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)new ItemStack(Items.field_151145_ak), (ItemStack)RecipeMethods.getMaterial((String)"flint", (int)2, (RecipeMethods.Type)RecipeMethods.Type.SMALL_DUST), (ItemStack)RecipeMethods.getMaterial((String)"flint", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)2500, (ItemStack)new ItemStack((Item)ModItems.CELL), (ItemStack)RecipeMethods.getMaterial((String)"tin", (int)4, (RecipeMethods.Type)RecipeMethods.Type.SMALL_DUST));
        ThermalExpansionHelper.addPulverizerRecipe((int)2500, (ItemStack)new ItemStack(Blocks.field_150377_bs), (ItemStack)RecipeMethods.getMaterial((String)"endstone", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"endstone", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"galena", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"galena", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"sulfur", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)50);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"ruby", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"ruby", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"red_garnet", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"sapphire", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"sapphire", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"sphalerite", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"bauxite", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"bauxite", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"aluminum", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"pyrite", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"pyrite", (int)5, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"iron", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"cinnabar", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"cinnabar", (int)3, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)new ItemStack(Items.field_151137_ax), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)4000, (ItemStack)RecipeMethods.getMaterial((String)"sphalerite", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"sphalerite", (int)4, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"zinc", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)5000, (ItemStack)RecipeMethods.getMaterial((String)"tungsten", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"tungsten", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"manganese", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"peridot", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"peridot", (int)2, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"emerald", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        ThermalExpansionHelper.addPulverizerRecipe((int)3000, (ItemStack)RecipeMethods.getMaterial((String)"sodalite", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getMaterial((String)"sodalite", (int)12, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"aluminum", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (int)10);
        for (String plate : ItemPlates.types) {
            if (plate.equals("PLACEHOLDER_ITEM") || !ItemDusts.hasDust((String)plate)) continue;
            ThermalExpansionHelper.addPulverizerRecipe((int)5000, (ItemStack)RecipeMethods.getMaterial((String)plate, (int)1, (RecipeMethods.Type)RecipeMethods.Type.PLATE), (ItemStack)RecipeMethods.getMaterial((String)plate, (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST));
        }
        ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)new ItemStack(Items.field_151042_j, 2), (ItemStack)new ItemStack((Block)Blocks.field_150354_m), (ItemStack)RecipeMethods.getMaterial((String)"refined_iron", (int)2, (RecipeMethods.Type)RecipeMethods.Type.INGOT), (ItemStack)ItemMaterial.crystalSlag.func_77946_l(), (int)25);
        FluidReplicatorRecipeList.addRecipe((FluidReplicatorRecipe)new FluidReplicatorRecipe(4, TFFluids.fluidCoal, 100, 20));
        if (enableDistillationTowerThermalExpansionRecipes) {
            RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemDynamicCell.getCellWithFluid((Fluid)TFFluids.fluidCrudeOil, (int)16), (Object)ItemDynamicCell.getEmptyCell((int)33), RecipeMethods.getMaterial((String)"diesel", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"sulfuricAcid", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"glyceryl", (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"methane", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), 16000, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemDynamicCell.getCellWithFluid((Fluid)TFFluids.fluidBiocrude, (int)16), null, ItemDynamicCell.getCellWithFluid((Fluid)TFFluids.fluidBiofuel, (int)8), ItemDynamicCell.getEmptyCell((int)8), null, null, 400, 16));
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (enableThermalExpansionFuels) {
            Fuels.semiFluidGenerator.addFuel().addFluidSource(TFFluids.fluidCreosote).withEnergyOutput(3.0).withEnergyPerTick(3.0).register();
            Fuels.semiFluidGenerator.addFuel().addFluidSource(TFFluids.fluidCrudeOil).withEnergyOutput(16.0).withEnergyPerTick(8.0).register();
            Fuels.dieselGenerator.addFuel().addFluidSource(TFFluids.fluidBiofuel).withEnergyOutput(32.0).withEnergyPerTick(16.0).register();
            Fuels.semiFluidGenerator.addFuel().addFluidSource(TFFluids.fluidCoal).withEnergyOutput(48.0).withEnergyPerTick(8.0).register();
            Fuels.semiFluidGenerator.addFuel().addFluidSource(TFFluids.fluidRefinedOil).withEnergyOutput(48.0).withEnergyPerTick(8.0).register();
            Fuels.dieselGenerator.addFuel().addFluidSource(TFFluids.fluidRefinedOil).withEnergyOutput(384.0).withEnergyPerTick(20.0).register();
            Fuels.semiFluidGenerator.addFuel().addFluidSource(TFFluids.fluidSeedOil).withEnergyOutput(8.0).withEnergyPerTick(8.0).register();
            Fuels.semiFluidGenerator.addFuel().addFluidSource(TFFluids.fluidTreeOil).withEnergyOutput(48.0).withEnergyPerTick(8.0).register();
        }
        if (disableInductionSmelterRecipesBypassingBlastFurnace) {
            ThermalExpansionHelper.removeSmelterRecipe((ItemStack)RecipeMethods.getMaterial((String)"tungsten", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getStack((Block)Blocks.field_150354_m));
            ThermalExpansionHelper.removeSmelterRecipe((ItemStack)RecipeMethods.getMaterial((String)"tungsten", (int)1, (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getStack((Block)Blocks.field_150354_m));
            ThermalExpansionHelper.removeSmelterRecipe((ItemStack)RecipeMethods.getMaterial((String)"tungsten", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getStack((Item)TFItems.itemMaterial, (int)1, (int)866));
            ThermalExpansionHelper.removeSmelterRecipe((ItemStack)RecipeMethods.getMaterial((String)"tungsten", (int)1, (RecipeMethods.Type)RecipeMethods.Type.ORE), (ItemStack)RecipeMethods.getStack((Item)TFItems.itemMaterial, (int)1, (int)865));
        }
    }
}

