/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import java.lang.invoke.MethodHandle;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.util.MethodHandleHelper;

public class ModelLoaderCleanup {
    private static final MethodHandle LOADING_EXCEPTIONS_GETTER = MethodHandleHelper.findFieldGetter(ModelLoader.class, "loadingExceptions");
    private static final MethodHandle STATE_MODELS_GETTER = MethodHandleHelper.findFieldGetter(ModelLoader.class, "stateModels");
    private final Ticker ticker = new Ticker();
    private ModelLoader loader;

    public void tick() {
        this.ticker.onClientTick(null);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        this.loader = event.getModelLoader();
        MinecraftForge.EVENT_BUS.register((Object)this.ticker);
    }

    public class Ticker {
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (ModelLoaderCleanup.this.loader != null) {
                FoamFix.logger.info("Cleaning up ModelLoader...");
                try {
                    LOADING_EXCEPTIONS_GETTER.invoke(ModelLoaderCleanup.this.loader).clear();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    STATE_MODELS_GETTER.invoke(ModelLoaderCleanup.this.loader).clear();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ModelLoaderCleanup.this.loader = null;
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
    }
}

