/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityThrownItem
extends EntityThrowable {
    private static final DataParameter<Boolean> DW_ROTATING = EntityDataManager.func_187226_a(EntityThrownItem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DW_EXPLODING = EntityDataManager.func_187226_a(EntityThrownItem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DW_FLOATING = EntityDataManager.func_187226_a(EntityThrownItem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> DW_ITEM = EntityDataManager.func_187226_a(EntityThrownItem.class, (DataSerializer)DataSerializers.field_187196_f);
    private int damage = 2;
    public EntityItem entityitem;
    public int age = 0;
    public ItemStack dropItem = null;
    public float hoverStart = (float)(Math.random() * Math.PI * 2.0);
    public int fireChance = 0;

    public EntityThrownItem(World world) {
        super(world);
    }

    public EntityThrownItem(World world, EntityLiving entity, ItemStack itemstack, int damage) {
        super(world, (EntityLivingBase)entity);
        this.setItem(itemstack);
        this.damage = damage;
    }

    public EntityThrownItem(World par1World, EntityLiving par2EntityLiving, float par3, int damage) {
        super(par1World, (EntityLivingBase)par2EntityLiving);
        this.damage = damage;
        this.func_70012_b(par2EntityLiving.field_70165_t, par2EntityLiving.field_70163_u + (double)par2EntityLiving.func_70047_e(), par2EntityLiving.field_70161_v, par2EntityLiving.field_70177_z, par2EntityLiving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.20000000149011612;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.shoot(par3);
    }

    public void shoot(float speed) {
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DW_ROTATING, (Object)false);
        this.field_70180_af.func_187214_a(DW_FLOATING, (Object)false);
        this.field_70180_af.func_187214_a(DW_EXPLODING, (Object)false);
    }

    public boolean isRotating() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_ROTATING);
    }

    public void setRotating() {
        this.field_70180_af.func_187227_b(DW_ROTATING, (Object)true);
    }

    public boolean isFloating() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_FLOATING);
    }

    public void setFloating(boolean floating) {
        this.field_70180_af.func_187227_b(DW_FLOATING, (Object)floating);
    }

    public boolean isExplosive() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_EXPLODING);
    }

    public void setExplosive(boolean explosive) {
        this.field_70180_af.func_187227_b(DW_EXPLODING, (Object)explosive);
    }

    public void setItem(ItemStack itemstack) {
        this.field_70180_af.func_187227_b(DW_ITEM, (Object)itemstack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(DW_ITEM);
    }

    public void func_70071_h_() {
        ++this.age;
        if (!this.field_70170_p.field_72995_K && this.age > 50) {
            this.func_70106_y();
        }
        if (this.isFloating()) {
            return;
        }
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if (this.isRotating()) {
            this.field_70125_A -= (float)(this.age * 2);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("Age", this.age);
        if (this.getItem() != null) {
            par1NBTTagCompound.func_74782_a("Item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.age = par1NBTTagCompound.func_74762_e("Age");
        NBTTagCompound var2 = par1NBTTagCompound.func_74775_l("Item");
        ItemStack item = new ItemStack(var2);
        if (item.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(item);
        }
    }

    protected void func_70184_a(RayTraceResult movingobjectposition) {
        if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = movingobjectposition.func_178782_a();
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.func_180646_a(state, (IBlockAccess)this.field_70170_p, pos) == null) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.func_184102_h().func_71218_a(0).func_82736_K().func_82766_b("animalbikesTerrainDamage") && this.fireChance > 0 && this.field_70170_p.field_73012_v.nextInt(this.fireChance) == 1 && !this.field_70170_p.func_175623_d(pos)) {
                this.setFire(pos.func_177977_b());
                this.setFire(pos.func_177984_a());
                this.setFire(pos.func_177968_d());
                this.setFire(pos.func_177974_f());
                this.setFire(pos.func_177978_c());
                this.setFire(pos.func_177976_e());
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isExplosive()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            return;
        }
        Entity entity = movingobjectposition.field_72308_g;
        if (entity != null) {
            if (this.fireChance > 0) {
                if (!entity.func_70045_F()) {
                    entity.func_70097_a(DamageSource.field_76372_a, 3.0f);
                    entity.func_70015_d(5);
                }
            } else {
                entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), (float)this.damage);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.dropItem != null) {
                this.func_70099_a(this.dropItem, 0.0f);
            }
            if (this.isExplosive()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 0.8f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
            this.func_70106_y();
        }
    }

    private void setFire(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151579_a) {
            return;
        }
        this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
    }

    public void func_70106_y() {
        super.func_70106_y();
    }
}

