/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees.species;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import maxhyper.dynamictreesttf.ModContent;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import twilightforest.biomes.TFBiomes;

public class SpeciesSpruceHuge
extends Species {
    public SpeciesSpruceHuge(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesttf", "hugemegaspruce"), treeFamily);
        this.setBasicGrowingParameters(0.3f, 30.0f, 6, 9, 1.2f);
        this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(7.0f));
        this.setRequiresTileEntity(true);
        this.setSoilLongevity(32);
        this.addGenFeature((IGenFeature)new FeatureGenClearVolume(25));
        this.addGenFeature((IGenFeature)new FeatureGenMound(999));
        this.getFamily().addSpeciesLocationOverride(new TreeFamily.ISpeciesLocationOverride(){

            public Species getSpeciesForLocation(World access, BlockPos trunkPos) {
                if (Species.isOneOfBiomes((Biome)access.func_180494_b(trunkPos), (Biome[])new Biome[]{TFBiomes.snowy_forest})) {
                    return ModContent.hugeSpruce;
                }
                if (Species.isOneOfBiomes((Biome)access.func_180494_b(trunkPos), (Biome[])new Biome[]{TFBiomes.highlands, TFBiomes.highlandsCenter})) {
                    return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "megaspruce"));
                }
                return Species.NULLSPECIES;
            }
        });
    }

    public ResourceLocation getSaplingName() {
        return new ResourceLocation("dynamictrees", "spruce");
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public int maxBranchRadius() {
        return 24;
    }

    public boolean isThick() {
        return true;
    }
}

