/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceTransform;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilightThick;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import maxhyper.dynamictreesttf.trees.TreeTwilightOak;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;

@Deprecated
public class TreeRobustTwilightOak
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:twilight_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:twilight_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176203_a(0);
    public static int logsMeta = 0;
    public static int saplingMeta = 4;

    public TreeRobustTwilightOak() {
        super(new ResourceLocation("dynamictreesttf", "robustTwilightOak"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesRobustTwilightOak(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return new ArrayList<Item>();
    }

    public boolean isThick() {
        return true;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        return super.getRegisterableBlocks(blockList);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return TreeTwilightOak.twilightRoots;
    }

    public BlockBranch createBranch() {
        String branchName = "robustTwilightOakbranch";
        BlockBranchTwilightThick branch = new BlockBranchTwilightThick(branchName){

            public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
                BlockPos rootPos = TreeHelper.findRootNode((IBlockState)state, (World)world, (BlockPos)pos);
                Species realSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesttf", "twilightOakSickly"));
                SubstanceTransform effect = new SubstanceTransform(realSpecies);
                effect.apply(world, rootPos);
            }
        };
        branch.func_149675_a(true);
        return branch;
    }

    public class SpeciesRobustTwilightOak
    extends Species {
        SpeciesRobustTwilightOak(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.robustTwilightOakLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 25.0f, 50, 15, 1.5f);
            this.setSoilLongevity(50);
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 20, 10));
            this.addGenFeature((IGenFeature)new FeatureGenMound(6));
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(20));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(10).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public ResourceLocation getSaplingName() {
            return new ResourceLocation("dynamictreesttf", "twilightoakrobust");
        }

        public boolean onTreeActivated(World world, BlockPos rootPos, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
            Species realSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesttf", "twilightOakRobust"));
            SubstanceTransform effect = new SubstanceTransform(realSpecies);
            effect.apply(world, rootPos);
            return super.onTreeActivated(world, rootPos, hitPos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        }

        public boolean isThick() {
            return true;
        }

        public int maxBranchRadius() {
            return 18;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 1;
            probMap[1] = signal.isInTrunk() ? this.getUpProbability() : 0;
            probMap[5] = signal.isInTrunk() ? 1 : 20;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            probMap[originDir.ordinal()] = 0;
            int n = signal.dir.func_176745_a();
            probMap[n] = probMap[n] * 2;
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.energy < 6.0f && !signal.isInTrunk()) {
                signal.energy = 6.0f;
            }
            return newDir;
        }
    }
}

