/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;

public class TreeDarkwood
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:dark_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:twilight_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176223_P();
    public static int logsMeta = 3;
    public static int saplingMeta = 3;
    public static int darkForestHeight = 8;
    public static BlockDynamicLeaves darkwoodLeaves;

    public TreeDarkwood() {
        super(new ResourceLocation("dynamictreesttf", "darkwood"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        darkwoodLeaves = new BlockDynamicLeaves(){

            public boolean func_149662_c(IBlockState state) {
                return true;
            }
        };
        darkwoodLeaves.setRegistryName("leaves_darkwood");
        ModContent.darkwoodLeavesProperties.setTree((TreeFamily)this);
        ModContent.darkwoodLeavesProperties.setDynamicLeavesState(darkwoodLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        darkwoodLeaves.setProperties(0, ModContent.darkwoodLeavesProperties);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesDarkwood(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)darkwoodLeaves);
        return super.getRegisterableBlocks(blockList);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        String branchName = "darkwoodbranch";
        return new BlockBranchTwilight(branchName);
    }

    public class SpeciesDarkwood
    extends Species {
        SpeciesDarkwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.darkwoodLeavesProperties);
            this.setBasicGrowingParameters(0.2f, 10.0f, 2, 3, this.growthRate);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 5, 3));
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(this.coordHashCode(pos.func_177981_b(month)) % 16);
        }

        public int getLowestBranchHeight(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return (int)(((float)this.getLowestBranchHeight() + (float)(this.coordHashCode(pos.func_177981_b(month)) % 16) * 0.1f) * this.biomeSuitability(world, pos));
        }

        private EnumFacing getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return EnumFacing.SOUTH;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return EnumFacing.EAST;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.UP;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            if (pos.func_177956_o() - signal.rootPos.func_177956_o() > darkForestHeight) {
                signal.energy = 2.0f;
            }
            if (signal.isInTrunk() && pos.func_177956_o() > signal.rootPos.func_177956_o() + this.getLowestBranchHeight() + 1) {
                probMap[EnumFacing.UP.func_176745_a()] = 0;
            }
            if (!signal.isInTrunk()) {
                EnumFacing relativePosToRoot = this.getRelativeFace(pos, signal.rootPos);
                if (signal.energy > 3.0f) {
                    probMap[EnumFacing.DOWN.func_176745_a()] = 0;
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        probMap[dir.func_176745_a()] = 0;
                    }
                }
                boolean isBranchUp = world.func_180495_p(pos.func_177972_a(relativePosToRoot)).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS);
                boolean isBranchSide = world.func_180495_p(pos.func_177984_a()).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS);
                probMap[EnumFacing.UP.func_176745_a()] = isBranchUp && !isBranchSide ? 0 : 3;
                probMap[relativePosToRoot.func_176745_a()] = isBranchSide && !isBranchUp ? 0 : 1;
            }
            return probMap;
        }
    }
}

