/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockDynamicTwilightRootsExposed
extends BlockDynamicTwilightRoots {
    public static final IUnlistedProperty[] CONNECTIONS = new IUnlistedProperty[]{new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusd", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusu", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusn", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuss", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiusw", (int)0, (int)8)), new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"radiuse", (int)0, (int)8))};

    public BlockDynamicTwilightRootsExposed() {
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)GRASSY, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(2.5f);
        this.func_149675_a(false);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundType.field_185848_a;
    }

    @Override
    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    @Override
    protected ItemStack func_180643_i(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)RADIUS) >= 6) {
            if (((Boolean)state.func_177229_b((IProperty)GRASSY)).booleanValue()) {
                return new ItemStack(Item.func_150898_a((Block)TFBlocks.root), 1, 1);
            }
            return new ItemStack(Item.func_150898_a((Block)TFBlocks.root), 1, 0);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        if (((Boolean)state.func_177229_b((IProperty)GRASSY)).booleanValue()) {
            ret.add((Object)new ItemStack(TFItems.liveroot, 1, 0));
        } else {
            ret.add((Object)new ItemStack(Items.field_151055_y, (int)Math.ceil((float)((Integer)state.func_177229_b((IProperty)RADIUS)).intValue() / 2.0f), 0));
        }
        return ret;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack handStack = playerIn.func_184614_ca();
        if (handStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d)) {
            int thisRadius = (Integer)state.func_177229_b((IProperty)RADIUS);
            worldIn.func_175656_a(pos, ModContent.undergroundRoot.func_176223_P().func_177226_a((IProperty)BlockDynamicTwilightRoots.RADIUS, (Comparable)Integer.valueOf(thisRadius)));
            if (!playerIn.func_184812_l_()) {
                handStack.func_190918_g(1);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187587_bZ, SoundCategory.PLAYERS, 1.0f, 0.8f);
            playerIn.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        if (handStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150349_c)) {
            int thisRadius = (Integer)state.func_177229_b((IProperty)RADIUS);
            worldIn.func_175656_a(pos, ModContent.undergroundRoot.func_176223_P().func_177226_a((IProperty)BlockDynamicTwilightRoots.RADIUS, (Comparable)Integer.valueOf(thisRadius)).func_177226_a((IProperty)GRASSY, (Comparable)Boolean.valueOf(true)));
            if (!playerIn.func_184812_l_()) {
                handStack.func_190918_g(1);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.PLAYERS, 1.0f, 0.8f);
            playerIn.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return blockState.func_177230_c() == this ? (Integer)blockState.func_177229_b((IProperty)RADIUS) : 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{RADIUS, GRASSY};
        return new ExtendedBlockState((Block)this, listedProperties, CONNECTIONS);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            int thisRadius = this.getRadius(state);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                retval = retval.withProperty(CONNECTIONS[dir.func_176745_a()], (Object)this.getSideConnectionRadius(world, pos, thisRadius, dir));
            }
            return retval;
        }
        return state;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)RADIUS) == 8;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.getRadius(state) == 8;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.func_180664_k() == layer;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return field_185506_k;
        }
        int thisRadius = this.getRadius(state);
        boolean connectionMade = false;
        double radius = (double)thisRadius / 16.0;
        double gap = 0.5 - radius;
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.getSideConnectionRadius(blockAccess, pos, thisRadius, dir) <= 0) continue;
            connectionMade = true;
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap);
        }
        if (connectionMade) {
            return aabb.func_72317_d(0.5, 0.5, 0.5);
        }
        return new AxisAlignedBB(0.5 - radius, 0.5 - radius, 0.5 - radius, 0.5 + radius, 0.5 + radius, 0.5 + radius);
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess world, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return this.getRadius(blockState);
    }

    protected int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        IBlockState blockState = blockAccess.func_180495_p(deltaPos);
        if (blockState.func_177228_b().containsKey((Object)RADIUS)) {
            return (Integer)blockState.func_177229_b((IProperty)RADIUS);
        }
        if (blockState.func_177230_c() == ModBlocks.blockRootyDirt && blockAccess.func_180495_p(pos).func_177228_b().containsKey((Object)RADIUS)) {
            return (Integer)blockAccess.func_180495_p(pos).func_177229_b((IProperty)RADIUS);
        }
        return 0;
    }
}

