/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.api.filter.ComparatorMatch;
import teamroots.embers.api.filter.EnumFilterSetting;
import teamroots.embers.api.filter.FilterAny;
import teamroots.embers.api.filter.FilterExisting;
import teamroots.embers.api.filter.FilterNotExisting;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.filter.IFilterComparator;

public class FilterUtil {
    static List<IFilterComparator> comparators = new ArrayList<IFilterComparator>();
    static Map<String, IFilterComparator> comparatorMap = new HashMap<String, IFilterComparator>();
    static Map<ResourceLocation, Function<NBTTagCompound, IFilter>> filterRegistry = new LinkedHashMap<ResourceLocation, Function<NBTTagCompound, IFilter>>();
    public static IFilterComparator ANY = new ComparatorMatch("any", 999999){

        @Override
        public boolean match(ItemStack stack1, ItemStack stack2) {
            return true;
        }

        @Override
        public String format(ItemStack stack1, ItemStack stack2, EnumFilterSetting setting, boolean inverted) {
            return I18n.func_135052_a((String)"embers.filter.any", (Object[])new Object[0]);
        }
    };
    public static IFilter FILTER_ANY = new FilterAny();
    public static IFilter FILTER_EXISTING = new FilterExisting();
    public static IFilter FILTER_NOT_EXISTING = new FilterNotExisting();

    public static void registerComparator(IFilterComparator comparator) {
        comparatorMap.put(comparator.getName(), comparator);
        comparators.add(comparator);
        comparators.sort(Comparator.comparingInt(IFilterComparator::getPriority).reversed());
    }

    public static void registerFilter(ResourceLocation resLoc, Function<NBTTagCompound, IFilter> generator) {
        filterRegistry.put(resLoc, generator);
    }

    public static void registerFilter(IFilter filter) {
        FilterUtil.registerFilter(filter.getType(), tag -> filter);
    }

    public static IFilter deserializeFilter(NBTTagCompound tag) {
        ResourceLocation resLoc = new ResourceLocation(tag.func_74779_i("type"));
        Function<NBTTagCompound, IFilter> generator = filterRegistry.get(resLoc);
        if (generator != null) {
            return generator.apply(tag);
        }
        return FILTER_ANY;
    }

    public static List<IFilterComparator> getComparators(ItemStack stack1, ItemStack stack2) {
        ArrayList<IFilterComparator> matched = new ArrayList<IFilterComparator>();
        for (IFilterComparator comparator : comparators) {
            if (!comparator.match(stack1, stack2)) continue;
            matched.add(comparator);
        }
        if (matched.isEmpty()) {
            matched.add(ANY);
        }
        return matched;
    }

    public static IFilterComparator getComparator(String name) {
        return comparatorMap.get(name);
    }
}

