/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.research.subtypes;

import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import teamroots.embers.SoundManager;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchCategory;

public class ResearchSwitchCategory
extends ResearchBase {
    ResearchCategory targetCategory;
    int minEntries;

    public ResearchSwitchCategory(String location, ItemStack icon, double x, double y) {
        super(location, icon, x, y);
    }

    public ResearchSwitchCategory setTargetCategory(ResearchCategory category) {
        this.targetCategory = category;
        return this;
    }

    public ResearchSwitchCategory setMinEntries(int entries) {
        this.minEntries = entries;
        return this;
    }

    @Override
    public void getAllResearch(Set<ResearchBase> result) {
        if (result.contains(this)) {
            return;
        }
        this.targetCategory.getAllResearch(result);
    }

    @Override
    public void findByTag(String match, Map<ResearchBase, Integer> result, Set<ResearchCategory> categories) {
        int startResults = result.size();
        this.targetCategory.findByTag(match, result, categories);
        if (startResults != result.size()) {
            int categoryScore = result.entrySet().stream().filter(entry -> this.targetCategory.researches.contains(entry.getKey())).mapToInt(Map.Entry::getValue).max().orElse(0);
            result.put(this, categoryScore);
        }
    }

    @Override
    public boolean onOpen(GuiCodex gui) {
        gui.pushLastCategory(gui.researchCategory);
        gui.researchCategory = this.targetCategory;
        gui.playSound(SoundManager.CODEX_CATEGORY_SWITCH);
        return false;
    }

    @Override
    public void check(boolean checked) {
    }

    @Override
    public boolean isChecked() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.targetCategory.researches.size() < this.minEntries;
    }
}

